/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.orca;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.util.Durations;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ChannelLogger;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.ExperimentalApi;
import io.grpc.LoadBalancer;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.services.MetricReport;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.ForwardingSubchannel;
import io.grpc.xds.orca.OrcaPerRequestUtil;
import io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import io.grpc.xds.shaded.com.github.xds.service.orca.v3.OpenRcaServiceGrpc;
import io.grpc.xds.shaded.com.github.xds.service.orca.v3.OrcaLoadReportRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9129")
public final class OrcaOobUtil {
    private static final Logger logger = Logger.getLogger(OrcaPerRequestUtil.class.getName());
    static final Attributes.Key<SubchannelImpl> ORCA_REPORTING_STATE_KEY = Attributes.Key.create("internal-orca-reporting-state");

    private OrcaOobUtil() {
    }

    public static LoadBalancer.Helper newOrcaReportingHelper(LoadBalancer.Helper delegate) {
        return OrcaOobUtil.newOrcaReportingHelper(delegate, new ExponentialBackoffPolicy.Provider(), GrpcUtil.STOPWATCH_SUPPLIER);
    }

    @VisibleForTesting
    static LoadBalancer.Helper newOrcaReportingHelper(LoadBalancer.Helper delegate, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        return new OrcaReportingHelper(delegate, backoffPolicyProvider, stopwatchSupplier);
    }

    public static void setListener(LoadBalancer.Subchannel subchannel, OrcaOobReportListener listener, OrcaReportingConfig config) {
        SubchannelImpl orcaSubchannel = subchannel.getAttributes().get(ORCA_REPORTING_STATE_KEY);
        if (orcaSubchannel == null) {
            throw new IllegalArgumentException("Subchannel does not have orca Out-Of-Band stream enabled. Try to use a subchannel created by OrcaOobUtil.OrcaHelper.");
        }
        orcaSubchannel.orcaState.setListener(orcaSubchannel, listener, config);
    }

    public static final class OrcaReportingConfig {
        private final long reportIntervalNanos;

        private OrcaReportingConfig(long reportIntervalNanos) {
            this.reportIntervalNanos = reportIntervalNanos;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public long getReportIntervalNanos() {
            return this.reportIntervalNanos;
        }

        public Builder toBuilder() {
            return OrcaReportingConfig.newBuilder().setReportInterval(this.reportIntervalNanos, TimeUnit.NANOSECONDS);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("reportIntervalNanos", this.reportIntervalNanos).toString();
        }

        public static final class Builder {
            private long reportIntervalNanos;

            Builder() {
            }

            public Builder setReportInterval(long reportInterval, TimeUnit unit) {
                this.reportIntervalNanos = unit.toNanos(reportInterval);
                return this;
            }

            public OrcaReportingConfig build() {
                return new OrcaReportingConfig(this.reportIntervalNanos);
            }
        }
    }

    @VisibleForTesting
    static final class SubchannelImpl
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private final OrcaReportingHelper.OrcaReportingState orcaState;
        @Nullable
        private OrcaOobReportListener reportListener;

        SubchannelImpl(LoadBalancer.Subchannel delegate, OrcaReportingHelper.OrcaReportingState orcaState) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.orcaState = Preconditions.checkNotNull(orcaState, "orcaState");
        }

        @Override
        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        @Override
        public void start(LoadBalancer.SubchannelStateListener listener) {
            if (!this.orcaState.started) {
                this.orcaState.init(this, listener);
                super.start(this.orcaState);
            } else {
                super.start(listener);
            }
        }

        @Override
        public Attributes getAttributes() {
            return super.getAttributes().toBuilder().set(ORCA_REPORTING_STATE_KEY, this).build();
        }
    }

    static final class OrcaReportingHelper
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegate;
        private final SynchronizationContext syncContext;
        private final BackoffPolicy.Provider backoffPolicyProvider;
        private final Supplier<Stopwatch> stopwatchSupplier;

        OrcaReportingHelper(LoadBalancer.Helper delegate, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
            this.stopwatchSupplier = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier");
            this.syncContext = Preconditions.checkNotNull(delegate.getSynchronizationContext(), "syncContext");
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }

        @Override
        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            this.syncContext.throwIfNotInThisSynchronizationContext();
            LoadBalancer.Subchannel subchannel = super.createSubchannel(args);
            SubchannelImpl orcaSubchannel = subchannel.getAttributes().get(ORCA_REPORTING_STATE_KEY);
            OrcaReportingState orcaState = orcaSubchannel == null ? new OrcaReportingState(this.syncContext, this.delegate().getScheduledExecutorService()) : orcaSubchannel.orcaState;
            return new SubchannelImpl(subchannel, orcaState);
        }

        private final class OrcaReportingState
        implements LoadBalancer.SubchannelStateListener {
            private final SynchronizationContext syncContext;
            private final ScheduledExecutorService timeService;
            private final Map<OrcaOobReportListener, OrcaReportingConfig> configs = new HashMap<OrcaOobReportListener, OrcaReportingConfig>();
            @Nullable
            private LoadBalancer.Subchannel subchannel;
            @Nullable
            private ChannelLogger subchannelLogger;
            @Nullable
            private LoadBalancer.SubchannelStateListener stateListener;
            @Nullable
            private BackoffPolicy backoffPolicy;
            @Nullable
            private OrcaReportingStream orcaRpc;
            @Nullable
            private SynchronizationContext.ScheduledHandle retryTimer;
            @Nullable
            private OrcaReportingConfig overallConfig;
            private final Runnable retryTask = new Runnable(){

                @Override
                public void run() {
                    OrcaReportingState.this.startRpc();
                }
            };
            private ConnectivityStateInfo state = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
            private boolean disabled;
            private boolean started;

            OrcaReportingState(SynchronizationContext syncContext, ScheduledExecutorService timeService) {
                this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext");
                this.timeService = Preconditions.checkNotNull(timeService, "timeService");
            }

            void init(LoadBalancer.Subchannel subchannel, LoadBalancer.SubchannelStateListener stateListener) {
                Preconditions.checkState(this.subchannel == null, "init() already called");
                this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
                this.subchannelLogger = Preconditions.checkNotNull(subchannel.getChannelLogger(), "subchannelLogger");
                this.stateListener = Preconditions.checkNotNull(stateListener, "stateListener");
                this.started = true;
            }

            void setListener(final SubchannelImpl orcaSubchannel, final OrcaOobReportListener listener, final OrcaReportingConfig config) {
                this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        OrcaOobReportListener oldListener = orcaSubchannel.reportListener;
                        if (oldListener != null) {
                            OrcaReportingState.this.configs.remove(oldListener);
                        }
                        if (listener != null) {
                            OrcaReportingState.this.configs.put(listener, config);
                        }
                        orcaSubchannel.reportListener = listener;
                        OrcaReportingState.this.setReportingConfig(config);
                    }
                });
            }

            private void setReportingConfig(OrcaReportingConfig config) {
                boolean reconfigured = false;
                if (this.configs.isEmpty()) {
                    this.overallConfig = null;
                    reconfigured = true;
                } else if (this.overallConfig == null) {
                    this.overallConfig = config.toBuilder().build();
                    reconfigured = true;
                } else {
                    long minInterval = Long.MAX_VALUE;
                    for (OrcaReportingConfig c : this.configs.values()) {
                        if (c.getReportIntervalNanos() >= minInterval) continue;
                        minInterval = c.getReportIntervalNanos();
                    }
                    if (this.overallConfig.getReportIntervalNanos() != minInterval) {
                        this.overallConfig = this.overallConfig.toBuilder().setReportInterval(minInterval, TimeUnit.NANOSECONDS).build();
                        reconfigured = true;
                    }
                }
                if (reconfigured) {
                    this.stopRpc("ORCA reporting reconfigured");
                    this.adjustOrcaReporting();
                }
            }

            @Override
            public void onSubchannelState(ConnectivityStateInfo newState) {
                if (Objects.equal((Object)this.state.getState(), (Object)ConnectivityState.READY) && !Objects.equal((Object)newState.getState(), (Object)ConnectivityState.READY)) {
                    this.disabled = false;
                }
                this.state = newState;
                this.adjustOrcaReporting();
                this.stateListener.onSubchannelState(newState);
            }

            void adjustOrcaReporting() {
                if (!this.disabled && this.overallConfig != null && Objects.equal((Object)this.state.getState(), (Object)ConnectivityState.READY)) {
                    if (this.orcaRpc == null && !this.isRetryTimerPending()) {
                        this.startRpc();
                    }
                } else {
                    this.stopRpc("Client stops ORCA reporting");
                    this.backoffPolicy = null;
                }
            }

            void startRpc() {
                Preconditions.checkState(this.orcaRpc == null, "previous orca reporting RPC has not been cleaned up");
                Preconditions.checkState(this.subchannel != null, "init() not called");
                this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Starting ORCA reporting for {0}", this.subchannel.getAllAddresses());
                this.orcaRpc = new OrcaReportingStream(this.subchannel.asChannel(), (Stopwatch)OrcaReportingHelper.this.stopwatchSupplier.get());
                this.orcaRpc.start();
            }

            void stopRpc(String msg) {
                if (this.orcaRpc != null) {
                    this.orcaRpc.cancel(msg);
                    this.orcaRpc = null;
                }
                if (this.retryTimer != null) {
                    this.retryTimer.cancel();
                    this.retryTimer = null;
                }
            }

            boolean isRetryTimerPending() {
                return this.retryTimer != null && this.retryTimer.isPending();
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("disabled", this.disabled).add("orcaRpc", this.orcaRpc).add("reportingConfig", this.overallConfig).add("connectivityState", this.state).toString();
            }

            private class OrcaReportingStream
            extends ClientCall.Listener<OrcaLoadReport> {
                private final ClientCall<OrcaLoadReportRequest, OrcaLoadReport> call;
                private final Stopwatch stopwatch;
                private boolean callHasResponded;

                OrcaReportingStream(Channel channel, Stopwatch stopwatch) {
                    this.call = Preconditions.checkNotNull(channel, "channel").newCall(OpenRcaServiceGrpc.getStreamCoreMetricsMethod(), CallOptions.DEFAULT);
                    this.stopwatch = Preconditions.checkNotNull(stopwatch, "stopwatch");
                }

                void start() {
                    this.stopwatch.reset().start();
                    this.call.start(this, new Metadata());
                    this.call.sendMessage(OrcaLoadReportRequest.newBuilder().setReportInterval(Durations.fromNanos(OrcaReportingState.this.overallConfig.getReportIntervalNanos())).build());
                    this.call.halfClose();
                    this.call.request(1);
                }

                @Override
                public void onMessage(final OrcaLoadReport response) {
                    OrcaReportingState.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (OrcaReportingState.this.orcaRpc == OrcaReportingStream.this) {
                                OrcaReportingStream.this.handleResponse(response);
                            }
                        }
                    });
                }

                @Override
                public void onClose(final Status status, Metadata trailers) {
                    OrcaReportingState.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (OrcaReportingState.this.orcaRpc == OrcaReportingStream.this) {
                                OrcaReportingState.this.orcaRpc = null;
                                OrcaReportingStream.this.handleStreamClosed(status);
                            }
                        }
                    });
                }

                void handleResponse(OrcaLoadReport response) {
                    this.callHasResponded = true;
                    OrcaReportingState.this.backoffPolicy = null;
                    OrcaReportingState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received an ORCA report: {0}", response);
                    MetricReport metricReport = OrcaPerRequestUtil.fromOrcaLoadReport(response);
                    for (OrcaOobReportListener listener : OrcaReportingState.this.configs.keySet()) {
                        listener.onLoadReport(metricReport);
                    }
                    this.call.request(1);
                }

                void handleStreamClosed(Status status) {
                    if (Objects.equal((Object)status.getCode(), (Object)Status.Code.UNIMPLEMENTED)) {
                        OrcaReportingState.this.disabled = true;
                        logger.log(Level.SEVERE, "Backend {0} OpenRcaService is disabled. Server returned: {1}", new Object[]{OrcaReportingState.this.subchannel.getAllAddresses(), status});
                        OrcaReportingState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.ERROR, "OpenRcaService disabled: {0}", status);
                        return;
                    }
                    long delayNanos = 0L;
                    if (!this.callHasResponded) {
                        if (OrcaReportingState.this.backoffPolicy == null) {
                            OrcaReportingState.this.backoffPolicy = OrcaReportingHelper.this.backoffPolicyProvider.get();
                        }
                        delayNanos = OrcaReportingState.this.backoffPolicy.nextBackoffNanos() - this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
                    }
                    OrcaReportingState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "ORCA reporting stream closed with {0}, backoff in {1} ns", status, delayNanos <= 0L ? 0L : delayNanos);
                    if (delayNanos <= 0L) {
                        OrcaReportingState.this.startRpc();
                    } else {
                        Preconditions.checkState(!OrcaReportingState.this.isRetryTimerPending(), "Retry double scheduled");
                        OrcaReportingState.this.retryTimer = OrcaReportingState.this.syncContext.schedule(OrcaReportingState.this.retryTask, delayNanos, TimeUnit.NANOSECONDS, OrcaReportingState.this.timeService);
                    }
                }

                void cancel(String msg) {
                    this.call.cancel(msg, null);
                }

                public String toString() {
                    return MoreObjects.toStringHelper(this).add("callStarted", this.call != null).add("callHasResponded", this.callHasResponded).toString();
                }
            }
        }
    }

    public static interface OrcaOobReportListener {
        public void onLoadReport(MetricReport var1);
    }
}

