/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_TernaryExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class TernaryExpr
implements Expr {
    public abstract Expr conditionExpr();

    public abstract Expr thenExpr();

    public abstract Expr elseExpr();

    @Override
    public TypeNode type() {
        TypeNode thenType = this.thenExpr().type();
        TypeNode elseType = this.elseExpr().type();
        if (thenType.isPrimitiveType() || elseType.isPrimitiveType()) {
            return thenType.isPrimitiveType() ? elseType : thenType;
        }
        if (thenType.isSupertypeOrEquals(elseType) && !thenType.equals(TypeNode.NULL)) {
            return thenType;
        }
        return elseType;
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_TernaryExpr.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setConditionExpr(Expr var1);

        public abstract Builder setThenExpr(Expr var1);

        public abstract Builder setElseExpr(Expr var1);

        abstract Expr conditionExpr();

        abstract Expr thenExpr();

        abstract Expr elseExpr();

        abstract TernaryExpr autoBuild();

        public TernaryExpr build() {
            Preconditions.checkState(this.conditionExpr().type().equals(TypeNode.BOOLEAN), "Ternary condition must be a boolean-typed expression.");
            if (!this.thenExpr().type().equals(this.elseExpr().type())) {
                Preconditions.checkState(this.thenExpr().type().isSupertypeOrEquals(this.elseExpr().type()) || this.elseExpr().type().isSupertypeOrEquals(this.thenExpr().type()), "The second and third expressions must be assignable types of the other");
            }
            return this.autoBuild();
        }
    }
}

