/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.common;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.LongRunningClient;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.EmptyLineStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.IfStatement;
import com.google.api.generator.engine.ast.JavaDocComment;
import com.google.api.generator.engine.ast.LambdaExpr;
import com.google.api.generator.engine.ast.LogicalOperationExpr;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.NewObjectExpr;
import com.google.api.generator.engine.ast.OperationExpr;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.ReferenceConstructorExpr;
import com.google.api.generator.engine.ast.RelationalOperationExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.ThisObjectValue;
import com.google.api.generator.engine.ast.ThrowExpr;
import com.google.api.generator.engine.ast.TryCatchStatement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.comment.StubCommentComposer;
import com.google.api.generator.gapic.composer.common.ClassComposer;
import com.google.api.generator.gapic.composer.common.TransportContext;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.composer.utils.ClassNames;
import com.google.api.generator.gapic.composer.utils.PackageChecker;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.HttpBindings;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.RoutingHeaderRule;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.model.Transport;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.api.pathtemplate.PathTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.annotation.Nullable;

public abstract class AbstractTransportServiceStubClassComposer
implements ClassComposer {
    private static final Statement EMPTY_LINE_STATEMENT = EmptyLineStatement.create();
    private static final String METHOD_DESCRIPTOR_NAME_PATTERN = "%sMethodDescriptor";
    private static final String PAGED_RESPONSE_TYPE_NAME_PATTERN = "%sPagedResponse";
    private static final String PAGED_CALLABLE_CLASS_MEMBER_PATTERN = "%sPagedCallable";
    private static final String BACKGROUND_RESOURCES_MEMBER_NAME = "backgroundResources";
    private static final String CALLABLE_FACTORY_MEMBER_NAME = "callableFactory";
    protected static final String CALLABLE_CLASS_MEMBER_PATTERN = "%sCallable";
    private static final String OPERATION_CALLABLE_CLASS_MEMBER_PATTERN = "%sOperationCallable";
    protected static final TypeStore FIXED_TYPESTORE = AbstractTransportServiceStubClassComposer.createStaticTypes();
    private final TransportContext transportContext;

    protected AbstractTransportServiceStubClassComposer(TransportContext transportContext) {
        this.transportContext = transportContext;
    }

    public TransportContext getTransportContext() {
        return this.transportContext;
    }

    private static TypeStore createStaticTypes() {
        List<Class<?>> concreteClazzes = Arrays.asList(BackgroundResource.class, BackgroundResourceAggregation.class, BetaApi.class, BidiStreamingCallable.class, ClientContext.class, ClientStreamingCallable.class, Generated.class, ImmutableMap.class, InterruptedException.class, IOException.class, Operation.class, OperationCallable.class, OperationSnapshot.class, RequestParamsExtractor.class, UUID.class, ServerStreamingCallable.class, TimeUnit.class, TypeRegistry.class, UnaryCallable.class, UnsupportedOperationException.class);
        return new TypeStore(concreteClazzes);
    }

    @Override
    public GapicClass generate(GapicContext context, Service service) {
        VariableExpr longRunningVarExpr;
        boolean operationPollingMethod;
        if (!service.hasAnyEnabledMethodsForTransport(this.getTransportContext().transport())) {
            return GapicClass.createNonGeneratedGapicClass();
        }
        String pakkage = service.pakkage() + ".stub";
        TypeStore typeStore = this.createDynamicTypes(service, pakkage);
        String className = this.getTransportContext().classNames().getTransportServiceStubClassName(service);
        GapicClass.Kind kind = GapicClass.Kind.STUB;
        Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs = this.createProtoMethodNameToDescriptorClassMembers(service, this.getTransportContext().methodDescriptorClass());
        Map<String, VariableExpr> callableClassMemberVarExprs = this.createCallableClassMembers(service, typeStore);
        LinkedHashMap<String, VariableExpr> classMemberVarExprs = new LinkedHashMap<String, VariableExpr>();
        classMemberVarExprs.put(BACKGROUND_RESOURCES_MEMBER_NAME, VariableExpr.withVariable(Variable.builder().setName(BACKGROUND_RESOURCES_MEMBER_NAME).setType(FIXED_TYPESTORE.get("BackgroundResource")).build()));
        if (this.generateOperationsStubLogic(service)) {
            TypeNode operationsStubType = this.getTransportOperationsStubType(service);
            classMemberVarExprs.put(this.getTransportContext().transportOperationsStubNames().get(0), VariableExpr.withVariable(Variable.builder().setName(this.getTransportContext().transportOperationsStubNames().get(0)).setType(operationsStubType).build()));
        }
        if ((operationPollingMethod = this.checkOperationPollingMethod(service)) && (longRunningVarExpr = this.declareLongRunningClient()) != null) {
            classMemberVarExprs.put("longRunningClient", longRunningVarExpr);
        }
        classMemberVarExprs.put(CALLABLE_FACTORY_MEMBER_NAME, VariableExpr.withVariable(Variable.builder().setName(CALLABLE_FACTORY_MEMBER_NAME).setType(this.getTransportContext().stubCallableFactoryType()).build()));
        ImmutableMap<String, Message> messageTypes = context.messages();
        List<Statement> classStatements = this.createClassStatements(service, protoMethodNameToDescriptorVarExprs, callableClassMemberVarExprs, classMemberVarExprs, messageTypes, context.restNumericEnumsEnabled());
        List<MethodDefinition> methodDefinitions = this.createClassMethods(context, service, typeStore, classMemberVarExprs, callableClassMemberVarExprs, protoMethodNameToDescriptorVarExprs, classStatements);
        methodDefinitions.addAll(this.createStubOverrideMethods((VariableExpr)classMemberVarExprs.get(BACKGROUND_RESOURCES_MEMBER_NAME), service));
        StubCommentComposer commentComposer = new StubCommentComposer(this.getTransportContext().transportNames().get(0));
        ClassDefinition.Builder builder = ClassDefinition.builder().setPackageString(pakkage).setHeaderCommentStatements(commentComposer.createTransportServiceStubClassHeaderComments(service.name(), service.isDeprecated())).setAnnotations(this.createClassAnnotations(service)).setScope(ScopeNode.PUBLIC).setName(className);
        this.getTransportContext().classNames();
        ClassDefinition classDef = builder.setExtendsType(typeStore.get(ClassNames.getServiceStubClassName(service))).setMethods(methodDefinitions).setStatements(classStatements).build();
        return GapicClass.create(kind, classDef);
    }

    protected abstract Statement createMethodDescriptorVariableDecl(Service var1, Method var2, VariableExpr var3, Map<String, Message> var4, boolean var5);

    protected boolean generateOperationsStubLogic(Service service) {
        return true;
    }

    protected List<MethodDefinition> createOperationsStubGetterMethod(Service service, VariableExpr operationsStubVarExpr) {
        if (!this.generateOperationsStubLogic(service)) {
            return Collections.emptyList();
        }
        String methodName = String.format("get%s", JavaStyle.toUpperCamelCase(this.getTransportContext().transportOperationsStubNames().get(0)));
        return Arrays.asList(MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(operationsStubVarExpr.type()).setName(methodName).setReturnExpr(operationsStubVarExpr).build());
    }

    protected Expr createTransportSettingsInitExpr(Method method, VariableExpr transportSettingsVarExpr, VariableExpr methodDescriptorVarExpr, List<Statement> classStatements, ImmutableMap<String, Message> messageTypes) {
        MethodInvocationExpr callSettingsBuilderExpr = MethodInvocationExpr.builder().setStaticReferenceType(this.getTransportContext().transportCallSettingsType()).setGenerics(transportSettingsVarExpr.type().reference().generics()).setMethodName("newBuilder").build();
        callSettingsBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(callSettingsBuilderExpr).setMethodName("setMethodDescriptor").setArguments(Arrays.asList(methodDescriptorVarExpr)).build();
        if (this.getTransportContext().transport() == Transport.REST) {
            callSettingsBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(callSettingsBuilderExpr).setMethodName("setTypeRegistry").setArguments(Arrays.asList(VariableExpr.builder().setVariable(Variable.builder().setName("typeRegistry").setType(FIXED_TYPESTORE.get(TypeRegistry.class.getSimpleName())).build()).build())).build();
        }
        if (method.shouldSetParamsExtractor()) {
            callSettingsBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(callSettingsBuilderExpr).setMethodName("setParamsExtractor").setArguments(this.createRequestParamsExtractorClassInstance(method, classStatements)).build();
        }
        if (method.hasAutoPopulatedFields() && AbstractTransportServiceStubClassComposer.shouldGenerateRequestMutator(method, messageTypes).booleanValue()) {
            callSettingsBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(callSettingsBuilderExpr).setMethodName("setRequestMutator").setArguments(AbstractTransportServiceStubClassComposer.createRequestMutatorClassInstance(method, messageTypes)).build();
        }
        callSettingsBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(callSettingsBuilderExpr).setMethodName("build").setReturnType(transportSettingsVarExpr.type()).build();
        return AssignmentExpr.builder().setVariableExpr(transportSettingsVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(callSettingsBuilderExpr).build();
    }

    protected List<MethodDefinition> createGetMethodDescriptorsMethod(Service service, TypeStore typeStore, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs) {
        return Arrays.asList(new MethodDefinition[0]);
    }

    protected List<Statement> createTypeRegistry(Service service) {
        return Arrays.asList(new Statement[0]);
    }

    protected List<Statement> createClassStatements(Service service, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs, Map<String, VariableExpr> callableClassMemberVarExprs, Map<String, VariableExpr> classMemberVarExprs, Map<String, Message> messageTypes, boolean restNumericEnumsEnabled) {
        ArrayList<Statement> classStatements = new ArrayList<Statement>();
        classStatements.addAll(this.createTypeRegistry(service));
        if (!classStatements.isEmpty()) {
            classStatements.add(EMPTY_LINE_STATEMENT);
        }
        for (Statement statement : this.createMethodDescriptorVariableDecls(service, protoMethodNameToDescriptorVarExprs, messageTypes, restNumericEnumsEnabled)) {
            classStatements.add(statement);
            classStatements.add(EMPTY_LINE_STATEMENT);
        }
        classStatements.addAll(AbstractTransportServiceStubClassComposer.createClassMemberFieldDeclarations(callableClassMemberVarExprs));
        classStatements.add(EMPTY_LINE_STATEMENT);
        classStatements.addAll(AbstractTransportServiceStubClassComposer.createClassMemberFieldDeclarations(classMemberVarExprs));
        classStatements.add(EMPTY_LINE_STATEMENT);
        return classStatements;
    }

    protected List<Statement> createMethodDescriptorVariableDecls(Service service, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs, Map<String, Message> messageTypes, boolean restNumericEnumsEnabled) {
        return service.methods().stream().filter(x -> x.isSupportedByTransport(this.getTransportContext().transport())).map(m4 -> this.createMethodDescriptorVariableDecl(service, (Method)m4, (VariableExpr)protoMethodNameToDescriptorVarExprs.get(m4.name()), messageTypes, restNumericEnumsEnabled)).collect(Collectors.toList());
    }

    private static List<Statement> createClassMemberFieldDeclarations(Map<String, VariableExpr> fieldNameToVarExprs) {
        return fieldNameToVarExprs.values().stream().map(v -> ExprStatement.withExpr(v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsFinal(true).build())).collect(Collectors.toList());
    }

    protected Map<String, VariableExpr> createProtoMethodNameToDescriptorClassMembers(Service service, Class<?> descriptorClass) {
        return service.methods().stream().filter(x -> x.isSupportedByTransport(this.getTransportContext().transport())).collect(Collectors.toMap(Method::name, m4 -> VariableExpr.withVariable(Variable.builder().setName(String.format(METHOD_DESCRIPTOR_NAME_PATTERN, JavaStyle.toLowerCamelCase(m4.name()))).setType(TypeNode.withReference(ConcreteReference.builder().setClazz(descriptorClass).setGenerics(Arrays.asList(m4.inputType().reference(), m4.outputType().reference())).build())).build()), (u, v) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
    }

    private Map<String, VariableExpr> createCallableClassMembers(Service service, TypeStore typeStore) {
        LinkedHashMap<String, VariableExpr> callableClassMembers = new LinkedHashMap<String, VariableExpr>();
        for (Method protoMethod : service.methods()) {
            if (!protoMethod.isSupportedByTransport(this.getTransportContext().transport())) continue;
            String javaStyleProtoMethodName = JavaStyle.toLowerCamelCase(protoMethod.name());
            String callableName = String.format(CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName);
            callableClassMembers.put(callableName, this.getCallableExpr(protoMethod, callableName));
            if (protoMethod.hasLro()) {
                callableName = String.format(OPERATION_CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName);
                callableClassMembers.put(callableName, this.getOperationCallableExpr(protoMethod, callableName));
            }
            if (!protoMethod.isPaged()) continue;
            callableName = String.format(PAGED_CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName);
            callableClassMembers.put(callableName, this.getPagedCallableExpr(typeStore, protoMethod, callableName));
        }
        return callableClassMembers;
    }

    private VariableExpr getCallableExpr(Method protoMethod, String callableName) {
        return VariableExpr.withVariable(Variable.builder().setName(callableName).setType(AbstractTransportServiceStubClassComposer.getCallableType(protoMethod)).build());
    }

    private VariableExpr getPagedCallableExpr(TypeStore typeStore, Method protoMethod, String callableName) {
        return VariableExpr.withVariable(Variable.builder().setName(callableName).setType(TypeNode.withReference(AbstractTransportServiceStubClassComposer.getCallableType(protoMethod).reference().copyAndSetGenerics(Arrays.asList(protoMethod.inputType().reference(), typeStore.get(String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, protoMethod.name())).reference())))).build());
    }

    private VariableExpr getOperationCallableExpr(Method protoMethod, String callableName) {
        return VariableExpr.withVariable(Variable.builder().setName(callableName).setType(TypeNode.withReference(ConcreteReference.builder().setClazz(OperationCallable.class).setGenerics(Arrays.asList(protoMethod.inputType().reference(), protoMethod.lro().responseType().reference(), protoMethod.lro().metadataType().reference())).build())).build());
    }

    protected List<AnnotationNode> createClassAnnotations(Service service) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (!PackageChecker.isGaApi(service.pakkage())) {
            annotations.add(AnnotationNode.withType(FIXED_TYPESTORE.get("BetaApi")));
        }
        if (service.isDeprecated()) {
            annotations.add(AnnotationNode.withType(TypeNode.DEPRECATED));
        }
        annotations.add(AnnotationNode.builder().setType(FIXED_TYPESTORE.get("Generated")).setDescription("by gapic-generator-java").build());
        return annotations;
    }

    protected List<MethodDefinition> createClassMethods(GapicContext context, Service service, TypeStore typeStore, Map<String, VariableExpr> classMemberVarExprs, Map<String, VariableExpr> callableClassMemberVarExprs, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs, List<Statement> classStatements) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.addAll(this.createStaticCreatorMethods(service, typeStore, "newBuilder"));
        javaMethods.addAll(this.createConstructorMethods(context, service, typeStore, classMemberVarExprs, protoMethodNameToDescriptorVarExprs, classStatements));
        javaMethods.addAll(this.createGetMethodDescriptorsMethod(service, typeStore, protoMethodNameToDescriptorVarExprs));
        javaMethods.addAll(this.createOperationsStubGetterMethod(service, classMemberVarExprs.get(this.getTransportContext().transportOperationsStubNames().get(0))));
        javaMethods.addAll(AbstractTransportServiceStubClassComposer.createCallableGetterMethods(callableClassMemberVarExprs));
        return javaMethods;
    }

    protected List<MethodDefinition> createStaticCreatorMethods(Service service, TypeStore typeStore, String newBuilderMethod) {
        TypeNode creatorMethodReturnType = typeStore.get(this.getTransportContext().classNames().getTransportServiceStubClassName(service));
        Function<List, MethodDefinition.Builder> creatorMethodStarterFn = argList -> MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setIsStatic(true).setIsFinal(true).setReturnType(creatorMethodReturnType).setName("create").setArguments(argList.stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setThrowsExceptions(Arrays.asList(TypeNode.withReference(ConcreteReference.withClazz(IOException.class))));
        Function<List, Expr> instantiatorExprFn = argList -> NewObjectExpr.builder().setType(creatorMethodReturnType).setArguments((List<Expr>)argList).build();
        this.getTransportContext().classNames();
        TypeNode stubSettingsType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        VariableExpr settingsVarExpr = VariableExpr.withVariable(Variable.builder().setName("settings").setType(stubSettingsType).build());
        TypeNode clientContextType = FIXED_TYPESTORE.get("ClientContext");
        VariableExpr clientContextVarExpr = VariableExpr.withVariable(Variable.builder().setName("clientContext").setType(clientContextType).build());
        VariableExpr callableFactoryVarExpr = VariableExpr.withVariable(Variable.builder().setName(CALLABLE_FACTORY_MEMBER_NAME).setType(this.getTransportContext().stubCallableFactoryType()).build());
        MethodInvocationExpr clientContextCreateMethodExpr = MethodInvocationExpr.builder().setMethodName("create").setStaticReferenceType(clientContextType).setArguments(Arrays.asList(settingsVarExpr)).build();
        MethodInvocationExpr settingsBuilderMethodExpr = MethodInvocationExpr.builder().setMethodName(newBuilderMethod).setStaticReferenceType(stubSettingsType).build();
        settingsBuilderMethodExpr = MethodInvocationExpr.builder().setMethodName("build").setExprReferenceExpr(settingsBuilderMethodExpr).build();
        return Arrays.asList(creatorMethodStarterFn.apply(Arrays.asList(settingsVarExpr)).setReturnExpr(instantiatorExprFn.apply(Arrays.asList(settingsVarExpr, clientContextCreateMethodExpr))).build(), creatorMethodStarterFn.apply(Arrays.asList(clientContextVarExpr)).setReturnExpr(instantiatorExprFn.apply(Arrays.asList(settingsBuilderMethodExpr, clientContextVarExpr))).build(), creatorMethodStarterFn.apply(Arrays.asList(clientContextVarExpr, callableFactoryVarExpr)).setReturnExpr(instantiatorExprFn.apply(Arrays.asList(settingsBuilderMethodExpr, clientContextVarExpr, callableFactoryVarExpr))).build());
    }

    protected List<MethodDefinition> createConstructorMethods(GapicContext context, Service service, TypeStore typeStore, Map<String, VariableExpr> classMemberVarExprs, Map<String, VariableExpr> protoMethodNameToDescriptorVarExprs, List<Statement> classStatements) {
        this.getTransportContext().classNames();
        TypeNode stubSettingsType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        VariableExpr settingsVarExpr = VariableExpr.withVariable(Variable.builder().setName("settings").setType(stubSettingsType).build());
        TypeNode clientContextType = FIXED_TYPESTORE.get("ClientContext");
        VariableExpr clientContextVarExpr = VariableExpr.withVariable(Variable.builder().setName("clientContext").setType(clientContextType).build());
        VariableExpr callableFactoryVarExpr = VariableExpr.withVariable(Variable.builder().setName(CALLABLE_FACTORY_MEMBER_NAME).setType(this.getTransportContext().stubCallableFactoryType()).build());
        TypeNode thisClassType = typeStore.get(this.getTransportContext().classNames().getTransportServiceStubClassName(service));
        TypeNode ioExceptionType = TypeNode.withReference(ConcreteReference.withClazz(IOException.class));
        BiFunction<List, List, MethodDefinition> ctorMakerFn = (args, body) -> MethodDefinition.constructorBuilder().setScope(ScopeNode.PROTECTED).setReturnType(thisClassType).setHeaderCommentStatements(Arrays.asList(this.createProtectedCtorComment(service))).setArguments(args.stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setThrowsExceptions(Arrays.asList(ioExceptionType)).setBody((List<Statement>)body).build();
        MethodDefinition firstCtor = ctorMakerFn.apply(Arrays.asList(settingsVarExpr, clientContextVarExpr), Arrays.asList(ExprStatement.withExpr(ReferenceConstructorExpr.thisBuilder().setType(thisClassType).setArguments(settingsVarExpr, clientContextVarExpr, NewObjectExpr.builder().setType(typeStore.get(this.getTransportContext().classNames().getTransportServiceCallableFactoryClassName(service))).build()).build())));
        ValueExpr thisExpr = ValueExpr.withValue(ThisObjectValue.withType(typeStore.get(this.getTransportContext().classNames().getTransportServiceStubClassName(service))));
        ArrayList<Statement> secondCtorStatements = new ArrayList<Statement>();
        ArrayList<Expr> secondCtorExprs = new ArrayList<Expr>();
        secondCtorExprs.add(AssignmentExpr.builder().setVariableExpr(classMemberVarExprs.get(CALLABLE_FACTORY_MEMBER_NAME).toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(callableFactoryVarExpr).build());
        VariableExpr operationsStubClassVarExpr = classMemberVarExprs.get(this.getTransportContext().transportOperationsStubNames().get(0));
        if (this.generateOperationsStubLogic(service)) {
            secondCtorExprs.addAll(this.createOperationsStubInitExpr(context, service, thisExpr, operationsStubClassVarExpr, clientContextVarExpr, callableFactoryVarExpr));
        }
        secondCtorStatements.addAll(secondCtorExprs.stream().map(ExprStatement::withExpr).collect(Collectors.toList()));
        secondCtorExprs.clear();
        secondCtorStatements.add(EMPTY_LINE_STATEMENT);
        Map<String, VariableExpr> javaStyleMethodNameToTransportSettingsVarExprs = service.methods().stream().filter(x -> x.isSupportedByTransport(this.getTransportContext().transport())).collect(Collectors.toMap(m4 -> JavaStyle.toLowerCamelCase(m4.name()), m4 -> VariableExpr.withVariable(Variable.builder().setName(String.format("%sTransportSettings", JavaStyle.toLowerCamelCase(m4.name()))).setType(TypeNode.withReference(ConcreteReference.builder().setClazz(this.getTransportContext().callSettingsClass()).setGenerics(Arrays.asList(m4.inputType().reference(), m4.outputType().reference())).build())).build())));
        secondCtorExprs.addAll(service.methods().stream().filter(x -> x.isSupportedByTransport(this.getTransportContext().transport())).map(m4 -> this.createTransportSettingsInitExpr((Method)m4, (VariableExpr)javaStyleMethodNameToTransportSettingsVarExprs.get(JavaStyle.toLowerCamelCase(m4.name())), (VariableExpr)protoMethodNameToDescriptorVarExprs.get(m4.name()), classStatements, context.messages())).collect(Collectors.toList()));
        secondCtorStatements.addAll(secondCtorExprs.stream().map(ExprStatement::withExpr).collect(Collectors.toList()));
        secondCtorExprs.clear();
        secondCtorStatements.add(EMPTY_LINE_STATEMENT);
        for (Method method : service.methods()) {
            if (!method.isSupportedByTransport(this.getTransportContext().transport())) continue;
            secondCtorExprs.addAll(this.createCallableInitExprs(context, service, method, typeStore, callableFactoryVarExpr, settingsVarExpr, clientContextVarExpr, operationsStubClassVarExpr, thisExpr, javaStyleMethodNameToTransportSettingsVarExprs));
        }
        secondCtorStatements.addAll(secondCtorExprs.stream().map(ExprStatement::withExpr).collect(Collectors.toList()));
        secondCtorExprs.clear();
        secondCtorStatements.add(EMPTY_LINE_STATEMENT);
        secondCtorStatements.addAll(this.createLongRunningClient(service, typeStore));
        MethodInvocationExpr getBackgroundResourcesMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(clientContextVarExpr).setMethodName("getBackgroundResources").build();
        VariableExpr backgroundResourcesVarExpr = classMemberVarExprs.get(BACKGROUND_RESOURCES_MEMBER_NAME);
        secondCtorExprs.add(AssignmentExpr.builder().setVariableExpr(backgroundResourcesVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(NewObjectExpr.builder().setType(FIXED_TYPESTORE.get("BackgroundResourceAggregation")).setArguments(Arrays.asList(getBackgroundResourcesMethodExpr)).build()).build());
        secondCtorStatements.addAll(secondCtorExprs.stream().map(ExprStatement::withExpr).collect(Collectors.toList()));
        secondCtorExprs.clear();
        MethodDefinition secondCtor = ctorMakerFn.apply(Arrays.asList(settingsVarExpr, clientContextVarExpr, callableFactoryVarExpr), secondCtorStatements);
        return Arrays.asList(firstCtor, secondCtor);
    }

    protected List<Expr> createOperationsStubInitExpr(GapicContext context, Service service, Expr thisExpr, VariableExpr operationsStubClassVarExpr, VariableExpr clientContextVarExpr, VariableExpr callableFactoryVarExpr) {
        TypeNode operationsStubType = this.getTransportOperationsStubType(service);
        return Collections.singletonList(AssignmentExpr.builder().setVariableExpr(operationsStubClassVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(operationsStubType).setMethodName("create").setArguments(Arrays.asList(clientContextVarExpr, callableFactoryVarExpr)).setReturnType(operationsStubClassVarExpr.type()).build()).build());
    }

    protected List<Statement> createLongRunningClient(Service service, TypeStore typeStore) {
        return ImmutableList.of();
    }

    @Nullable
    protected VariableExpr declareLongRunningClient() {
        return null;
    }

    private List<Expr> createCallableInitExprs(GapicContext context, Service service, Method method, TypeStore typeStore, VariableExpr callableFactoryVarExpr, VariableExpr settingsVarExpr, VariableExpr clientContextVarExpr, VariableExpr operationsStubClassVarExpr, Expr thisExpr, Map<String, VariableExpr> javaStyleMethodNameToTransportSettingsVarExprs) {
        ArrayList<Expr> callableInitExprs = new ArrayList<Expr>();
        String javaStyleProtoMethodName = JavaStyle.toLowerCamelCase(method.name());
        Expr transportSettingsVarExpr = javaStyleMethodNameToTransportSettingsVarExprs.get(javaStyleProtoMethodName);
        Preconditions.checkNotNull(transportSettingsVarExpr, String.format("No transport settings variable found for method name %s", javaStyleProtoMethodName));
        VariableExpr callableVarExpr = this.getCallableExpr(method, String.format(CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName));
        List<Expr> creatorMethodArgVarExprs = Arrays.asList(transportSettingsVarExpr, MethodInvocationExpr.builder().setExprReferenceExpr(settingsVarExpr).setMethodName(String.format("%sSettings", javaStyleProtoMethodName)).build(), clientContextVarExpr);
        AssignmentExpr callableExpr = this.buildCallableTransportExpr(context, service, callableFactoryVarExpr, thisExpr, javaStyleProtoMethodName, callableVarExpr, creatorMethodArgVarExprs);
        callableInitExprs.add(callableExpr);
        if (method.isPaged()) {
            callableVarExpr = this.getPagedCallableExpr(typeStore, method, String.format(PAGED_CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName));
            callableExpr = this.buildCallableTransportExpr(context, service, callableFactoryVarExpr, thisExpr, javaStyleProtoMethodName, callableVarExpr, creatorMethodArgVarExprs);
            callableInitExprs.add(callableExpr);
        }
        if (method.hasLro()) {
            callableVarExpr = this.getOperationCallableExpr(method, String.format(OPERATION_CALLABLE_CLASS_MEMBER_PATTERN, javaStyleProtoMethodName));
            creatorMethodArgVarExprs = Arrays.asList(transportSettingsVarExpr, MethodInvocationExpr.builder().setExprReferenceExpr(settingsVarExpr).setMethodName(String.format("%sOperationSettings", javaStyleProtoMethodName)).build(), clientContextVarExpr, operationsStubClassVarExpr);
            callableExpr = this.buildCallableTransportExpr(context, service, callableFactoryVarExpr, thisExpr, javaStyleProtoMethodName, callableVarExpr, creatorMethodArgVarExprs);
            callableInitExprs.add(callableExpr);
        }
        return callableInitExprs;
    }

    private AssignmentExpr buildCallableTransportExpr(GapicContext context, Service service, VariableExpr callableFactoryVarExpr, Expr thisExpr, String methodName, VariableExpr callableVarExpr, List<Expr> creatorMethodArgVarExprs) {
        Optional<String> callableCreatorMethodName = this.getCallableCreatorMethodName(context, service, callableVarExpr.type(), JavaStyle.toUpperCamelCase(methodName));
        Expr initExpr = callableCreatorMethodName.isPresent() ? MethodInvocationExpr.builder().setExprReferenceExpr(callableFactoryVarExpr).setMethodName(callableCreatorMethodName.get()).setArguments(creatorMethodArgVarExprs).setReturnType(callableVarExpr.type()).build() : ValueExpr.createNullExpr();
        return AssignmentExpr.builder().setVariableExpr(callableVarExpr.toBuilder().setExprReferenceExpr(thisExpr).build()).setValueExpr(initExpr).build();
    }

    protected Optional<String> getCallableCreatorMethodName(GapicContext context, Service service, TypeNode callableVarExprType, String serviceMethodName) {
        GapicServiceConfig serviceConfig = context.serviceConfig();
        if (serviceConfig != null && serviceConfig.hasBatchingSetting(service.protoPakkage(), service.name(), serviceMethodName)) {
            return Optional.of("createBatchingCallable");
        }
        if (callableVarExprType.reference().generics().size() == 2 && ((Reference)callableVarExprType.reference().generics().get(1)).name().endsWith("PagedResponse")) {
            return Optional.of("createPagedCallable");
        }
        String typeName = callableVarExprType.reference().name();
        if (typeName.startsWith("Client")) {
            return Optional.of("createClientStreamingCallable");
        }
        if (typeName.startsWith("Server")) {
            return Optional.of("createServerStreamingCallable");
        }
        if (typeName.startsWith("Bidi")) {
            return Optional.of("createBidiStreamingCallable");
        }
        if (typeName.startsWith("Operation")) {
            return Optional.of("createOperationCallable");
        }
        return Optional.of("createUnaryCallable");
    }

    private static List<MethodDefinition> createCallableGetterMethods(Map<String, VariableExpr> callableClassMemberVarExprs) {
        return callableClassMemberVarExprs.entrySet().stream().map(e -> MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(((VariableExpr)e.getValue()).type()).setName((String)e.getKey()).setReturnExpr((Expr)e.getValue()).build()).collect(Collectors.toList());
    }

    private List<MethodDefinition> createStubOverrideMethods(VariableExpr backgroundResourcesVarExpr, Service service) {
        Function<String, MethodDefinition.Builder> methodMakerStarterFn = methodName -> MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setName((String)methodName);
        Function<String, MethodDefinition> voidMethodMakerFn = methodName -> ((MethodDefinition.Builder)methodMakerStarterFn.apply((String)methodName)).setReturnType(TypeNode.VOID).setBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(backgroundResourcesVarExpr).setMethodName((String)methodName).build()))).build();
        Function<String, MethodDefinition> booleanMethodMakerFn = methodName -> ((MethodDefinition.Builder)methodMakerStarterFn.apply((String)methodName)).setReturnType(TypeNode.BOOLEAN).setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(backgroundResourcesVarExpr).setMethodName((String)methodName).setReturnType(TypeNode.BOOLEAN).build()).build();
        VariableExpr catchRuntimeExceptionVarExpr = VariableExpr.builder().setVariable(Variable.builder().setType(TypeNode.withExceptionClazz(RuntimeException.class)).setName("e").build()).build();
        VariableExpr catchExceptionVarExpr = VariableExpr.builder().setVariable(Variable.builder().setType(TypeNode.withExceptionClazz(Exception.class)).setName("e").build()).build();
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        if (service.operationPollingMethod() != null) {
            javaMethods.addAll(this.createLongRunningClientGetters());
        }
        javaMethods.add(methodMakerStarterFn.apply("close").setIsFinal(true).setReturnType(TypeNode.VOID).setBody(Arrays.asList(TryCatchStatement.builder().setTryBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(backgroundResourcesVarExpr).setMethodName("close").build()))).addCatch(catchRuntimeExceptionVarExpr.toBuilder().setIsDecl(true).build(), Arrays.asList(ExprStatement.withExpr(ThrowExpr.builder().setThrowExpr(catchRuntimeExceptionVarExpr).build()))).addCatch(catchExceptionVarExpr.toBuilder().setIsDecl(true).build(), Arrays.asList(ExprStatement.withExpr(ThrowExpr.builder().setType(TypeNode.withExceptionClazz(IllegalStateException.class)).setMessageExpr("Failed to close resource").setCauseExpr(catchExceptionVarExpr).build()))).build())).build());
        javaMethods.add(voidMethodMakerFn.apply("shutdown"));
        javaMethods.add(booleanMethodMakerFn.apply("isShutdown"));
        javaMethods.add(booleanMethodMakerFn.apply("isTerminated"));
        javaMethods.add(voidMethodMakerFn.apply("shutdownNow"));
        List<VariableExpr> awaitTerminationArgs = Arrays.asList(VariableExpr.withVariable(Variable.builder().setName("duration").setType(TypeNode.LONG).build()), VariableExpr.withVariable(Variable.builder().setName("unit").setType(FIXED_TYPESTORE.get("TimeUnit")).build()));
        javaMethods.add(methodMakerStarterFn.apply("awaitTermination").setReturnType(TypeNode.BOOLEAN).setArguments(awaitTerminationArgs.stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setThrowsExceptions(Arrays.asList(FIXED_TYPESTORE.get("InterruptedException"))).setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(backgroundResourcesVarExpr).setMethodName("awaitTermination").setArguments(awaitTerminationArgs.stream().map(v -> v).collect(Collectors.toList())).setReturnType(TypeNode.BOOLEAN).build()).build());
        return javaMethods;
    }

    private boolean checkOperationPollingMethod(Service service) {
        return service.methods().stream().filter(x -> x.isSupportedByTransport(this.getTransportContext().transport())).anyMatch(Method::isOperationPollingMethod);
    }

    protected List<MethodDefinition> createLongRunningClientGetters() {
        VariableExpr longRunningClient = VariableExpr.withVariable(Variable.builder().setName("longRunningClient").setType(TypeNode.withReference(ConcreteReference.withClazz(LongRunningClient.class))).build());
        return ImmutableList.of(MethodDefinition.builder().setName("longRunningClient").setScope(ScopeNode.PUBLIC).setIsOverride(true).setReturnType(TypeNode.withReference(ConcreteReference.withClazz(LongRunningClient.class))).setReturnExpr(longRunningClient).build());
    }

    private TypeStore createDynamicTypes(Service service, String stubPakkage) {
        TypeStore typeStore = new TypeStore();
        String[] stringArray = new String[4];
        stringArray[0] = this.getTransportContext().classNames().getTransportServiceStubClassName(service);
        this.getTransportContext().classNames();
        stringArray[1] = ClassNames.getServiceStubSettingsClassName(service);
        this.getTransportContext().classNames();
        stringArray[2] = ClassNames.getServiceStubClassName(service);
        stringArray[3] = this.getTransportContext().classNames().getTransportServiceCallableFactoryClassName(service);
        typeStore.putAll(stubPakkage, Arrays.asList(stringArray));
        String string = service.pakkage();
        String[] stringArray2 = new String[1];
        this.getTransportContext().classNames();
        stringArray2[0] = ClassNames.getServiceClientClassName(service);
        typeStore.putAll(string, service.methods().stream().filter(x -> x.isSupportedByTransport(this.getTransportContext().transport())).filter(Method::isPaged).map(m4 -> String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, m4.name())).collect(Collectors.toList()), true, stringArray2);
        return typeStore;
    }

    protected static TypeNode getCallableType(Method protoMethod) {
        TypeNode callableType = FIXED_TYPESTORE.get("UnaryCallable");
        switch (protoMethod.stream()) {
            case CLIENT: {
                callableType = FIXED_TYPESTORE.get("ClientStreamingCallable");
                break;
            }
            case SERVER: {
                callableType = FIXED_TYPESTORE.get("ServerStreamingCallable");
                break;
            }
            case BIDI: {
                callableType = FIXED_TYPESTORE.get("BidiStreamingCallable");
                break;
            }
        }
        return TypeNode.withReference(callableType.reference().copyAndSetGenerics(Arrays.asList(protoMethod.inputType().reference(), protoMethod.outputType().reference())));
    }

    private CommentStatement createProtectedCtorComment(Service service) {
        return CommentStatement.withComment(JavaDocComment.withComment(String.format("Constructs an instance of %s, using the given settings. This is protected so that it is easy to make a subclass, but otherwise, the static factory methods should be  preferred.", this.getTransportContext().classNames().getTransportServiceStubClassName(service))));
    }

    protected String getProtoRpcFullMethodName(Service protoService, Method protoMethod) {
        if (protoMethod.isMixin()) {
            return String.format("%s/%s", protoMethod.mixedInApiName(), protoMethod.name());
        }
        return String.format("%s.%s/%s", protoService.protoPakkage(), protoService.name(), protoMethod.name());
    }

    protected TypeNode getTransportOperationsStubType(Service service) {
        TypeNode transportOpeationsStubType = service.operationServiceStubType();
        transportOpeationsStubType = transportOpeationsStubType == null ? this.getTransportContext().transportOperationsStubTypes().get(0) : TypeNode.withReference(VaporReference.builder().setName("HttpJson" + transportOpeationsStubType.reference().simpleName()).setPakkage(transportOpeationsStubType.reference().pakkage()).build());
        return transportOpeationsStubType;
    }

    protected static LambdaExpr createRequestMutatorClassInstance(Method method, ImmutableMap<String, Message> messageTypes) {
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        VariableExpr requestVarExpr = AbstractTransportServiceStubClassComposer.createRequestVarExpr(method);
        VaporReference requestBuilderRef = VaporReference.builder().setEnclosingClassNames(method.inputType().reference().name()).setName("Builder").setPakkage(method.inputType().reference().pakkage()).build();
        TypeNode requestBuilderType = TypeNode.withReference(requestBuilderRef);
        VariableExpr requestBuilderVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("requestBuilder").setType(requestBuilderType).build()).setIsDecl(true).build();
        MethodInvocationExpr setRequestBuilderInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(requestVarExpr).setMethodName("toBuilder").setReturnType(requestBuilderType).build();
        AssignmentExpr requestBuilderExpr = AssignmentExpr.builder().setVariableExpr(requestBuilderVarExpr).setValueExpr(setRequestBuilderInvocationExpr).build();
        bodyStatements.add(ExprStatement.withExpr(requestBuilderExpr));
        VariableExpr returnBuilderVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("requestBuilder").setType(requestBuilderType).build()).setIsDecl(false).build();
        MethodInvocationExpr.Builder returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnBuilderVarExpr).setMethodName("build");
        AbstractTransportServiceStubClassComposer.createRequestMutatorBody(method, messageTypes, bodyStatements, returnBuilderVarExpr);
        return LambdaExpr.builder().setArguments(requestVarExpr.toBuilder().setIsDecl(true).build()).setBody(bodyStatements).setReturnExpr(returnExpr.build()).build();
    }

    @VisibleForTesting
    static List<Statement> createRequestMutatorBody(Method method, ImmutableMap<String, Message> messageTypes, List<Statement> bodyStatements, VariableExpr returnBuilderVarExpr) {
        Message methodRequestMessage = messageTypes.get(method.inputType().reference().fullName());
        method.autoPopulatedFields().stream().map(fieldName -> methodRequestMessage.fields().stream().filter(field -> field.name().equals(fieldName)).findFirst()).filter(Optional::isPresent).map(Optional::get).filter(Field::canBeAutoPopulated).forEach(matchedField -> bodyStatements.add(AbstractTransportServiceStubClassComposer.createAutoPopulatedRequestStatement(method, matchedField.name(), returnBuilderVarExpr)));
        return bodyStatements;
    }

    @VisibleForTesting
    static Statement createAutoPopulatedRequestStatement(Method method, String fieldName, VariableExpr returnBuilderVarExpr) {
        VariableExpr requestVarExpr = AbstractTransportServiceStubClassComposer.createRequestVarExpr(method);
        MethodInvocationExpr getAutoPopulatedFieldInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(requestVarExpr).setMethodName(String.format("get%s", JavaStyle.toUpperCamelCase(fieldName))).setReturnType(TypeNode.STRING).build();
        VariableExpr stringsVar = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(ConcreteReference.withClazz(Strings.class))).setName("Strings").build());
        MethodInvocationExpr isNullOrEmptyFieldInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(stringsVar).setMethodName("isNullOrEmpty").setReturnType(TypeNode.BOOLEAN).setArguments(getAutoPopulatedFieldInvocationExpr).build();
        VariableExpr uuidVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(UUID.class).build())).setName("UUID").build());
        MethodInvocationExpr autoPopulatedFieldsArgsHelper = MethodInvocationExpr.builder().setExprReferenceExpr(uuidVarExpr).setMethodName("randomUUID").setReturnType(TypeNode.withReference(ConcreteReference.builder().setClazz(UUID.class).build())).build();
        MethodInvocationExpr autoPopulatedFieldsArgsToString = MethodInvocationExpr.builder().setExprReferenceExpr(autoPopulatedFieldsArgsHelper).setMethodName("toString").setReturnType(TypeNode.STRING).build();
        MethodInvocationExpr setAutoPopulatedFieldInvocationExpr = MethodInvocationExpr.builder().setArguments(autoPopulatedFieldsArgsToString).setExprReferenceExpr(returnBuilderVarExpr).setMethodName(String.format("set%s", JavaStyle.toUpperCamelCase(fieldName))).setReturnType(method.inputType()).build();
        return IfStatement.builder().setConditionExpr(isNullOrEmptyFieldInvocationExpr).setBody(Arrays.asList(ExprStatement.withExpr(setAutoPopulatedFieldInvocationExpr))).build();
    }

    @VisibleForTesting
    static Boolean shouldGenerateRequestMutator(Method method, ImmutableMap<String, Message> messageTypes) {
        if (method.inputType().reference() == null || method.inputType().reference().fullName() == null) {
            return false;
        }
        String methodRequestName = method.inputType().reference().fullName();
        Message methodRequestMessage = messageTypes.get(methodRequestName);
        if (methodRequestMessage == null || methodRequestMessage.fields() == null) {
            return false;
        }
        return method.autoPopulatedFields().stream().anyMatch(AbstractTransportServiceStubClassComposer.shouldAutoPopulate(methodRequestMessage));
    }

    private static Predicate<String> shouldAutoPopulate(Message methodRequestMessage) {
        return fieldName -> methodRequestMessage.fields().stream().anyMatch(field -> field.name().equals(fieldName) && field.canBeAutoPopulated());
    }

    protected LambdaExpr createRequestParamsExtractorClassInstance(Method method, List<Statement> classStatements) {
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        VariableExpr requestVarExpr = AbstractTransportServiceStubClassComposer.createRequestVarExpr(method);
        TypeNode returnType = TypeNode.withReference(ConcreteReference.builder().setClazz(Map.class).setGenerics(TypeNode.STRING.reference(), TypeNode.STRING.reference()).build());
        MethodInvocationExpr.Builder returnExpr = MethodInvocationExpr.builder().setReturnType(returnType);
        if (method.routingHeaderRule() == null) {
            this.createRequestParamsExtractorBodyForHttpBindings(method, requestVarExpr, bodyStatements, returnExpr);
        } else {
            this.createRequestParamsExtractorBodyForRoutingHeaders(method, requestVarExpr, classStatements, bodyStatements, returnExpr);
        }
        return LambdaExpr.builder().setArguments(requestVarExpr.toBuilder().setIsDecl(true).build()).setBody(bodyStatements).setReturnExpr(returnExpr.build()).build();
    }

    private void createRequestParamsExtractorBodyForHttpBindings(Method method, VariableExpr requestVarExpr, List<Statement> bodyStatements, MethodInvocationExpr.Builder returnExprBuilder) {
        TypeNode routingHeadersBuilderType = TypeNode.withReference(ConcreteReference.builder().setClazz(RequestParamsBuilder.class).build());
        VariableExpr routingHeadersBuilderVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("builder").setType(routingHeadersBuilderType).build()).setIsDecl(true).build();
        MethodInvocationExpr routingHeaderBuilderInvokeExpr = MethodInvocationExpr.builder().setStaticReferenceType(routingHeadersBuilderType).setMethodName("create").setReturnType(routingHeadersBuilderType).build();
        AssignmentExpr routingHeadersBuilderInitExpr = AssignmentExpr.builder().setVariableExpr(routingHeadersBuilderVarExpr).setValueExpr(routingHeaderBuilderInvokeExpr).build();
        bodyStatements.add(ExprStatement.withExpr(routingHeadersBuilderInitExpr));
        VariableExpr routingHeadersBuilderVarNonDeclExpr = VariableExpr.builder().setVariable(Variable.builder().setName("builder").setType(routingHeadersBuilderType).build()).build();
        for (HttpBindings.HttpBinding httpBindingFieldBinding : method.httpBindings().pathParameters()) {
            MethodInvocationExpr requestBuilderExpr = this.createRequestFieldGetterExpr(requestVarExpr, httpBindingFieldBinding.name(), httpBindingFieldBinding.field() != null && httpBindingFieldBinding.field().isEnum());
            MethodInvocationExpr valueOfExpr = MethodInvocationExpr.builder().setStaticReferenceType(TypeNode.STRING).setMethodName("valueOf").setArguments(requestBuilderExpr).build();
            MethodInvocationExpr paramsAddExpr = MethodInvocationExpr.builder().setExprReferenceExpr(routingHeadersBuilderVarNonDeclExpr).setMethodName("add").setArguments(ValueExpr.withValue(StringObjectValue.withValue(httpBindingFieldBinding.name())), valueOfExpr).build();
            bodyStatements.add(ExprStatement.withExpr(paramsAddExpr));
        }
        returnExprBuilder.setExprReferenceExpr(routingHeadersBuilderVarNonDeclExpr).setMethodName("build");
    }

    private void createRequestParamsExtractorBodyForRoutingHeaders(Method method, VariableExpr requestVarExpr, List<Statement> classStatements, List<Statement> bodyStatements, MethodInvocationExpr.Builder returnExprBuilder) {
        TypeNode routingHeadersBuilderType = TypeNode.withReference(ConcreteReference.builder().setClazz(RequestParamsBuilder.class).build());
        VariableExpr routingHeadersBuilderVarExpr = VariableExpr.builder().setVariable(Variable.builder().setName("builder").setType(routingHeadersBuilderType).build()).setIsDecl(true).build();
        MethodInvocationExpr routingHeaderBuilderInvokeExpr = MethodInvocationExpr.builder().setStaticReferenceType(routingHeadersBuilderType).setMethodName("create").setReturnType(routingHeadersBuilderType).build();
        AssignmentExpr routingHeadersBuilderInitExpr = AssignmentExpr.builder().setVariableExpr(routingHeadersBuilderVarExpr).setValueExpr(routingHeaderBuilderInvokeExpr).build();
        bodyStatements.add(ExprStatement.withExpr(routingHeadersBuilderInitExpr));
        ImmutableList<RoutingHeaderRule.RoutingHeaderParam> routingHeaderParams = method.routingHeaderRule().routingHeaderParams();
        VariableExpr routingHeadersBuilderVarNonDeclExpr = VariableExpr.builder().setVariable(Variable.builder().setName("builder").setType(routingHeadersBuilderType).build()).build();
        for (int i = 0; i < routingHeaderParams.size(); ++i) {
            RoutingHeaderRule.RoutingHeaderParam routingHeaderParam = (RoutingHeaderRule.RoutingHeaderParam)routingHeaderParams.get(i);
            MethodInvocationExpr requestFieldGetterExpr = this.createRequestFieldGetterExpr(requestVarExpr, routingHeaderParam.fieldName(), false);
            ValueExpr routingHeaderKeyExpr = ValueExpr.withValue(StringObjectValue.withValue(routingHeaderParam.key()));
            String pathTemplateName = String.format("%s_%s_PATH_TEMPLATE", JavaStyle.toUpperSnakeCase(method.name()), i);
            TypeNode pathTemplateType = TypeNode.withReference(ConcreteReference.withClazz(PathTemplate.class));
            Variable pathTemplateVar = Variable.builder().setType(pathTemplateType).setName(pathTemplateName).build();
            VariableExpr routingHeaderPatternExpr = VariableExpr.withVariable(pathTemplateVar);
            Statement pathTemplateClassVar = this.createPathTemplateClassStatement(routingHeaderParam, pathTemplateType, pathTemplateVar);
            classStatements.add(pathTemplateClassVar);
            MethodInvocationExpr addParamMethodExpr = MethodInvocationExpr.builder().setExprReferenceExpr(routingHeadersBuilderVarNonDeclExpr).setMethodName("add").setArguments(requestFieldGetterExpr, routingHeaderKeyExpr, routingHeaderPatternExpr).build();
            ExprStatement addParamStatement = ExprStatement.withExpr(addParamMethodExpr);
            if (routingHeaderParam.getDescendantFieldNames().size() == 1) {
                bodyStatements.add(addParamStatement);
                continue;
            }
            IfStatement ifStatement = IfStatement.builder().setConditionExpr(this.fieldValuesNotNullConditionExpr(requestVarExpr, routingHeaderParam.getDescendantFieldNames())).setBody(ImmutableList.of(addParamStatement)).build();
            bodyStatements.add(ifStatement);
        }
        returnExprBuilder.setExprReferenceExpr(routingHeadersBuilderVarNonDeclExpr).setMethodName("build");
    }

    private Statement createPathTemplateClassStatement(RoutingHeaderRule.RoutingHeaderParam routingHeaderParam, TypeNode pathTemplateType, Variable pathTemplateVar) {
        VariableExpr pathTemplateVarExpr = VariableExpr.builder().setVariable(pathTemplateVar).setIsDecl(true).setIsStatic(true).setIsFinal(true).setScope(ScopeNode.PRIVATE).build();
        ValueExpr valueExpr = ValueExpr.withValue(StringObjectValue.withValue(routingHeaderParam.pattern()));
        AssignmentExpr pathTemplateExpr = AssignmentExpr.builder().setVariableExpr(pathTemplateVarExpr).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(pathTemplateType).setMethodName("create").setArguments(valueExpr).setReturnType(pathTemplateType).build()).build();
        return ExprStatement.withExpr(pathTemplateExpr);
    }

    private Expr fieldValuesNotNullConditionExpr(VariableExpr requestVarExpr, List<String> fieldNames) {
        MethodInvocationExpr.Builder requestFieldGetterExprBuilder = MethodInvocationExpr.builder().setExprReferenceExpr(requestVarExpr);
        OperationExpr fieldValuesNotNullExpr = null;
        for (int i = 0; i < fieldNames.size() - 1; ++i) {
            String currFieldName = fieldNames.get(i);
            String bindingFieldMethodName = String.format("get%s", JavaStyle.toUpperCamelCase(currFieldName));
            requestFieldGetterExprBuilder = requestFieldGetterExprBuilder.setMethodName(bindingFieldMethodName);
            MethodInvocationExpr requestGetterExpr = requestFieldGetterExprBuilder.setReturnType(TypeNode.STRING).build();
            RelationalOperationExpr currentValueNotNullExpr = RelationalOperationExpr.notEqualToWithExprs(requestGetterExpr, ValueExpr.createNullExpr());
            fieldValuesNotNullExpr = fieldValuesNotNullExpr == null ? currentValueNotNullExpr : LogicalOperationExpr.logicalAndWithExprs(fieldValuesNotNullExpr, currentValueNotNullExpr);
            requestFieldGetterExprBuilder = MethodInvocationExpr.builder().setExprReferenceExpr(requestGetterExpr);
        }
        return fieldValuesNotNullExpr;
    }

    private MethodInvocationExpr createRequestFieldGetterExpr(VariableExpr requestVarExpr, String fieldName, boolean isFieldEnum) {
        MethodInvocationExpr.Builder requestFieldGetterExprBuilder = MethodInvocationExpr.builder().setExprReferenceExpr(requestVarExpr);
        List<String> descendantFields = Splitter.on(".").splitToList(fieldName);
        for (int i = 0; i < descendantFields.size(); ++i) {
            String currFieldName = descendantFields.get(i);
            String bindingFieldMethodName = String.format("get%s", JavaStyle.toUpperCamelCase(currFieldName));
            if (i == descendantFields.size() - 1 && isFieldEnum) {
                bindingFieldMethodName = bindingFieldMethodName + "Value";
            }
            requestFieldGetterExprBuilder = requestFieldGetterExprBuilder.setMethodName(bindingFieldMethodName);
            if (i >= descendantFields.size() - 1) continue;
            requestFieldGetterExprBuilder = MethodInvocationExpr.builder().setExprReferenceExpr(requestFieldGetterExprBuilder.build());
        }
        return requestFieldGetterExprBuilder.build();
    }

    private static VariableExpr createRequestVarExpr(Method method) {
        return VariableExpr.withVariable(Variable.builder().setType(method.inputType()).setName("request").build());
    }
}

