/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.generator.gapic.model.SourceCodeInfoLocation;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.Map;
import javax.annotation.Nullable;

public class SourceCodeInfoParser {
    private final Map<Descriptors.FileDescriptor, ImmutableListMultimap<String, DescriptorProtos.SourceCodeInfo.Location>> fileToPathToLocation = Maps.newHashMap();
    private final Map<Object, String> descriptorToPath = Maps.newHashMap();

    @Nullable
    public SourceCodeInfoLocation getLocation(Descriptors.Descriptor message) {
        Descriptors.FileDescriptor file = message.getFile();
        if (!file.toProto().hasSourceCodeInfo()) {
            return null;
        }
        return SourceCodeInfoLocation.create(this.getLocation(file, this.buildPath(message)));
    }

    @Nullable
    public SourceCodeInfoLocation getLocation(Descriptors.FieldDescriptor field) {
        Descriptors.FileDescriptor file = field.getFile();
        if (!file.toProto().hasSourceCodeInfo()) {
            return null;
        }
        DescriptorProtos.SourceCodeInfo.Location fieldLocation = this.getLocation(file, this.buildPath(field));
        return SourceCodeInfoLocation.create(fieldLocation);
    }

    @Nullable
    public SourceCodeInfoLocation getLocation(Descriptors.ServiceDescriptor service) {
        Descriptors.FileDescriptor file = service.getFile();
        if (!file.toProto().hasSourceCodeInfo()) {
            return null;
        }
        return SourceCodeInfoLocation.create(this.getLocation(file, this.buildPath(service)));
    }

    @Nullable
    public SourceCodeInfoLocation getLocation(Descriptors.MethodDescriptor method) {
        Descriptors.FileDescriptor file = method.getFile();
        if (!file.toProto().hasSourceCodeInfo()) {
            return null;
        }
        return SourceCodeInfoLocation.create(this.getLocation(file, this.buildPath(method)));
    }

    @Nullable
    public SourceCodeInfoLocation getLocation(Descriptors.EnumDescriptor enumType) {
        Descriptors.FileDescriptor file = enumType.getFile();
        if (!file.toProto().hasSourceCodeInfo()) {
            return null;
        }
        return SourceCodeInfoLocation.create(this.getLocation(file, this.buildPath(enumType)));
    }

    @Nullable
    public SourceCodeInfoLocation getLocation(Descriptors.EnumValueDescriptor enumValue) {
        Descriptors.FileDescriptor file = enumValue.getFile();
        if (!file.toProto().hasSourceCodeInfo()) {
            return null;
        }
        return SourceCodeInfoLocation.create(this.getLocation(file, this.buildPath(enumValue)));
    }

    @Nullable
    public SourceCodeInfoLocation getLocation(Descriptors.OneofDescriptor oneof) {
        Descriptors.FileDescriptor file = oneof.getFile();
        if (!file.toProto().hasSourceCodeInfo()) {
            return null;
        }
        return SourceCodeInfoLocation.create(this.getLocation(file, this.buildPath(oneof)));
    }

    private DescriptorProtos.SourceCodeInfo.Location getLocation(Descriptors.FileDescriptor file, String path) {
        ImmutableList<DescriptorProtos.SourceCodeInfo.Location> cands = this.getCandidateLocations(file, path);
        if (cands != null && cands.isEmpty()) {
            return null;
        }
        return (DescriptorProtos.SourceCodeInfo.Location)cands.get(0);
    }

    private ImmutableList<DescriptorProtos.SourceCodeInfo.Location> getCandidateLocations(Descriptors.FileDescriptor file, String path) {
        ImmutableListMultimap<String, DescriptorProtos.SourceCodeInfo.Location> locationMap = this.fileToPathToLocation.get(file);
        if (locationMap == null) {
            locationMap = Multimaps.index(file.toProto().getSourceCodeInfo().getLocationList(), new Function<DescriptorProtos.SourceCodeInfo.Location, String>(){

                @Override
                public String apply(DescriptorProtos.SourceCodeInfo.Location location) {
                    return Joiner.on('.').join(location.getPathList());
                }
            });
            this.fileToPathToLocation.put(file, locationMap);
        }
        return locationMap.get((Object)path);
    }

    private String buildPath(Descriptors.Descriptor message) {
        String path = this.descriptorToPath.get(message);
        if (path != null) {
            return path;
        }
        path = message.getContainingType() != null ? String.format("%s.%d.%d", this.buildPath(message.getContainingType()), 3, message.getContainingType().getNestedTypes().indexOf(message)) : String.format("%d.%d", 4, message.getFile().getMessageTypes().indexOf(message));
        this.descriptorToPath.put(message, path);
        return path;
    }

    private String buildPath(Descriptors.FieldDescriptor field) {
        String path = this.descriptorToPath.get(field);
        if (path != null) {
            return path;
        }
        path = field.isExtension() ? (field.getExtensionScope() == null ? String.format("%d.%d", 7, field.getFile().getExtensions().indexOf(field)) : String.format("%s.%d.%d", this.buildPath(field.getExtensionScope()), 6, field.getExtensionScope().getExtensions().indexOf(field))) : String.format("%s.%d.%d", this.buildPath(field.getContainingType()), 2, field.getContainingType().getFields().indexOf(field));
        this.descriptorToPath.put(field, path);
        return path;
    }

    private String buildPath(Descriptors.ServiceDescriptor service) {
        String path = this.descriptorToPath.get(service);
        if (path != null) {
            return path;
        }
        path = String.format("%d.%d", 6, service.getFile().getServices().indexOf(service));
        this.descriptorToPath.put(service, path);
        return path;
    }

    private String buildPath(Descriptors.MethodDescriptor method) {
        String path = this.descriptorToPath.get(method);
        if (path != null) {
            return path;
        }
        path = String.format("%s.%d.%d", this.buildPath(method.getService()), 2, method.getService().getMethods().indexOf(method));
        this.descriptorToPath.put(method, path);
        return path;
    }

    private String buildPath(Descriptors.EnumDescriptor enumType) {
        String path = this.descriptorToPath.get(enumType);
        if (path != null) {
            return path;
        }
        path = enumType.getContainingType() != null ? String.format("%s.%d.%d", this.buildPath(enumType.getContainingType()), 4, enumType.getContainingType().getEnumTypes().indexOf(enumType)) : String.format("%d.%d", 5, enumType.getFile().getEnumTypes().indexOf(enumType));
        this.descriptorToPath.put(enumType, path);
        return path;
    }

    private String buildPath(Descriptors.EnumValueDescriptor enumValue) {
        String path = this.descriptorToPath.get(enumValue);
        if (path != null) {
            return path;
        }
        path = String.format("%s.%d.%d", this.buildPath(enumValue.getType()), 2, enumValue.getType().getValues().indexOf(enumValue));
        this.descriptorToPath.put(enumValue, path);
        return path;
    }

    private String buildPath(Descriptors.OneofDescriptor oneof) {
        String path = this.descriptorToPath.get(oneof);
        if (path != null) {
            return path;
        }
        path = String.format("%s.%d.%d", this.buildPath(oneof.getContainingType()), 8, oneof.getContainingType().getOneofs().indexOf(oneof));
        this.descriptorToPath.put(oneof, path);
        return path;
    }
}

