package com.google.api.gax.httpjson;

import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_HttpJsonMetadata extends HttpJsonMetadata {

  private final Map<String, Object> headers;

  private final String statusMessage;

  private final Throwable exception;

  private AutoValue_HttpJsonMetadata(
      Map<String, Object> headers,
      @Nullable String statusMessage,
      @Nullable Throwable exception) {
    this.headers = headers;
    this.statusMessage = statusMessage;
    this.exception = exception;
  }

  @Override
  public Map<String, Object> getHeaders() {
    return headers;
  }

  @Nullable
  @Override
  public String getStatusMessage() {
    return statusMessage;
  }

  @Nullable
  @Override
  public Throwable getException() {
    return exception;
  }

  @Override
  public String toString() {
    return "HttpJsonMetadata{"
        + "headers=" + headers + ", "
        + "statusMessage=" + statusMessage + ", "
        + "exception=" + exception
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof HttpJsonMetadata) {
      HttpJsonMetadata that = (HttpJsonMetadata) o;
      return this.headers.equals(that.getHeaders())
          && (this.statusMessage == null ? that.getStatusMessage() == null : this.statusMessage.equals(that.getStatusMessage()))
          && (this.exception == null ? that.getException() == null : this.exception.equals(that.getException()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= headers.hashCode();
    h$ *= 1000003;
    h$ ^= (statusMessage == null) ? 0 : statusMessage.hashCode();
    h$ *= 1000003;
    h$ ^= (exception == null) ? 0 : exception.hashCode();
    return h$;
  }

  @Override
  public HttpJsonMetadata.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends HttpJsonMetadata.Builder {
    private Map<String, Object> headers;
    private String statusMessage;
    private Throwable exception;
    Builder() {
    }
    private Builder(HttpJsonMetadata source) {
      this.headers = source.getHeaders();
      this.statusMessage = source.getStatusMessage();
      this.exception = source.getException();
    }
    @Override
    HttpJsonMetadata.Builder setHeaders(Map<String, Object> headers) {
      if (headers == null) {
        throw new NullPointerException("Null headers");
      }
      this.headers = headers;
      return this;
    }
    @Override
    public HttpJsonMetadata.Builder setStatusMessage(String statusMessage) {
      this.statusMessage = statusMessage;
      return this;
    }
    @Override
    public HttpJsonMetadata.Builder setException(Throwable exception) {
      this.exception = exception;
      return this;
    }
    @Override
    HttpJsonMetadata build() {
      if (this.headers == null) {
        String missing = " headers";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_HttpJsonMetadata(
          this.headers,
          this.statusMessage,
          this.exception);
    }
  }

}
