/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.impl;

import com.google.apphosting.runtime.security.WhiteList;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlackList {
    private static final Logger logger = Logger.getLogger(BlackList.class.getName());
    private static Set<String> blackList = new HashSet<String>();

    private static void initBlackList() {
        Set<File> jreJars = BlackList.getCurrentJreJars();
        for (File f : jreJars) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(f);
            }
            catch (IOException e) {
                String string = String.valueOf(f.getAbsolutePath());
                logger.logp(Level.SEVERE, "com.google.appengine.tools.development.agent.impl.BlackList", "initBlackList", string.length() != 0 ? "Unable to read a jre library while constructing the blacklist. Security restrictions may not be entirely emulated. ".concat(string) : new String("Unable to read a jre library while constructing the blacklist. Security restrictions may not be entirely emulated. "));
                continue;
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String className;
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || !BlackList.isBlackListed(className = entryName.replace('/', '.').substring(0, entryName.length() - ".class".length()))) continue;
                blackList.add(className.replace('.', '/'));
            }
        }
        blackList = Collections.unmodifiableSet(blackList);
    }

    private static boolean isBlackListed(String className) {
        Set<String> whiteList = WhiteList.getWhiteList();
        if (whiteList.contains(className)) {
            return false;
        }
        return !className.startsWith("com.sun.xml.internal.bind.");
    }

    public static Set<String> getBlackList() {
        return blackList;
    }

    private static Set<File> getCurrentJreJars() {
        return BlackList.getJreJars(System.getProperty("java.home"));
    }

    private static Set<File> getJreJars(String jreHome) {
        HashSet<File> matchingFiles = new HashSet<File>();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        String string = String.valueOf(File.separator);
        BlackList.getFilesRecursive(matchingFiles, new File(new StringBuilder(3 + String.valueOf(jreHome).length() + String.valueOf(string).length()).append(jreHome).append(string).append("lib").toString()), filter);
        return matchingFiles;
    }

    private static void getFilesRecursive(Set<File> matchingFiles, File dir, FilenameFilter filter) {
        File[] files;
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                BlackList.getFilesRecursive(matchingFiles, f, filter);
                continue;
            }
            if (!filter.accept(dir, f.getName())) continue;
            matchingFiles.add(f);
        }
    }

    static {
        BlackList.initBlackList();
    }
}

