/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.ExtendableProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtoString;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Extensions {

    public static class LazyParsingException
    extends RuntimeException {
        public LazyParsingException(String s) {
            super(s);
        }
    }

    public static final class RepeatedExtension<E extends ExtendableProtocolMessage<E>, T>
    extends Extension<E, List<T>> {
        private final Extension<E, T> unitExtension;

        protected RepeatedExtension(Extension<E, T> unitExtension) {
            this.unitExtension = unitExtension;
        }

        @Override
        protected int getWireTag() {
            return this.unitExtension.getWireTag();
        }

        protected final T unitDefaultValue() {
            return this.unitExtension.newValue();
        }

        @Override
        protected final List<T> defaultValue() {
            return Collections.emptyList();
        }

        @Override
        protected final List<T> newValue() {
            return Lists.newArrayList();
        }

        @Override
        protected final List<T> readFromRepeatedTags(List<ByteBuffer> allSourceData) {
            ArrayList<T> result = Lists.newArrayList();
            for (ByteBuffer b : allSourceData) {
                result.add(this.unitExtension.readOne(b.asReadOnlyBuffer()));
            }
            return result;
        }

        @Override
        protected List<T> unmodifiable(List<T> data) {
            return ProtocolSupport.unmodifiableList(data);
        }

        @Override
        protected final List<T> merge(List<T> mergeInto, List<T> mergeFrom) {
            mergeInto.addAll(mergeFrom);
            return mergeInto;
        }

        @Override
        protected final List<T> readOne(ByteBuffer arg0) {
            throw new UnsupportedOperationException("readOne not supported for repeated extensions");
        }

        @Override
        protected final void write(List<T> allData, ProtocolSink sink) {
            for (T data : allData) {
                this.unitExtension.write(data, sink);
            }
        }

        @Override
        protected final int encodingSize(List<T> data) {
            int size = 0;
            for (T t : data) {
                size += this.unitExtension.encodingSize(t);
            }
            return size;
        }
    }

    public static final class MessageExtension<E extends ExtendableProtocolMessage<E>, P extends ProtocolMessage<P>>
    extends Extension<E, P> {
        private final int wireTag;
        private final P defaultInstance;

        public MessageExtension(int wireTag, P defaultInstance) {
            this.wireTag = wireTag;
            this.defaultInstance = defaultInstance;
        }

        @Override
        protected int getWireTag() {
            return this.wireTag;
        }

        @Override
        protected final P defaultValue() {
            return (P)((ProtocolMessage)this.defaultInstance).getDefaultInstanceForType();
        }

        @Override
        protected final P newValue() {
            return (P)((ProtocolMessage)this.defaultInstance).newInstance();
        }

        @Override
        protected final P readFromRepeatedTags(List<ByteBuffer> allSourceData) throws LazyParsingException {
            Object result = null;
            for (ByteBuffer extData : allSourceData) {
                if (result == null) {
                    result = this.newValue();
                }
                this.mergeSerialized(result, extData.asReadOnlyBuffer());
            }
            return (P)result;
        }

        @Override
        protected P unmodifiable(P data) {
            return data;
        }

        @Override
        protected final P merge(P mergeInto, P mergeFrom) {
            ((ProtocolMessage)mergeInto).mergeFrom(mergeFrom);
            return mergeInto;
        }

        @Override
        protected final P readOne(ByteBuffer source) throws LazyParsingException {
            Object result = this.newValue();
            this.mergeSerialized(result, source);
            return (P)result;
        }

        @Override
        protected final void write(P data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putForeign((ProtocolMessage)data);
        }

        @Override
        protected final int encodingSize(P data) {
            int encodingSize = ((ProtocolMessage)data).encodingSize();
            return Protocol.varIntSize(this.wireTag) + Protocol.varIntSize(encodingSize) + encodingSize;
        }

        private final void mergeSerialized(P mergeInto, ByteBuffer source) throws LazyParsingException {
            ProtocolSource protoSource = new ProtocolSource(source);
            protoSource.push(protoSource.getVarInt());
            if (!((ProtocolMessage)mergeInto).mergeFrom(protoSource)) {
                throw new LazyParsingException("Unable to parse " + mergeInto.getClass() + " proto from " + source);
            }
        }
    }

    public static final class StringExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, ProtoString> {
        public StringExtension(int wireTag, ProtoString defaultValue) {
            super(wireTag, defaultValue);
        }

        @Override
        protected final ProtoString readOne(ByteBuffer source) {
            return new ProtoString(Protocol.getPrefixedData(source));
        }

        @Override
        protected final void write(ProtoString data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putPrefixedData(data.getAsBytes());
        }

        @Override
        protected final int encodingSize(ProtoString dataString) {
            byte[] data = dataString.getAsBytes();
            return Protocol.varIntSize(this.wireTag) + Protocol.varIntSize(data.length) + data.length;
        }
    }

    public static final class DoubleExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Double> {
        public DoubleExtension(int wireTag, Double defaultValue) {
            super(wireTag, defaultValue);
        }

        @Override
        protected final Double readOne(ByteBuffer source) {
            return new ProtocolSource(source).getDouble();
        }

        @Override
        protected final void write(Double data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putDouble(data);
        }

        @Override
        protected final int encodingSize(Double data) {
            return Protocol.varIntSize(this.wireTag) + 8;
        }
    }

    public static final class FloatExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Float> {
        public FloatExtension(int wireTag, Float defaultValue) {
            super(wireTag, defaultValue);
        }

        @Override
        protected final Float readOne(ByteBuffer source) {
            return Float.valueOf(new ProtocolSource(source).getFloat());
        }

        @Override
        protected final void write(Float data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putFloat(data.floatValue());
        }

        @Override
        protected final int encodingSize(Float data) {
            return Protocol.varIntSize(this.wireTag) + 4;
        }
    }

    public static final class FixedLongExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Long> {
        public FixedLongExtension(int wireTag, Long defaultValue) {
            super(wireTag, defaultValue);
        }

        @Override
        protected final Long readOne(ByteBuffer source) {
            return new ProtocolSource(source).getLong();
        }

        @Override
        protected final void write(Long data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putLong(data);
        }

        @Override
        protected final int encodingSize(Long data) {
            return Protocol.varIntSize(this.wireTag) + 8;
        }
    }

    public static final class LongExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Long> {
        public LongExtension(int wireTag, Long defaultValue) {
            super(wireTag, defaultValue);
        }

        @Override
        protected final Long readOne(ByteBuffer source) {
            return Protocol.getVarLong(source);
        }

        @Override
        protected final void write(Long data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putVarLong(data);
        }

        @Override
        protected final int encodingSize(Long data) {
            return Protocol.varIntSize(this.wireTag) + Protocol.varLongSize(data);
        }
    }

    public static final class FixedIntegerExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Integer> {
        public FixedIntegerExtension(int wireTag, Integer defaultValue) {
            super(wireTag, defaultValue);
        }

        @Override
        protected final Integer readOne(ByteBuffer source) {
            return new ProtocolSource(source).getInt();
        }

        @Override
        protected final void write(Integer data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putInt(data);
        }

        @Override
        protected final int encodingSize(Integer data) {
            return Protocol.varIntSize(this.wireTag) + 4;
        }
    }

    public static final class IntegerExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Integer> {
        public IntegerExtension(int wireTag, Integer defaultValue) {
            super(wireTag, defaultValue);
        }

        @Override
        protected final Integer readOne(ByteBuffer source) {
            return Protocol.getVarInt(source);
        }

        @Override
        protected final void write(Integer data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putVarInt(data);
        }

        @Override
        protected final int encodingSize(Integer data) {
            return Protocol.varIntSize(this.wireTag) + Protocol.varLongSize(data.intValue());
        }
    }

    public static final class BooleanExtension<E extends ExtendableProtocolMessage<E>>
    extends PrimitiveExtension<E, Boolean> {
        public BooleanExtension(int wireTag, Boolean defaultValue) {
            super(wireTag, defaultValue);
        }

        @Override
        protected final Boolean readOne(ByteBuffer source) {
            return new ProtocolSource(source).getBoolean();
        }

        @Override
        protected final void write(Boolean data, ProtocolSink sink) {
            sink.putVarInt(this.wireTag);
            sink.putBoolean(data);
        }

        @Override
        protected final int encodingSize(Boolean data) {
            return Protocol.varIntSize(this.wireTag) + 1;
        }
    }

    public static abstract class PrimitiveExtension<E extends ExtendableProtocolMessage<E>, T>
    extends Extension<E, T> {
        protected final int wireTag;
        private final T defaultValue;

        private PrimitiveExtension(int wireTag, T defaultValue) {
            this.wireTag = wireTag;
            this.defaultValue = defaultValue;
        }

        @Override
        protected int getWireTag() {
            return this.wireTag;
        }

        @Override
        protected T defaultValue() {
            return this.defaultValue;
        }

        @Override
        protected T newValue() {
            return this.defaultValue;
        }

        @Override
        protected T readFromRepeatedTags(List<ByteBuffer> allSourceData) {
            return this.readOne(allSourceData.get(allSourceData.size() - 1).asReadOnlyBuffer());
        }

        @Override
        protected T merge(T mergeInto, T mergeFrom) {
            return mergeFrom;
        }

        @Override
        protected abstract T readOne(ByteBuffer var1);

        @Override
        protected T unmodifiable(T data) {
            return data;
        }

        @Override
        protected abstract void write(T var1, ProtocolSink var2);

        @Override
        protected abstract int encodingSize(T var1);
    }

    public static abstract class Extension<E extends ExtendableProtocolMessage<E>, T>
    implements Serializable {
        public final RepeatedExtension<E, T> asRepeated() {
            return new RepeatedExtension(this);
        }

        protected abstract int getWireTag();

        protected abstract T defaultValue();

        protected abstract T newValue();

        protected abstract T readFromRepeatedTags(List<ByteBuffer> var1);

        protected abstract T merge(T var1, T var2);

        protected abstract T readOne(ByteBuffer var1);

        protected abstract T unmodifiable(T var1);

        protected abstract void write(T var1, ProtocolSink var2);

        protected abstract int encodingSize(T var1);
    }
}

