/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.CallableStatement;
import com.google.cloud.sql.jdbc.DatabaseMetaData;
import com.google.cloud.sql.jdbc.PreparedStatement;
import com.google.cloud.sql.jdbc.Savepoint;
import com.google.cloud.sql.jdbc.Statement;
import com.google.cloud.sql.jdbc.internal.ClientSideBlob;
import com.google.cloud.sql.jdbc.internal.ClientSideClob;
import com.google.cloud.sql.jdbc.internal.ClientSideNClob;
import com.google.cloud.sql.jdbc.internal.ConnectionOperationHelper;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.Observer;
import com.google.cloud.sql.jdbc.internal.Observers;
import com.google.cloud.sql.jdbc.internal.SQLFeatureNotYetImplementedException;
import com.google.cloud.sql.jdbc.internal.SQLUnknownConnectionIdException;
import com.google.cloud.sql.jdbc.internal.SqlClient;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.jdbc.internal.Wrapper;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataResponse;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Connection
extends Wrapper
implements java.sql.Connection {
    private static final Logger log = Logger.getLogger(Connection.class.getName());
    static final int NO_TIMEOUT = 0;
    private final SqlClient client;
    private final ByteString connectionId;
    private final Url url;
    private final Observers<Connection> observers;
    private volatile boolean autoCommit = true;
    private volatile String catalog;
    private volatile boolean open;
    private volatile boolean readOnly;
    private volatile int transactionIsolationLevel = 4;
    private final Object databaseMetadataLock = new Object();
    private MetadataResponse databaseMetadata;

    public Connection(Url url, SqlClient client, ByteString connectionId) {
        this.client = client;
        this.connectionId = connectionId;
        this.url = url;
        this.observers = Observers.create();
        this.open = true;
        String database = url.getDatabase();
        if (database != null) {
            this.catalog = database;
        }
        log.finest("Connection: " + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (!this.open) {
            return;
        }
        this.closeLocalStateOnly();
        try {
            new ConnectionCloser(this.client, this.connectionId).close();
        }
        finally {
            this.observers.notifyObserversAndClear(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLocalStateOnly() {
        this.open = false;
        Object object = this.databaseMetadataLock;
        synchronized (object) {
            this.databaseMetadata = null;
        }
    }

    @Override
    public void commit() throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.commit());
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.getHoldability());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfNotOpen();
        Util.checkArgument(resultSetType == 1003 || resultSetType == 1004 || resultSetType == 1005, "resultSetType", resultSetType);
        Util.checkArgument(resultSetConcurrency == 1007 || resultSetConcurrency == 1008, "resultSetConcurrency", resultSetConcurrency);
        Util.checkArgument(resultSetHoldability == 1 || resultSetHoldability == 2, "resultSetHoldability", resultSetHoldability);
        return new Statement(resultSetType, resultSetConcurrency, resultSetHoldability, this, this.url);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfNotOpen();
        return new PreparedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, this, this.url);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.throwIfNotOpen();
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.throwIfNotOpen();
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.setCatalog(catalog));
        this.catalog = catalog;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.throwIfNotOpen();
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.throwIfNotOpen();
        Object object = this.databaseMetadataLock;
        synchronized (object) {
            if (this.databaseMetadata == null) {
                this.databaseMetadata = this.getMetadata(SqlRpcOptions.defaultOptions(), Client.MetadataType.METADATATYPE_DATABASE_METADATA_BASIC, Collections.<Client.BindVariableProto>emptyList());
            }
        }
        return new DatabaseMetaData(this.databaseMetadata.getJdbcDatabaseMetadata(), this, this.url);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.throwIfNotOpen();
        return this.transactionIsolationLevel;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    @Override
    public void rollback() throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.rollback());
    }

    @Override
    public void rollback(java.sql.Savepoint savepoint) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.rollback(savepoint.getSavepointName()));
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.autoCommit(autoCommit));
        this.autoCommit = autoCommit;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.throwIfNotOpen();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.throwIfNotOpen();
        return new ClientSideBlob(new byte[0]);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.throwIfNotOpen();
        return new ClientSideClob(new char[0]);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.throwIfNotOpen();
        return new ClientSideNClob(new char[0]);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.throwIfNotOpen();
        return new Properties();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.throwIfNotOpen();
        return this.readOnly;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        Util.checkArgument(timeout >= 0, "timeout", timeout);
        if (!this.open) {
            return false;
        }
        try {
            SqlRpcOptions options = SqlRpcOptions.defaultOptions();
            if (timeout == 0) {
                options.clearQueryTimeOutMillis();
            } else {
                options.setQueryTimeOutMillis(TimeUnit.SECONDS.toMillis(timeout));
            }
            this.executeOp(options, ConnectionOperationHelper.ping());
            return true;
        }
        catch (SQLFeatureNotYetImplementedException e) {
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.throwIfNotOpen();
        ExecOpResponse response = this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.nativeSQL(sql));
        return response.getNativeSql();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.throwIfNotOpen();
        return this.prepareCall(sql, 1003, 1007, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.throwIfNotOpen();
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.throwIfNotOpen();
        return new CallableStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, this, this.url);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement stmt = this.prepareStatement(sql, 1003, 1007, 2);
        stmt.setIncludeExportedKeys(autoGeneratedKeys == 1);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt = this.prepareStatement(sql, 1003, 1007, 2);
        stmt.setGeneratedColumnIndices(columnIndexes);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt = this.prepareStatement(sql, 1003, 1007, 2);
        stmt.setGeneratedColumnNames(columnNames);
        return stmt;
    }

    @Override
    public void releaseSavepoint(java.sql.Savepoint savepoint) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (!this.open) {
            throw Exceptions.newClientInfoConnectionClosedException();
        }
        throw Exceptions.newClientInfoNotSupportedException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (!this.open) {
            throw Exceptions.newClientInfoConnectionClosedException();
        }
        throw Exceptions.newClientInfoNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.throwIfNotOpen();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.readOnly(readOnly));
        this.readOnly = readOnly;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.throwIfNotOpen();
        ExecOpResponse response = this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.savePoint(name));
        return ConnectionOperationHelper.asJdbcSavePoint(response.getSavepoint());
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.throwIfNotOpen();
        this.executeOp(SqlRpcOptions.defaultOptions(), ConnectionOperationHelper.transactionIsolation(level));
        this.transactionIsolationLevel = level;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.throwIfNotOpen();
    }

    @Override
    public String getSchema() throws SQLException {
        this.throwIfNotOpen();
        return null;
    }

    @Override
    public void abort(Executor executor) {
        if (!this.open) {
            return;
        }
        this.closeLocalStateOnly();
        executor.execute(new ConnectionCloser(this.client, this.connectionId));
        this.observers.notifyObserversAndClear(this);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    ExecResponse executeSql(SqlRpcOptions options, String sql) throws SQLException {
        try {
            return this.client.executeSql(options, this.connectionId, sql);
        }
        catch (SQLException e) {
            throw this.closeLocalStateIfUnknownConnection(e);
        }
    }

    private SQLException closeLocalStateIfUnknownConnection(SQLException e) throws SQLException {
        if (e instanceof SQLUnknownConnectionIdException) {
            this.closeLocalStateOnly();
        }
        throw e;
    }

    ExecResponse executeSql(SqlRpcOptions options, String sql, List<Client.BindVariableProto> bindParameters) throws SQLException {
        try {
            return this.client.executeSql(options, this.connectionId, sql, bindParameters);
        }
        catch (SQLException e) {
            throw this.closeLocalStateIfUnknownConnection(e);
        }
    }

    ExecResponse executeBatchSql(SqlRpcOptions options, String sql, List<List<Client.BindVariableProto>> batchBindParameters) throws SQLException {
        try {
            return this.client.executeBatchSql(options, this.connectionId, sql, batchBindParameters);
        }
        catch (SQLException e) {
            throw this.closeLocalStateIfUnknownConnection(e);
        }
    }

    ExecResponse executeBatchSql(SqlRpcOptions options, List<String> batchSql) throws SQLException {
        try {
            return this.client.executeBatchSql(options, this.connectionId, batchSql);
        }
        catch (SQLException e) {
            throw this.closeLocalStateIfUnknownConnection(e);
        }
    }

    ExecResponse executeNext(SqlRpcOptions options, long statementId) throws SQLException {
        try {
            return this.client.executeNext(options, this.connectionId, statementId);
        }
        catch (SQLException e) {
            throw this.closeLocalStateIfUnknownConnection(e);
        }
    }

    ExecOpResponse executeOp(SqlRpcOptions options, Client.OpProto op) throws SQLException {
        try {
            return this.client.executeOperation(options, this.connectionId, op);
        }
        catch (SQLException e) {
            throw this.closeLocalStateIfUnknownConnection(e);
        }
    }

    ExecOpResponse getMoreResults(SqlRpcOptions options, long statementId) throws SQLException {
        return this.executeOp(options, ConnectionOperationHelper.nextResult(statementId));
    }

    MetadataResponse getMetadata(SqlRpcOptions options, Client.MetadataType metadataType, List<Client.BindVariableProto> bindParameters) throws SQLException {
        try {
            return this.client.getMetadata(options, this.connectionId, metadataType, bindParameters);
        }
        catch (SQLException e) {
            throw this.closeLocalStateIfUnknownConnection(e);
        }
    }

    String getUrl() {
        return this.url.getOriginalUrl();
    }

    void addObserver(Observer<Connection> observer) {
        this.observers.add(observer);
    }

    void removeObserver(Observer<Connection> observer) {
        this.observers.remove(observer);
    }

    private void throwIfNotOpen() throws SQLException {
        if (!this.open) {
            throw Exceptions.newConnectionClosedException();
        }
    }

    private static class ConnectionCloser
    implements Runnable {
        private static final Logger logger = Logger.getLogger(ConnectionCloser.class.getCanonicalName());
        private final SqlClient client;
        private final ByteString connectionId;

        ConnectionCloser(SqlClient client, ByteString connectionId) {
            this.client = client;
            this.connectionId = connectionId;
        }

        public void close() throws SQLException {
            CloseConnectionResponse response = this.client.closeConnection(SqlRpcOptions.defaultOptions(), this.connectionId);
            if (response.hasSqlException()) {
                throw Exceptions.newSqlException(response.getSqlException());
            }
        }

        @Override
        public void run() {
            try {
                this.close();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Caught exception closing connection.", e);
            }
        }
    }
}

