/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Conversion;
import com.google.appengine.api.conversion.ConversionErrorCode;
import com.google.appengine.api.conversion.ConversionRequestProtoConverter;
import com.google.appengine.api.conversion.ConversionResult;
import com.google.appengine.api.conversion.ConversionResultProtoConverter;
import com.google.appengine.api.conversion.ConversionService;
import com.google.appengine.api.conversion.ConversionServiceException;
import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;

class ConversionServiceImpl
implements ConversionService {
    static final String CONVERSION_SERVICE = "conversion";
    static final String CONVERT_METHOD = "Convert";
    Logger logger = Logger.getLogger(this.getClass().getName());
    private final ConversionRequestProtoConverter conversionRequestProtoConverter = new ConversionRequestProtoConverter();
    private final ConversionResultProtoConverter conversionResultProtoConverter = new ConversionResultProtoConverter();
    private final Double deadline;

    ConversionServiceImpl() {
        this.deadline = null;
    }

    ConversionServiceImpl(double deadline) {
        this.deadline = deadline;
    }

    @Override
    public ConversionResult convert(Conversion conversion) {
        List<ConversionResult> results = this.convert(Arrays.asList(conversion));
        return results.get(0);
    }

    @Override
    public List<ConversionResult> convert(List<Conversion> conversions) {
        try {
            return this.convertAsync(conversions).get();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf(e.getCause(), ConversionServiceException.class);
            throw new ConversionServiceException(ConversionErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ConversionServiceException(ConversionErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public Future<ConversionResult> convertAsync(Conversion conversion) {
        this.logger.warning("The Conversion API will be decommissioned in November 2012 and all calls to it will return an error.");
        ConversionServicePb.ConversionRequest request = (ConversionServicePb.ConversionRequest)this.conversionRequestProtoConverter.convert(Arrays.asList(conversion));
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(CONVERSION_SERVICE, CONVERT_METHOD, request.toByteArray(), this.createApiConfig(this.deadline));
        return new ConversionFutureWrapper<byte[], ConversionResult>(responseBytes){

            @Override
            protected ConversionResult wrap(byte[] responseBytes) throws IOException {
                ConversionServicePb.ConversionResponse.Builder response = (ConversionServicePb.ConversionResponse.Builder)ConversionServicePb.ConversionResponse.newBuilder().mergeFrom(responseBytes);
                return (ConversionResult)ConversionServiceImpl.this.conversionResultProtoConverter.reverse(response.getResultList().get(0));
            }
        };
    }

    @Override
    public Future<List<ConversionResult>> convertAsync(List<Conversion> conversions) {
        this.logger.warning("The Conversion API will be decommissioned in November 2012 and all calls to it will return an error.");
        ConversionServicePb.ConversionRequest request = (ConversionServicePb.ConversionRequest)this.conversionRequestProtoConverter.convert(conversions);
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(CONVERSION_SERVICE, CONVERT_METHOD, request.toByteArray(), this.createApiConfig(this.deadline));
        return new ConversionFutureWrapper<byte[], List<ConversionResult>>(responseBytes){

            @Override
            protected List<ConversionResult> wrap(byte[] responseBytes) throws IOException {
                ConversionServicePb.ConversionResponse.Builder response = (ConversionServicePb.ConversionResponse.Builder)ConversionServicePb.ConversionResponse.newBuilder().mergeFrom(responseBytes);
                ArrayList<ConversionResult> results = Lists.newArrayList();
                for (ConversionServicePb.ConversionOutput result : response.getResultList()) {
                    results.add((ConversionResult)ConversionServiceImpl.this.conversionResultProtoConverter.reverse(result));
                }
                return results;
            }
        };
    }

    private ApiProxy.ApiConfig createApiConfig(Double deadline) {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(deadline);
        return apiConfig;
    }

    private static abstract class ConversionFutureWrapper<K, V>
    extends FutureWrapper<K, V> {
        ConversionFutureWrapper(Future<K> parent) {
            super(parent);
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            if (cause instanceof ApiProxy.ApplicationException) {
                ApiProxy.ApplicationException e = (ApiProxy.ApplicationException)cause;
                return new ConversionServiceException(ConversionErrorCode.intToEnum(e.getApplicationError()), e.getErrorDetail());
            }
            if (cause instanceof ApiProxy.ApiDeadlineExceededException) {
                return new ConversionServiceException(ConversionErrorCode.TIMEOUT, cause.getMessage());
            }
            return cause;
        }
    }
}

