/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.InternalTransientException;
import com.google.appengine.api.urlfetch.ResponseTooLargeException;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;

class URLFetchServiceImpl
implements URLFetchService {
    static final String PACKAGE = "urlfetch";
    private static final Logger logger = Logger.getLogger(URLFetchServiceImpl.class.getName());

    URLFetchServiceImpl() {
    }

    @Override
    public HTTPResponse fetch(URL url) throws IOException {
        return this.fetch(new HTTPRequest(url));
    }

    @Override
    public HTTPResponse fetch(HTTPRequest request) throws IOException {
        byte[] responseBytes;
        URLFetchServicePb.URLFetchRequest requestProto = this.convertToPb(request);
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Fetch", requestProto.toByteArray(), this.createApiConfig(request.getFetchOptions()));
        }
        catch (ApiProxy.ApplicationException ex) {
            Throwable cause = this.convertApplicationException(requestProto, ex);
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (ApiProxy.ApiDeadlineExceededException ex) {
            throw new SocketTimeoutException("Timeout while fetching: " + requestProto.getUrl());
        }
        URLFetchServicePb.URLFetchResponse responseProto = ((URLFetchServicePb.URLFetchResponse.Builder)URLFetchServicePb.URLFetchResponse.newBuilder().mergeFrom(responseBytes)).build();
        if (!request.getFetchOptions().getAllowTruncate() && responseProto.getContentWasTruncated()) {
            throw new ResponseTooLargeException(request.getURL().toString());
        }
        return this.convertFromPb(responseProto);
    }

    @Override
    public Future<HTTPResponse> fetchAsync(URL url) {
        return this.fetchAsync(new HTTPRequest(url));
    }

    @Override
    public Future<HTTPResponse> fetchAsync(final HTTPRequest request) {
        final URLFetchServicePb.URLFetchRequest requestProto = this.convertToPb(request);
        Future<byte[]> response = ApiProxy.makeAsyncCall(PACKAGE, "Fetch", requestProto.toByteArray(), this.createApiConfig(request.getFetchOptions()));
        return new FutureWrapper<byte[], HTTPResponse>(response){

            @Override
            protected HTTPResponse wrap(byte[] responseBytes) throws IOException {
                URLFetchServicePb.URLFetchResponse responseProto = ((URLFetchServicePb.URLFetchResponse.Builder)URLFetchServicePb.URLFetchResponse.newBuilder().mergeFrom(responseBytes)).build();
                if (!request.getFetchOptions().getAllowTruncate() && responseProto.getContentWasTruncated()) {
                    throw new ResponseTooLargeException(request.getURL().toString());
                }
                return URLFetchServiceImpl.this.convertFromPb(responseProto);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    return URLFetchServiceImpl.this.convertApplicationException(requestProto, (ApiProxy.ApplicationException)cause);
                }
                if (cause instanceof ApiProxy.ApiDeadlineExceededException) {
                    return new SocketTimeoutException("Timeout while fetching: " + requestProto.getUrl());
                }
                return cause;
            }
        };
    }

    private ApiProxy.ApiConfig createApiConfig(FetchOptions options) {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(options.getDeadline());
        return apiConfig;
    }

    private String getURLExceptionMessage(String formatString, String url, String errorDetail) {
        if (errorDetail == null || errorDetail.trim().equals("")) {
            return String.format(formatString, url);
        }
        return String.format(formatString + ", error: %s", url, errorDetail);
    }

    private Throwable convertApplicationException(URLFetchServicePb.URLFetchRequest request, ApiProxy.ApplicationException ex) {
        URLFetchServicePb.URLFetchServiceError.ErrorCode errorCode = URLFetchServicePb.URLFetchServiceError.ErrorCode.valueOf(ex.getApplicationError());
        String errorDetail = ex.getErrorDetail();
        switch (errorCode) {
            case INVALID_URL: {
                return new MalformedURLException(this.getURLExceptionMessage("Invalid URL specified: %s", request.getUrl(), errorDetail));
            }
            case CLOSED: {
                return new IOException(this.getURLExceptionMessage("Connection closed unexpectedly by server at URL: %s", request.getUrl(), null));
            }
            case TOO_MANY_REDIRECTS: {
                return new IOException(this.getURLExceptionMessage("Too many redirects at URL: %s with redirect=true", request.getUrl(), null));
            }
            case MALFORMED_REPLY: {
                return new IOException(this.getURLExceptionMessage("Malformed HTTP reply received from server at URL: %s", request.getUrl(), errorDetail));
            }
            case RESPONSE_TOO_LARGE: {
                return new ResponseTooLargeException(request.getUrl());
            }
            case DNS_ERROR: {
                return new UnknownHostException(this.getURLExceptionMessage("DNS host lookup failed for URL: %s", request.getUrl(), null));
            }
            case FETCH_ERROR: {
                return new IOException(this.getURLExceptionMessage("Could not fetch URL: %s", request.getUrl(), null));
            }
            case INTERNAL_TRANSIENT_ERROR: {
                return new InternalTransientException(request.getUrl());
            }
            case DEADLINE_EXCEEDED: {
                return new SocketTimeoutException(this.getURLExceptionMessage("Timeout while fetching URL: %s", request.getUrl(), null));
            }
            case SSL_CERTIFICATE_ERROR: {
                return new SSLHandshakeException(this.getURLExceptionMessage("Could not verify SSL certificate for URL: %s", request.getUrl(), null));
            }
        }
        return new IOException(ex.getErrorDetail());
    }

    private URLFetchServicePb.URLFetchRequest convertToPb(HTTPRequest request) {
        URLFetchServicePb.URLFetchRequest.Builder requestProto = URLFetchServicePb.URLFetchRequest.newBuilder();
        requestProto.setUrl(request.getURL().toExternalForm());
        byte[] payload = request.getPayload();
        if (payload != null) {
            requestProto.setPayload(ByteString.copyFrom(payload));
        }
        switch (request.getMethod()) {
            case GET: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.GET);
                break;
            }
            case POST: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.POST);
                break;
            }
            case HEAD: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.HEAD);
                break;
            }
            case PUT: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.PUT);
                break;
            }
            case DELETE: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.DELETE);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown method: " + (Object)((Object)request.getMethod()));
            }
        }
        for (HTTPHeader header : request.getHeaders()) {
            URLFetchServicePb.URLFetchRequest.Header.Builder headerProto = URLFetchServicePb.URLFetchRequest.Header.newBuilder();
            headerProto.setKey(header.getName());
            headerProto.setValue(header.getValue());
            requestProto.addHeader(headerProto);
        }
        requestProto.setFollowRedirects(request.getFetchOptions().getFollowRedirects());
        switch (request.getFetchOptions().getCertificateValidationBehavior()) {
            case VALIDATE: {
                requestProto.setMustValidateServerCertificate(true);
                break;
            }
            case DO_NOT_VALIDATE: {
                requestProto.setMustValidateServerCertificate(false);
                break;
            }
        }
        return requestProto.build();
    }

    private HTTPResponse convertFromPb(URLFetchServicePb.URLFetchResponse responseProto) {
        HTTPResponse response = new HTTPResponse(responseProto.getStatusCode());
        if (responseProto.hasContent()) {
            response.setContent(responseProto.getContent().toByteArray());
        }
        for (URLFetchServicePb.URLFetchResponse.Header header : responseProto.getHeaderList()) {
            response.addHeader(header.getKey(), header.getValue());
        }
        if (responseProto.hasFinalUrl() && responseProto.getFinalUrl().length() > 0) {
            try {
                response.setFinalUrl(new URL(responseProto.getFinalUrl()));
            }
            catch (MalformedURLException e) {
                logger.severe("malformed final URL: " + e);
            }
        }
        return response;
    }
}

