/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AbstractIterator;
import com.google.appengine.repackaged.com.google.common.collect.Cut;
import com.google.appengine.repackaged.com.google.common.collect.Range;
import com.google.appengine.repackaged.com.google.common.collect.RangeSet;
import java.util.Iterator;
import javax.annotation.Nullable;

abstract class AbstractRangeSet<C extends Comparable>
implements RangeSet<C> {
    AbstractRangeSet() {
    }

    @Override
    public boolean contains(C value) {
        return this.rangeContaining(value) != null;
    }

    @Override
    public Range<C> rangeContaining(C value) {
        Preconditions.checkNotNull(value);
        for (Range<C> range : this.asRanges()) {
            if (!range.contains(value)) continue;
            return range;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.asRanges().isEmpty();
    }

    final Iterator<Range<C>> standardComplementIterator() {
        return new AbstractIterator<Range<C>>(){
            final Iterator<Range<C>> positiveIterator;
            Cut<C> prevCut;
            {
                this.positiveIterator = AbstractRangeSet.this.asRanges().iterator();
                this.prevCut = Cut.belowAll();
            }

            @Override
            protected Range<C> computeNext() {
                while (this.positiveIterator.hasNext()) {
                    Cut oldCut = this.prevCut;
                    Range positiveRange = this.positiveIterator.next();
                    this.prevCut = positiveRange.upperBound;
                    if (oldCut.compareTo(positiveRange.lowerBound) >= 0) continue;
                    return new Range(oldCut, positiveRange.lowerBound);
                }
                Cut posInfinity = Cut.aboveAll();
                if (this.prevCut.compareTo(posInfinity) < 0) {
                    Range result = new Range(this.prevCut, posInfinity);
                    this.prevCut = posInfinity;
                    return result;
                }
                return (Range)this.endOfData();
            }
        };
    }

    @Override
    public void add(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean enclosesAll(RangeSet<C> other) {
        for (Range<C> range : other.asRanges()) {
            if (this.encloses(range)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addAll(RangeSet<C> other) {
        for (Range<C> range : other.asRanges()) {
            this.add(range);
        }
    }

    @Override
    public void removeAll(RangeSet<C> other) {
        for (Range<C> range : other.asRanges()) {
            this.remove(range);
        }
    }

    @Override
    public boolean encloses(Range<C> otherRange) {
        for (Range<C> range : this.asRanges()) {
            if (!range.encloses(otherRange)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof RangeSet) {
            RangeSet other = (RangeSet)obj;
            return ((Object)this.asRanges()).equals(other.asRanges());
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this.asRanges()).hashCode();
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (Range range : this.asRanges()) {
            builder.append(range);
        }
        builder.append('}');
        return builder.toString();
    }
}

