/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableAsList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
abstract class ImmutableMapKeySet<K, V>
extends ImmutableSet<K> {
    ImmutableMapKeySet() {
    }

    abstract ImmutableMap<K, V> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return new UnmodifiableIterator<K>(){
            final UnmodifiableIterator<Map.Entry<K, V>> entryIterator;
            {
                this.entryIterator = ((ImmutableSet)ImmutableMapKeySet.this.map().entrySet()).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public K next() {
                return ((Map.Entry)this.entryIterator.next()).getKey();
            }
        };
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map().containsKey(object);
    }

    @Override
    ImmutableList<K> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map().entrySet())).asList();
        return new ImmutableAsList<K>(){

            @Override
            public K get(int index) {
                return ((Map.Entry)entryList.get(index)).getKey();
            }

            @Override
            ImmutableCollection<K> delegateCollection() {
                return ImmutableMapKeySet.this;
            }
        };
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map());
    }

    @GwtIncompatible(value="serialization")
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

