/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.AbstractRangeSet;
import com.google.appengine.repackaged.com.google.common.collect.Cut;
import com.google.appengine.repackaged.com.google.common.collect.ForwardingCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableRangeSet;
import com.google.appengine.repackaged.com.google.common.collect.Range;
import com.google.appengine.repackaged.com.google.common.collect.RangeSet;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;

@GwtIncompatible(value="uses NavigableMap")
public final class TreeRangeSet<C extends Comparable<?>>
extends AbstractRangeSet<C> {
    private final NavigableMap<Cut<C>, Range<C>> rangesByLowerCut;
    private transient Set<Range<C>> asRanges;
    private transient RangeSet<C> complement;

    public static <C extends Comparable<?>> TreeRangeSet<C> create() {
        return new TreeRangeSet<C>(new TreeMap<Cut<C>, Range<C>>());
    }

    public static <C extends Comparable<?>> TreeRangeSet<C> create(RangeSet<C> rangeSet) {
        TreeRangeSet<C> result = TreeRangeSet.create();
        result.addAll((RangeSet)rangeSet);
        return result;
    }

    private TreeRangeSet(NavigableMap<Cut<C>, Range<C>> rangesByLowerCut) {
        this.rangesByLowerCut = rangesByLowerCut;
    }

    @Override
    public Set<Range<C>> asRanges() {
        AsRanges result = this.asRanges;
        return result == null ? (this.asRanges = new AsRanges()) : result;
    }

    @Override
    @Nullable
    public Range<C> rangeContaining(C value) {
        Preconditions.checkNotNull(value);
        Map.Entry<Cut<C>, Range<C>> floorEntry = this.rangesByLowerCut.floorEntry(Cut.belowValue(value));
        if (floorEntry != null && floorEntry.getValue().contains(value)) {
            return floorEntry.getValue();
        }
        return null;
    }

    @Override
    public boolean encloses(Range<C> range) {
        Preconditions.checkNotNull(range);
        Map.Entry floorEntry = this.rangesByLowerCut.floorEntry(range.lowerBound);
        return floorEntry != null && floorEntry.getValue().encloses(range);
    }

    @Override
    public Range<C> span() {
        Map.Entry<Cut<C>, Range<C>> firstEntry = this.rangesByLowerCut.firstEntry();
        Map.Entry<Cut<C>, Range<C>> lastEntry = this.rangesByLowerCut.lastEntry();
        if (firstEntry == null) {
            throw new NoSuchElementException();
        }
        return Range.create(firstEntry.getValue().lowerBound, lastEntry.getValue().upperBound);
    }

    @Override
    public void add(Range<C> rangeToAdd) {
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToAdd);
        if (rangeToAdd.isEmpty()) {
            return;
        }
        Cut lbToAdd = rangeToAdd.lowerBound;
        Cut ubToAdd = rangeToAdd.upperBound;
        Map.Entry entryBelowLB = this.rangesByLowerCut.lowerEntry(lbToAdd);
        if (entryBelowLB != null) {
            Range<C> rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(lbToAdd) >= 0) {
                if (rangeBelowLB.upperBound.compareTo(ubToAdd) >= 0) {
                    ubToAdd = rangeBelowLB.upperBound;
                }
                lbToAdd = rangeBelowLB.lowerBound;
            }
        }
        if ((entryBelowUB = this.rangesByLowerCut.floorEntry(ubToAdd)) != null) {
            Range<C> rangeBelowUB = entryBelowUB.getValue();
            if (rangeBelowUB.upperBound.compareTo(ubToAdd) >= 0) {
                ubToAdd = rangeBelowUB.upperBound;
            }
        }
        this.rangesByLowerCut.subMap(lbToAdd, ubToAdd).clear();
        this.replaceRangeWithSameLowerBound(new Range(lbToAdd, ubToAdd));
    }

    @Override
    public void remove(Range<C> rangeToRemove) {
        Map.Entry entryBelowUB;
        Preconditions.checkNotNull(rangeToRemove);
        if (rangeToRemove.isEmpty()) {
            return;
        }
        Map.Entry entryBelowLB = this.rangesByLowerCut.lowerEntry(rangeToRemove.lowerBound);
        if (entryBelowLB != null) {
            Range<C> rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(rangeToRemove.lowerBound) >= 0) {
                if (rangeBelowLB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                    this.replaceRangeWithSameLowerBound(new Range(rangeToRemove.upperBound, rangeBelowLB.upperBound));
                }
                this.replaceRangeWithSameLowerBound(new Range(rangeBelowLB.lowerBound, rangeToRemove.lowerBound));
            }
        }
        if ((entryBelowUB = this.rangesByLowerCut.floorEntry(rangeToRemove.upperBound)) != null) {
            Range<C> rangeBelowUB = entryBelowUB.getValue();
            if (rangeBelowUB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                this.replaceRangeWithSameLowerBound(new Range(rangeToRemove.upperBound, rangeBelowUB.upperBound));
            }
        }
        this.rangesByLowerCut.subMap(rangeToRemove.lowerBound, rangeToRemove.upperBound).clear();
    }

    private void replaceRangeWithSameLowerBound(Range<C> range) {
        if (range.isEmpty()) {
            this.rangesByLowerCut.remove(range.lowerBound);
        } else {
            this.rangesByLowerCut.put(range.lowerBound, range);
        }
    }

    @Override
    public RangeSet<C> complement() {
        Complement result = this.complement;
        return result == null ? (this.complement = new Complement()) : result;
    }

    private final class Complement
    extends AbstractRangeSet<C> {
        private Complement() {
        }

        private RangeSet<C> positive() {
            return TreeRangeSet.this;
        }

        @Override
        public boolean contains(C value) {
            return !this.positive().contains(value);
        }

        @Override
        public Range<C> rangeContaining(C value) {
            Cut lowerBound;
            Cut valueCut = Cut.belowValue(value);
            Map.Entry entryBelow = TreeRangeSet.this.rangesByLowerCut.floorEntry(valueCut);
            if (entryBelow == null) {
                lowerBound = Cut.belowAll();
            } else {
                Range rangeBelow = (Range)entryBelow.getValue();
                if (rangeBelow.contains(value)) {
                    return null;
                }
                lowerBound = rangeBelow.upperBound;
            }
            Cut upperBound = Objects.firstNonNull(TreeRangeSet.this.rangesByLowerCut.higherKey(valueCut), Cut.aboveAll());
            return new Range(lowerBound, upperBound);
        }

        @Override
        public Set<Range<C>> asRanges() {
            return new AbstractSet<Range<C>>(){

                @Override
                public Iterator<Range<C>> iterator() {
                    return TreeRangeSet.this.standardComplementIterator();
                }

                @Override
                public int size() {
                    boolean positiveBoundedBelow = !TreeRangeSet.this.rangesByLowerCut.containsKey(Cut.belowAll());
                    Map.Entry lastEntry = TreeRangeSet.this.rangesByLowerCut.lastEntry();
                    boolean positiveBoundedAbove = lastEntry == null || ((Range)lastEntry.getValue()).hasUpperBound();
                    int size = TreeRangeSet.this.rangesByLowerCut.size() - 1;
                    if (positiveBoundedBelow) {
                        ++size;
                    }
                    if (positiveBoundedAbove) {
                        ++size;
                    }
                    return size;
                }
            };
        }

        @Override
        public Range<C> span() {
            Cut spanLowerBound;
            Map.Entry firstEntry = TreeRangeSet.this.rangesByLowerCut.firstEntry();
            if (firstEntry == null) {
                return Range.all();
            }
            if (((Range)firstEntry.getValue()).hasLowerBound()) {
                spanLowerBound = Cut.belowAll();
            } else {
                spanLowerBound = ((Range)firstEntry.getValue()).upperBound;
                if (Cut.aboveAll().equals(spanLowerBound)) {
                    throw new NoSuchElementException();
                }
            }
            Map.Entry lastEntry = TreeRangeSet.this.rangesByLowerCut.lastEntry();
            Cut spanUpperBound = ((Range)lastEntry.getValue()).hasUpperBound() ? Cut.aboveAll() : ((Range)lastEntry.getValue()).lowerBound;
            return Range.create(spanLowerBound, spanUpperBound);
        }

        @Override
        public boolean isEmpty() {
            return ((Object)this.positive()).equals(ImmutableRangeSet.all());
        }

        @Override
        public RangeSet<C> complement() {
            return this.positive();
        }

        @Override
        public void add(Range<C> range) {
            this.positive().remove(range);
        }

        @Override
        public void remove(Range<C> range) {
            this.positive().add(range);
        }

        @Nullable
        Range<C> floorRange(Cut<C> cut) {
            Iterator candidatePositiveRanges = TreeRangeSet.this.rangesByLowerCut.headMap(cut, false).descendingMap().values().iterator();
            if (candidatePositiveRanges.hasNext()) {
                Range firstCandidate = (Range)candidatePositiveRanges.next();
                if (firstCandidate.upperBound.compareTo(cut) <= 0) {
                    Cut resultLowerBound = firstCandidate.upperBound;
                    Cut resultUpperBound = Objects.firstNonNull(TreeRangeSet.this.rangesByLowerCut.higherKey(resultLowerBound), Cut.aboveAll());
                    return Range.create(resultLowerBound, resultUpperBound);
                }
                if (candidatePositiveRanges.hasNext()) {
                    return Range.create(((Range)candidatePositiveRanges.next()).upperBound, firstCandidate.lowerBound);
                }
                if (Cut.belowAll().equals(firstCandidate.lowerBound)) {
                    return null;
                }
                return Range.create(Cut.belowAll(), firstCandidate.lowerBound);
            }
            if (TreeRangeSet.this.rangesByLowerCut.isEmpty()) {
                return Range.all();
            }
            return Range.create(Cut.belowAll(), (Cut)TreeRangeSet.this.rangesByLowerCut.firstKey());
        }

        @Override
        public boolean encloses(Range<C> range) {
            Preconditions.checkNotNull(range);
            Range floorRange = this.floorRange(range.lowerBound);
            return floorRange != null && floorRange.encloses(range);
        }
    }

    final class AsRanges
    extends ForwardingCollection<Range<C>>
    implements Set<Range<C>> {
        AsRanges() {
        }

        @Override
        protected Collection<Range<C>> delegate() {
            return TreeRangeSet.this.rangesByLowerCut.values();
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }

        @Override
        public boolean equals(@Nullable Object o) {
            return Sets.equalsImpl(this, o);
        }
    }
}

