/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.HashCodes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@GoogleInternal
final class Murmur2_64AHashFunction
extends AbstractNonStreamingHashFunction {
    private static final long M = -4132994306676758123L;
    private static final int R = 47;
    private final long seed;

    Murmur2_64AHashFunction(long seed) {
        this.seed = seed;
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        ByteBuffer buf = ByteBuffer.wrap(input, off, len).order(ByteOrder.LITTLE_ENDIAN);
        long h = this.seed ^ (long)buf.remaining() * -4132994306676758123L;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h ^= (k *= -4132994306676758123L);
            h *= -4132994306676758123L;
        }
        if (buf.hasRemaining()) {
            int i = 0;
            while (buf.hasRemaining()) {
                h ^= ((long)buf.get() & 0xFFL) << i;
                i += 8;
            }
            h *= -4132994306676758123L;
        }
        h ^= h >>> 47;
        h *= -4132994306676758123L;
        h ^= h >>> 47;
        return HashCodes.fromLong(h);
    }

    @Override
    public int bits() {
        return 64;
    }
}

