/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.io;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.AppendableWriter;
import com.google.appengine.repackaged.com.google.common.io.Closer;
import com.google.appengine.repackaged.com.google.common.io.InputSupplier;
import com.google.appengine.repackaged.com.google.common.io.LineProcessor;
import com.google.appengine.repackaged.com.google.common.io.LineReader;
import com.google.appengine.repackaged.com.google.common.io.MultiReader;
import com.google.appengine.repackaged.com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Beta
public final class CharStreams {
    private static final int BUF_SIZE = 2048;

    private CharStreams() {
    }

    public static InputSupplier<StringReader> newReaderSupplier(final String value) {
        Preconditions.checkNotNull(value);
        return new InputSupplier<StringReader>(){

            @Override
            public StringReader getInput() {
                return new StringReader(value);
            }
        };
    }

    public static InputSupplier<InputStreamReader> newReaderSupplier(final InputSupplier<? extends InputStream> in, final Charset charset) {
        Preconditions.checkNotNull(in);
        Preconditions.checkNotNull(charset);
        return new InputSupplier<InputStreamReader>(){

            @Override
            public InputStreamReader getInput() throws IOException {
                return new InputStreamReader((InputStream)in.getInput(), charset);
            }
        };
    }

    public static OutputSupplier<OutputStreamWriter> newWriterSupplier(final OutputSupplier<? extends OutputStream> out, final Charset charset) {
        Preconditions.checkNotNull(out);
        Preconditions.checkNotNull(charset);
        return new OutputSupplier<OutputStreamWriter>(){

            @Override
            public OutputStreamWriter getOutput() throws IOException {
                return new OutputStreamWriter((OutputStream)out.getOutput(), charset);
            }
        };
    }

    public static <W extends Appendable & Closeable> void write(CharSequence from, OutputSupplier<W> to) throws IOException {
        Preconditions.checkNotNull(from);
        Closer closer = Closer.create();
        try {
            Appendable out = (Appendable)((Object)closer.add((Closeable)to.getOutput()));
            out.append(from);
        }
        catch (Throwable e) {
            throw closer.rethrow(e, IOException.class);
        }
        finally {
            closer.close();
        }
    }

    public static <R extends Readable & Closeable, W extends Appendable & Closeable> long copy(InputSupplier<R> from, OutputSupplier<W> to) throws IOException {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        Closer closer = Closer.create();
        try {
            Readable in = (Readable)((Object)closer.add((Closeable)from.getInput()));
            Appendable out = (Appendable)((Object)closer.add((Closeable)to.getOutput()));
            long l = CharStreams.copy(in, out);
            return l;
        }
        catch (Throwable e) {
            throw closer.rethrow(e, IOException.class);
        }
        finally {
            closer.close();
        }
    }

    public static <R extends Readable & Closeable> long copy(InputSupplier<R> from, Appendable to) throws IOException {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        Closer closer = Closer.create();
        try {
            Readable in = (Readable)((Object)closer.add((Closeable)from.getInput()));
            long l = CharStreams.copy(in, to);
            return l;
        }
        catch (Throwable e) {
            throw closer.rethrow(e, IOException.class);
        }
        finally {
            closer.close();
        }
    }

    public static long copy(Readable from, Appendable to) throws IOException {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        CharBuffer buf = CharBuffer.allocate(2048);
        long total = 0L;
        while (from.read(buf) != -1) {
            buf.flip();
            to.append(buf);
            total += (long)buf.remaining();
            buf.clear();
        }
        return total;
    }

    public static String toString(Readable r) throws IOException {
        return CharStreams.toStringBuilder(r).toString();
    }

    public static <R extends Readable & Closeable> String toString(InputSupplier<R> supplier) throws IOException {
        return CharStreams.toStringBuilder(supplier).toString();
    }

    private static StringBuilder toStringBuilder(Readable r) throws IOException {
        StringBuilder sb = new StringBuilder();
        CharStreams.copy(r, (Appendable)sb);
        return sb;
    }

    private static <R extends Readable & Closeable> StringBuilder toStringBuilder(InputSupplier<R> supplier) throws IOException {
        Closer closer = Closer.create();
        try {
            Readable r = (Readable)((Object)closer.add((Closeable)supplier.getInput()));
            StringBuilder stringBuilder = CharStreams.toStringBuilder(r);
            return stringBuilder;
        }
        catch (Throwable e) {
            throw closer.rethrow(e, IOException.class);
        }
        finally {
            closer.close();
        }
    }

    public static <R extends Readable & Closeable> String readFirstLine(InputSupplier<R> supplier) throws IOException {
        Closer closer = Closer.create();
        try {
            Readable r = (Readable)((Object)closer.add((Closeable)supplier.getInput()));
            String string = new LineReader(r).readLine();
            return string;
        }
        catch (Throwable e) {
            throw closer.rethrow(e, IOException.class);
        }
        finally {
            closer.close();
        }
    }

    public static <R extends Readable & Closeable> List<String> readLines(InputSupplier<R> supplier) throws IOException {
        Closer closer = Closer.create();
        try {
            Readable r = (Readable)((Object)closer.add((Closeable)supplier.getInput()));
            List<String> list = CharStreams.readLines(r);
            return list;
        }
        catch (Throwable e) {
            throw closer.rethrow(e, IOException.class);
        }
        finally {
            closer.close();
        }
    }

    public static List<String> readLines(Readable r) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        LineReader lineReader = new LineReader(r);
        while ((line = lineReader.readLine()) != null) {
            result.add(line);
        }
        return result;
    }

    public static <R extends Readable & Closeable, T> T readLines(InputSupplier<R> supplier, LineProcessor<T> callback) throws IOException {
        Closer closer = Closer.create();
        try {
            String line;
            Readable r = (Readable)((Object)closer.add((Closeable)supplier.getInput()));
            LineReader lineReader = new LineReader(r);
            while ((line = lineReader.readLine()) != null && callback.processLine(line)) {
            }
            T t = callback.getResult();
            return t;
        }
        catch (Throwable e) {
            throw closer.rethrow(e, IOException.class);
        }
        finally {
            closer.close();
        }
    }

    public static InputSupplier<Reader> join(final Iterable<? extends InputSupplier<? extends Reader>> suppliers) {
        Preconditions.checkNotNull(suppliers);
        return new InputSupplier<Reader>(){

            @Override
            public Reader getInput() throws IOException {
                return new MultiReader(suppliers.iterator());
            }
        };
    }

    public static InputSupplier<Reader> join(InputSupplier<? extends Reader> ... suppliers) {
        return CharStreams.join(Arrays.asList(suppliers));
    }

    public static void skipFully(Reader reader, long n) throws IOException {
        Preconditions.checkNotNull(reader);
        while (n > 0L) {
            long amt = reader.skip(n);
            if (amt == 0L) {
                if (reader.read() == -1) {
                    throw new EOFException();
                }
                --n;
                continue;
            }
            n -= amt;
        }
    }

    public static Writer asWriter(Appendable target) {
        if (target instanceof Writer) {
            return (Writer)target;
        }
        return new AppendableWriter(target);
    }
}

