/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Asset;
import com.google.appengine.api.conversion.AssetProtoConverter;
import com.google.appengine.api.conversion.ConversionHelper;
import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.api.conversion.Document;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import java.util.ArrayList;

class DocumentProtoConverter
extends Converter<Document, ConversionServicePb.DocumentInfo> {
    private final AssetProtoConverter assetProtoConverter = new AssetProtoConverter();

    DocumentProtoConverter() {
    }

    @Override
    public ConversionServicePb.DocumentInfo doForward(Document document) {
        ConversionHelper.validateDocumentSize(document);
        ConversionServicePb.DocumentInfo.Builder documentInfo = ConversionServicePb.DocumentInfo.newBuilder();
        for (Asset asset : document.getAssets()) {
            documentInfo.addAsset((ConversionServicePb.AssetInfo)this.assetProtoConverter.convert(asset));
        }
        return documentInfo.build();
    }

    @Override
    public Document doBackward(ConversionServicePb.DocumentInfo documentPb) {
        ArrayList<Asset> assets = Lists.newArrayList();
        for (ConversionServicePb.AssetInfo asset : documentPb.getAssetList()) {
            assets.add((Asset)this.assetProtoConverter.reverse().convert(asset));
        }
        return new Document(assets);
    }
}

