/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms;

import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.api.ApiProxy;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.SqlProtoClient;
import com.google.cloud.sql.jdbc.internal.SqlRpc;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.SqlState;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;

class RdbmsApiProxyClient
extends SqlProtoClient {
    static final String PACKAGE = "rdbms";

    RdbmsApiProxyClient(String rdbmsInstance) {
        super(rdbmsInstance, new ApiProxyBlockingInterface());
    }

    static final class ApiProxyBlockingInterface
    implements SqlRpc {
        ApiProxyBlockingInterface() {
        }

        @Override
        public ExecResponse exec(SqlRpcOptions options, ExecRequest request) throws SQLException {
            return this.makeSyncCall("Exec", request, ApiProxyBlockingInterface.createApiConfig(options.getQueryTimeOutMillis()), ExecResponse.newBuilder()).build();
        }

        @Override
        public ExecOpResponse execOp(SqlRpcOptions options, ExecOpRequest request) throws SQLException {
            return this.makeSyncCall("ExecOp", request, ApiProxyBlockingInterface.createApiConfig(options.getQueryTimeOutMillis()), ExecOpResponse.newBuilder()).build();
        }

        @Override
        public MetadataResponse getMetadata(SqlRpcOptions options, MetadataRequest request) throws SQLException {
            return this.makeSyncCall("GetMetadata", request, ApiProxyBlockingInterface.createApiConfig(options.getQueryTimeOutMillis()), MetadataResponse.newBuilder()).build();
        }

        @Override
        public OpenConnectionResponse openConnection(SqlRpcOptions options, OpenConnectionRequest request) throws SQLException {
            return this.makeSyncCall("OpenConnection", request, ApiProxyBlockingInterface.createApiConfig(options.getConnectTimeOutMillis()), OpenConnectionResponse.newBuilder()).build();
        }

        @Override
        public CloseConnectionResponse closeConnection(SqlRpcOptions options, CloseConnectionRequest request) throws SQLException {
            return this.makeSyncCall("CloseConnection", request, ApiProxyBlockingInterface.createApiConfig(options.getQueryTimeOutMillis()), CloseConnectionResponse.newBuilder()).build();
        }

        private static ApiProxy.ApiConfig createApiConfig(long deadlineMillis) {
            ApiProxy.ApiConfig config = new ApiProxy.ApiConfig();
            config.setDeadlineInSeconds(Double.valueOf(TimeUnit.MILLISECONDS.toSeconds(deadlineMillis)));
            return config;
        }

        <T extends Message.Builder> T makeSyncCall(String method, MessageLite request, ApiProxy.ApiConfig apiConfig, T responseBuilder) throws SQLException {
            block5: {
                try {
                    byte[] responseBytes = ApiProxy.makeSyncCall(RdbmsApiProxyClient.PACKAGE, method, request.toByteArray(), apiConfig);
                    if (responseBytes == null) break block5;
                    try {
                        responseBuilder.mergeFrom(responseBytes);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new SQLException(e.getMessage(), e);
                    }
                }
                catch (ApiProxy.ApiDeadlineExceededException exception) {
                    throw Exceptions.newTimeoutException();
                }
                catch (ApiProxy.ApplicationException exception) {
                    String sqlstate = method.equals("OpenConnection") ? SqlState.forOpenConnectionError(exception.getApplicationError()) : SqlState.forError(exception.getApplicationError());
                    throw new SQLException(exception.getErrorDetail(), sqlstate, exception.getApplicationError());
                }
            }
            return responseBuilder;
        }
    }
}

