/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.client.datastoreservice.intern.AllocateIdsHandler;
import com.google.apphosting.client.datastoreservice.intern.BeginTransactionHandler;
import com.google.apphosting.client.datastoreservice.intern.CommitHandler;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.EntityWrapperTranslator;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.intern.LookupHandler;
import com.google.apphosting.client.datastoreservice.intern.RollbackHandler;
import com.google.apphosting.client.datastoreservice.intern.RunQueryHandler;
import com.google.apphosting.client.datastoreservice.intern.ServiceRegistry;
import com.google.apphosting.client.datastoreservice.intern.WriteHandler;

public class DatastoreRpcService {
    final InternDatastoreRpcService internDatastoreRpcService;
    final EntityV4Normalizer entityNormalizer;
    final EntityWrapperTranslator entityWrapperTranslator;

    public DatastoreRpcService(String defaultDatasetId) {
        this(new InternDatastoreRpcService(), defaultDatasetId);
    }

    @VisibleForTesting
    DatastoreRpcService(InternDatastoreRpcService internDatastoreRpcService, String defaultDatasetId) {
        this.internDatastoreRpcService = internDatastoreRpcService;
        this.entityNormalizer = new EntityV4Normalizer(defaultDatasetId);
        this.entityWrapperTranslator = new EntityWrapperTranslator();
    }

    public void registerService(ServiceRegistry registry) {
        this.registerHandler(registry, "allocateIds", new AllocateIdsHandler(this.entityNormalizer, this.internDatastoreRpcService));
        this.registerHandler(registry, "beginTransaction", new BeginTransactionHandler(this.internDatastoreRpcService));
        this.registerHandler(registry, "commit", new CommitHandler(this.entityNormalizer, this.internDatastoreRpcService));
        this.registerHandler(registry, "lookup", new LookupHandler(this.entityNormalizer, this.entityWrapperTranslator, this.internDatastoreRpcService));
        this.registerHandler(registry, "rollback", new RollbackHandler(this.internDatastoreRpcService));
        this.registerHandler(registry, "runQuery", new RunQueryHandler(this.entityNormalizer, this.entityWrapperTranslator, this.internDatastoreRpcService));
        this.registerHandler(registry, "blindWrite", new WriteHandler(this.entityNormalizer, this.internDatastoreRpcService));
    }

    private <R extends MessageLite, S extends MessageLite> void registerHandler(ServiceRegistry registry, String methodName, DatastoreRpcHandler<R, S> handler) {
        String[] serviceNames = SystemProperty.environment.value() == SystemProperty.Environment.Value.Production ? new String[]{"remotedatastore", "datastore"} : new String[]{"datastore"};
        for (String serviceName : serviceNames) {
            for (String versionName : new String[]{"v1", "v1beta1"}) {
                registry.registerHandler(serviceName, versionName, methodName, handler);
            }
        }
    }
}

