/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.HashCodes;
import com.google.appengine.repackaged.com.google.common.hash.LittleEndianByteArray;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;

@GoogleInternal
final class CityHash128HashFunction
extends AbstractNonStreamingHashFunction {
    private static final long K0 = -6505348102511208375L;
    private static final long K1 = -8261664234251669945L;
    private static final long K2 = -4288712594273399085L;
    private static final long K3 = -4102945252841444853L;
    private static final long K4 = -4132994306676758123L;
    private final long[] seed;
    private static final InternalImplementation impl = LittleEndianByteArray.usingUnsafe() ? Internal.UsingUnsafe : Internal.UsingByteBuffer;

    CityHash128HashFunction(long seedHigh, long seedLow) {
        this.seed = new long[2];
        this.seed[0] = seedHigh;
        this.seed[1] = seedLow;
    }

    CityHash128HashFunction() {
        this.seed = null;
    }

    @Override
    public HashCode hashBytes(byte[] input) {
        return this.hashBytes(input, 0, input.length);
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        Preconditions.checkArgument(off >= 0, "offset (%s) cannot be negative", off);
        Preconditions.checkArgument(len >= 0, "length (%s) cannot be negative", len);
        Preconditions.checkArgument(off + len <= input.length, "offset (%s) + length (%s) cannot be greater than the byte array length (%s)", off, len, input.length);
        return impl.fingerprint(input, off, len, this.seed);
    }

    public String toString() {
        return this.seed == null ? "Hashing.cityHash128()" : "Hashing.cityHash128(" + this.seed[0] + ", " + this.seed[1] + ")";
    }

    @Override
    public int bits() {
        return 128;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof CityHash128HashFunction) {
            CityHash128HashFunction other = (CityHash128HashFunction)object;
            return this.seed == null ? true : this.seed[0] == other.seed[0] && this.seed[1] == other.seed[1];
        }
        return false;
    }

    public int hashCode() {
        return this.seed == null ? this.getClass().hashCode() : (int)((long)this.getClass().hashCode() ^ this.seed[0] ^ this.seed[1]);
    }

    @VisibleForTesting
    static HashCode hashBytesUsingUnsafe(byte[] input) {
        return Internal.UsingUnsafe.fingerprint(input, 0, input.length, null);
    }

    @VisibleForTesting
    static HashCode hashBytesUsingByteBuffer(byte[] input) {
        return Internal.UsingByteBuffer.fingerprint(input, 0, input.length, null);
    }

    private static HashCode cityMurmur(byte[] input, int offset, int length, long a, long b) {
        long d;
        long c;
        if (length <= 16) {
            c = b * -8261664234251669945L + CityHash128HashFunction.hashLength0To16(input, offset, length);
            d = Long.rotateRight(a + (length >= 8 ? LittleEndianByteArray.load64(input, offset) : c), 32);
        } else {
            c = CityHash128HashFunction.hashLength16(LittleEndianByteArray.load64(input, offset + length - 8) + -8261664234251669945L, a);
            d = CityHash128HashFunction.hashLength16(b + (long)length, c + LittleEndianByteArray.load64(input, offset + length - 16));
            a += d;
            ByteBuffer scratch = ByteBuffer.allocateDirect(length);
            scratch.order(ByteOrder.LITTLE_ENDIAN);
            scratch.put(input, offset, length);
            scratch.position(0);
            length -= 16;
            do {
                a ^= CityHash128HashFunction.shiftMix(scratch.getLong() * -8261664234251669945L) * -8261664234251669945L;
                b ^= (a *= -8261664234251669945L);
                c ^= CityHash128HashFunction.shiftMix(scratch.getLong() * -8261664234251669945L) * -8261664234251669945L;
                d ^= (c *= -8261664234251669945L);
            } while ((length -= 16) > 0);
        }
        a = CityHash128HashFunction.hashLength16(a, c);
        b = CityHash128HashFunction.hashLength16(d, b);
        byte[] output = new byte[16];
        LittleEndianByteArray.store64(output, 0, CityHash128HashFunction.hashLength16(b, a));
        LittleEndianByteArray.store64(output, 8, a ^ b);
        return HashCodes.fromBytes(output);
    }

    private static long hashLength16(long high, long low) {
        long a = (low ^ high) * -4132994306676758123L;
        a ^= a >>> 47;
        long b = (high ^ a) * -4132994306676758123L;
        b ^= b >>> 47;
        return b *= -4132994306676758123L;
    }

    private static long hashLength0To16(byte[] input, int offset, int length) {
        if (length > 8) {
            long a = LittleEndianByteArray.load64(input, offset);
            long b = LittleEndianByteArray.load64(input, offset + length - 8);
            long temp = CityHash128HashFunction.hashLength16(a, Long.rotateRight(b + (long)length, length)) ^ b;
            return temp;
        }
        if (length >= 4) {
            long a = (long)LittleEndianByteArray.load32(input, offset) & 0xFFFFFFFFL;
            return CityHash128HashFunction.hashLength16((long)length + (a << 3), (long)LittleEndianByteArray.load32(input, offset + length - 4) & 0xFFFFFFFFL);
        }
        if (length > 0) {
            byte a = input[offset];
            byte b = input[length >> 1];
            byte c = input[length - 1];
            int y = (a & 0xFF) + ((b & 0xFF) << 8);
            int z = length + ((c & 0xFF) << 2);
            return CityHash128HashFunction.shiftMix((long)y * -4288712594273399085L ^ (long)z * -4102945252841444853L) * -4288712594273399085L;
        }
        return -4288712594273399085L;
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static enum Internal implements InternalImplementation
    {
        UsingUnsafe{

            @Override
            protected HashCode fingerprint(byte[] input, int offset, int length, long x, long y) {
                if (length < 128) {
                    return CityHash128HashFunction.cityMurmur(input, offset, length, x, y);
                }
                byte[] output = new byte[16];
                long[] v = new long[2];
                long[] w = new long[2];
                long z = (long)length * -8261664234251669945L;
                v[0] = Long.rotateRight(y ^ 0x8D58AC26AFE12E47L, 49) * -8261664234251669945L + LittleEndianByteArray.load64(input, offset);
                v[1] = Long.rotateRight(v[0], 42) * -8261664234251669945L + LittleEndianByteArray.load64(input, offset + 8);
                w[0] = Long.rotateRight(y + z, 35) * -8261664234251669945L + x;
                w[1] = Long.rotateRight(x + LittleEndianByteArray.load64(input, offset + 88), 53) * -8261664234251669945L;
                do {
                    x = Long.rotateRight(x + y + v[0] + LittleEndianByteArray.load64(input, offset + 16), 37) * -8261664234251669945L;
                    y = Long.rotateRight(y + v[1] + LittleEndianByteArray.load64(input, offset + 48), 42) * -8261664234251669945L;
                    z = Long.rotateRight(z ^ w[0], 33);
                    this.weakHashLength32WithSeeds(input, offset, v[1] * -8261664234251669945L, (x ^= w[1]) + w[0], v);
                    this.weakHashLength32WithSeeds(input, offset + 32, z + w[1], y ^= v[0], w);
                    z = Long.rotateRight(z + y + v[0] + LittleEndianByteArray.load64(input, offset + 80), 37) * -8261664234251669945L;
                    y = Long.rotateRight(y + v[1] + LittleEndianByteArray.load64(input, offset + 112), 42) * -8261664234251669945L;
                    x = Long.rotateRight(x ^ w[0], 33);
                    this.weakHashLength32WithSeeds(input, offset + 64, v[1] * -8261664234251669945L, (z ^= w[1]) + w[0], v);
                    this.weakHashLength32WithSeeds(input, offset + 96, x + w[1], y ^= v[0], w);
                    offset += 128;
                } while ((length -= 128) >= 128);
                y += Long.rotateRight(w[0], 37) * -6505348102511208375L + z;
                x += Long.rotateRight(v[0] + z, 49) * -6505348102511208375L;
                offset += length - 32;
                while (length > 0) {
                    y = Long.rotateRight(y - x, 42) * -6505348102511208375L + v[1];
                    w[0] = w[0] + LittleEndianByteArray.load64(input, offset + 16);
                    x = Long.rotateRight(x, 49) * -6505348102511208375L + w[0];
                    w[0] = w[0] + v[0];
                    this.weakHashLength32WithSeeds(input, offset, v[0], v[1], v);
                    offset -= 32;
                    length -= 32;
                }
                x = CityHash128HashFunction.hashLength16(x, v[0]);
                y = CityHash128HashFunction.hashLength16(y, w[0]);
                LittleEndianByteArray.store64(output, 0, CityHash128HashFunction.hashLength16(x + w[1], y + v[1]));
                LittleEndianByteArray.store64(output, 8, CityHash128HashFunction.hashLength16(x + v[1], w[1]) + y);
                return HashCodes.fromBytes(output);
            }

            private void weakHashLength32WithSeeds(byte[] bytes, int offset, long seedA, long seedB, long[] output) {
                long part1 = LittleEndianByteArray.load64(bytes, offset);
                long part2 = LittleEndianByteArray.load64(bytes, offset + 8);
                long part3 = LittleEndianByteArray.load64(bytes, offset + 16);
                long part4 = LittleEndianByteArray.load64(bytes, offset + 24);
                seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 51);
                long c = seedA;
                seedA += part2;
                output[0] = seedA + part4;
                output[1] = (seedB += Long.rotateRight(seedA += part3, 23)) + c;
            }
        }
        ,
        UsingByteBuffer{

            @Override
            protected HashCode fingerprint(byte[] input, int offset, int length, long x, long y) {
                if (length < 128) {
                    return CityHash128HashFunction.cityMurmur(input, offset, length, x, y);
                }
                long[] v = new long[2];
                long[] w = new long[2];
                long z = (long)length * -8261664234251669945L;
                v[0] = Long.rotateRight(y ^ 0x8D58AC26AFE12E47L, 49) * -8261664234251669945L + LittleEndianByteArray.load64(input, offset);
                v[1] = Long.rotateRight(v[0], 42) * -8261664234251669945L + LittleEndianByteArray.load64(input, offset + 8);
                w[0] = Long.rotateRight(y + z, 35) * -8261664234251669945L + x;
                w[1] = Long.rotateRight(x + LittleEndianByteArray.load64(input, offset + 88), 53) * -8261664234251669945L;
                ByteBuffer scratch = ByteBuffer.allocateDirect(128);
                scratch.order(ByteOrder.LITTLE_ENDIAN);
                do {
                    scratch.position(0);
                    scratch.put(input, offset, 128);
                    x = Long.rotateRight(x + y + v[0] + scratch.getLong(16), 37) * -8261664234251669945L;
                    y = Long.rotateRight(y + v[1] + scratch.getLong(48), 42) * -8261664234251669945L;
                    z = Long.rotateRight(z ^ w[0], 33);
                    scratch.position(0);
                    this.weakHashLength32WithSeeds(scratch, v[1] * -8261664234251669945L, (x ^= w[1]) + w[0], v);
                    this.weakHashLength32WithSeeds(scratch, z + w[1], y ^= v[0], w);
                    z = Long.rotateRight(z + y + v[0] + LittleEndianByteArray.load64(input, offset + 80), 37) * -8261664234251669945L;
                    y = Long.rotateRight(y + v[1] + LittleEndianByteArray.load64(input, offset + 112), 42) * -8261664234251669945L;
                    x = Long.rotateRight(x ^ w[0], 33);
                    this.weakHashLength32WithSeeds(scratch, v[1] * -8261664234251669945L, (z ^= w[1]) + w[0], v);
                    this.weakHashLength32WithSeeds(scratch, x + w[1], y ^= v[0], w);
                    offset += 128;
                } while ((length -= 128) >= 128);
                y += Long.rotateRight(w[0], 37) * -6505348102511208375L + z;
                x += Long.rotateRight(v[0] + z, 49) * -6505348102511208375L;
                scratch.position(0);
                int rem = length & 0x1F;
                int position = length ^ rem;
                int annex = 32 - rem;
                scratch.put(input, offset - annex, length + annex);
                while (length > 0) {
                    y = Long.rotateRight(y - x, 42) * -6505348102511208375L + v[1];
                    w[0] = w[0] + scratch.getLong(length + annex - 16);
                    x = Long.rotateRight(x, 49) * -6505348102511208375L + w[0];
                    w[0] = w[0] + v[0];
                    scratch.position(position);
                    this.weakHashLength32WithSeeds(scratch, v[0], v[1], v);
                    position -= 32;
                    length -= 32;
                }
                x = CityHash128HashFunction.hashLength16(x, v[0]);
                y = CityHash128HashFunction.hashLength16(y, w[0]);
                scratch.position(0);
                scratch.putLong(CityHash128HashFunction.hashLength16(x + w[1], y + v[1])).putLong(CityHash128HashFunction.hashLength16(x + v[1], w[1]) + y);
                byte[] output = new byte[16];
                scratch.position(0);
                scratch.get(output, 0, 16);
                return HashCodes.fromBytes(output);
            }

            private void weakHashLength32WithSeeds(ByteBuffer bytes, long seedA, long seedB, long[] output) {
                long part1 = bytes.getLong();
                long part2 = bytes.getLong();
                long part3 = bytes.getLong();
                long part4 = bytes.getLong();
                seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 51);
                long c = seedA;
                seedA += part2;
                output[0] = seedA + part4;
                output[1] = (seedB += Long.rotateRight(seedA += part3, 23)) + c;
            }
        };


        protected abstract HashCode fingerprint(byte[] var1, int var2, int var3, long var4, long var6);

        @Override
        public HashCode fingerprint(byte[] input, int offset, int length, @Nullable long[] seed) {
            long x;
            long y;
            if (seed == null) {
                if (length >= 16) {
                    y = LittleEndianByteArray.load64(input, offset) ^ 0xC70F6907E782AA0BL;
                    x = LittleEndianByteArray.load64(input, offset + 8);
                    offset += 16;
                    length -= 16;
                } else if (length >= 8) {
                    y = LittleEndianByteArray.load64(input, offset) ^ (long)length * -6505348102511208375L;
                    x = LittleEndianByteArray.load64(input, length - 8) ^ 0x8D58AC26AFE12E47L;
                    length = 0;
                } else {
                    y = -6505348102511208375L;
                    x = -8261664234251669945L;
                }
            } else {
                y = seed[0];
                x = seed[1];
            }
            return this.fingerprint(input, offset, length, x, y);
        }
    }

    private static interface InternalImplementation {
        public HashCode fingerprint(byte[] var1, int var2, int var3, @Nullable long[] var4);
    }
}

