/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class LifecycleManager {
    private static final LifecycleManager instance = new LifecycleManager();
    private static final Logger log = Logger.getLogger(LifecycleManager.class.getName());
    private volatile boolean shuttingDown = false;
    private volatile long deadline = -1L;
    private Map<String, ShutdownHook> hooks = new HashMap<String, ShutdownHook>();

    private LifecycleManager() {
    }

    public static LifecycleManager getInstance() {
        return instance;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public synchronized void setShutdownHook(ShutdownHook hook) {
        this.hooks.put(this.currentAppVersionId(), hook);
    }

    public void interruptAllRequests() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                List<Thread> threads = ApiProxy.getRequestThreads();
                if (threads != null) {
                    for (Thread thread : threads) {
                        thread.interrupt();
                    }
                }
                return null;
            }
        });
    }

    public long getRemainingShutdownTime() {
        long value = this.deadline;
        if (value == -1L) {
            return -1L;
        }
        return value - System.currentTimeMillis();
    }

    public synchronized void beginShutdown(long deadline) {
        this.shuttingDown = true;
        this.deadline = deadline;
        ShutdownHook hook = this.hooks.get(this.currentAppVersionId());
        if (hook != null) {
            hook.shutdown();
        }
    }

    private String currentAppVersionId() {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        String string = String.valueOf(String.valueOf(env.getAppId()));
        String string2 = String.valueOf(String.valueOf(env.getVersionId()));
        return new StringBuilder(1 + string.length() + string2.length()).append(string).append("/").append(string2).toString();
    }

    public static interface ShutdownHook {
        public void shutdown();
    }
}

