/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.HashMap;

public class EntityTranslator {
    public static Entity createFromPb(OnestoreEntity.EntityProto proto, Collection<Projection> projections) {
        Key key = KeyTranslator.createFromPb(proto.getKey());
        Entity entity = new Entity(key);
        HashMap<String, Object> values = Maps.newHashMap();
        DataTypeTranslator.extractPropertiesFromPb(proto, values);
        for (Projection projection : projections) {
            entity.setProperty(projection.getName(), projection.getValue(values));
        }
        return entity;
    }

    public static Entity createFromPb(OnestoreEntity.EntityProto proto) {
        Key key = KeyTranslator.createFromPb(proto.getKey());
        Entity entity = new Entity(key);
        DataTypeTranslator.extractPropertiesFromPb(proto, entity.getPropertyMap());
        return entity;
    }

    public static Entity createFromPbBytes(byte[] pbBytes) {
        OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
        proto.mergeFrom(pbBytes);
        return EntityTranslator.createFromPb(proto);
    }

    public static OnestoreEntity.EntityProto convertToPb(Entity entity) {
        OnestoreEntity.Reference reference = KeyTranslator.convertToPb(entity.getKey());
        OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
        proto.setKey(reference);
        OnestoreEntity.Path entityGroup = proto.getMutableEntityGroup();
        Key key = entity.getKey();
        if (key.isComplete()) {
            entityGroup.addElement(reference.getPath().elements().get(0));
        }
        DataTypeTranslator.addPropertiesToPb(entity.getPropertyMap(), proto);
        return proto;
    }

    private EntityTranslator() {
    }
}

