/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.log.AppLogLine;
import com.google.appengine.api.log.LogService;
import com.google.apphosting.api.logservice.LogServicePb;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class RequestLogs
implements Serializable {
    private static final long serialVersionUID = 7380961939323935275L;
    private String appId;
    private String moduleId;
    private String versionId;
    private String requestId;
    private String offset;
    private String ip;
    private String nickname;
    private long startTimeUsec;
    private long endTimeUsec;
    private long latency;
    private long mcycles;
    private String method;
    private String resource;
    private String httpVersion;
    private int status;
    private long responseSize;
    private String referrer;
    private String userAgent;
    private String urlMapEntry;
    private String combined;
    private long apiMcycles;
    private String host;
    private double cost;
    private String taskQueueName;
    private String taskName;
    private boolean wasLoadingRequest;
    private long pendingTime;
    private int replicaIndex;
    private boolean finished;
    private String instanceKey;
    private List<AppLogLine> appLogLines = new ArrayList<AppLogLine>();
    private String appEngineRelease;

    public RequestLogs() {
    }

    protected RequestLogs(LogServicePb.RequestLog requestLog, String offset) {
        this.setAppId(requestLog.getAppId());
        this.setModuleId(requestLog.getModuleId());
        this.setVersionId(requestLog.getVersionId());
        this.setRequestId(requestLog.getRequestId());
        this.setOffset(offset);
        this.setIp(requestLog.getIp());
        this.setNickname(requestLog.getNickname());
        this.setStartTimeUsec(requestLog.getStartTime());
        this.setEndTimeUsec(requestLog.getEndTime());
        this.setLatency(requestLog.getLatency());
        this.setMcycles(requestLog.getMcycles());
        this.setMethod(requestLog.getMethod());
        this.setResource(requestLog.getResource());
        this.setHttpVersion(requestLog.getHttpVersion());
        this.setStatus(requestLog.getStatus());
        this.setResponseSize(requestLog.getResponseSize());
        this.setReferrer(requestLog.getReferrer());
        this.setUserAgent(requestLog.getUserAgent());
        this.setUrlMapEntry(requestLog.getUrlMapEntry());
        this.setCombined(requestLog.getCombined());
        this.setApiMcycles(requestLog.getApiMcycles());
        this.setHost(requestLog.getHost());
        this.setCost(requestLog.getCost());
        this.setTaskQueueName(requestLog.getTaskQueueName());
        this.setTaskName(requestLog.getTaskName());
        this.setWasLoadingRequest(requestLog.isWasLoadingRequest());
        this.setPendingTime(requestLog.getPendingTime());
        this.setReplicaIndex(requestLog.getReplicaIndex());
        this.setFinished(requestLog.isFinished());
        this.setInstanceKey(requestLog.getCloneKey());
        this.setAppEngineRelease(requestLog.getAppEngineRelease());
        List<AppLogLine> appLogLines = this.getAppLogLines();
        for (LogServicePb.LogLine logLine : requestLog.lines()) {
            LogService.LogLevel level = LogService.LogLevel.values()[logLine.getLevel()];
            appLogLines.add(new AppLogLine(logLine.getTime(), level, logLine.getLogMessage()));
        }
    }

    @Deprecated
    public long getApiMcycles() {
        return this.apiMcycles;
    }

    public String getAppId() {
        return this.appId;
    }

    public List<AppLogLine> getAppLogLines() {
        return this.appLogLines;
    }

    public String getCombined() {
        return this.combined;
    }

    public double getCost() {
        return this.cost;
    }

    public long getEndTimeUsec() {
        return this.endTimeUsec;
    }

    public String getHost() {
        return this.host;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getInstanceKey() {
        return this.instanceKey;
    }

    public String getIp() {
        return this.ip;
    }

    public long getLatencyUsec() {
        return this.latency;
    }

    public long getMcycles() {
        return this.mcycles;
    }

    public String getMethod() {
        return this.method;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getOffset() {
        return this.offset;
    }

    public long getPendingTimeUsec() {
        return this.pendingTime;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getResource() {
        return this.resource;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public long getStartTimeUsec() {
        return this.startTimeUsec;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskQueueName() {
        return this.taskQueueName;
    }

    public String getUrlMapEntry() {
        return this.urlMapEntry;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isLoadingRequest() {
        return this.wasLoadingRequest;
    }

    public String getAppEngineRelease() {
        return this.appEngineRelease;
    }

    public void setApiMcycles(long apiMcycles) {
        this.apiMcycles = apiMcycles;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppLogLines(List<AppLogLine> appLogLines) {
        this.appLogLines = appLogLines;
    }

    public void setCombined(String combined) {
        this.combined = combined;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setEndTimeUsec(long endTimeUsec) {
        this.endTimeUsec = endTimeUsec;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void setInstanceKey(String instanceKey) {
        this.instanceKey = instanceKey;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public void setMcycles(long mcycles) {
        this.mcycles = mcycles;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public void setPendingTime(long pendingTime) {
        this.pendingTime = pendingTime;
    }

    public void setReferrer(String referrer) {
        this.referrer = referrer;
    }

    public void setReplicaIndex(int replicaIndex) {
        this.replicaIndex = replicaIndex;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setResponseSize(long responseSize) {
        this.responseSize = responseSize;
    }

    public void setStartTimeUsec(long startTimeUsec) {
        this.startTimeUsec = startTimeUsec;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskQueueName(String taskQueueName) {
        this.taskQueueName = taskQueueName;
    }

    public void setUrlMapEntry(String urlMapEntry) {
        this.urlMapEntry = urlMapEntry;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public void setWasLoadingRequest(boolean wasLoadingRequest) {
        this.wasLoadingRequest = wasLoadingRequest;
    }

    public void setAppEngineRelease(String appEngineRelease) {
        this.appEngineRelease = appEngineRelease;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf("RequestLogs{appId='"));
        String string2 = String.valueOf(String.valueOf(this.appId));
        String string3 = String.valueOf(String.valueOf(this.moduleId));
        String string4 = String.valueOf(String.valueOf(this.versionId));
        String string5 = String.valueOf(String.valueOf(this.requestId));
        String string6 = String.valueOf(String.valueOf(this.ip));
        String string7 = String.valueOf(String.valueOf(this.nickname));
        long l = this.startTimeUsec;
        long l2 = this.endTimeUsec;
        long l3 = this.latency;
        long l4 = this.mcycles;
        String string8 = String.valueOf(String.valueOf(this.method));
        String string9 = String.valueOf(String.valueOf(this.resource));
        String string10 = String.valueOf(String.valueOf(this.httpVersion));
        int n = this.status;
        long l5 = this.responseSize;
        String string11 = String.valueOf(String.valueOf(this.referrer));
        String string12 = String.valueOf(String.valueOf(this.userAgent));
        String string13 = String.valueOf(String.valueOf(this.urlMapEntry));
        String string14 = String.valueOf(String.valueOf(this.combined));
        long l6 = this.apiMcycles;
        String string15 = String.valueOf(String.valueOf(this.host));
        double d = this.cost;
        String string16 = String.valueOf(String.valueOf(this.taskQueueName));
        String string17 = String.valueOf(String.valueOf(this.taskName));
        boolean bl = this.wasLoadingRequest;
        long l7 = this.pendingTime;
        int n2 = this.replicaIndex;
        boolean bl2 = this.finished;
        String string18 = String.valueOf(String.valueOf(this.instanceKey));
        String string19 = String.valueOf(String.valueOf(this.appLogLines));
        String string20 = String.valueOf(String.valueOf(this.appEngineRelease));
        return new StringBuilder(600 + string.length() + string2.length() + string3.length() + string4.length() + string5.length() + string6.length() + string7.length() + string8.length() + string9.length() + string10.length() + string11.length() + string12.length() + string13.length() + string14.length() + string15.length() + string16.length() + string17.length() + string18.length() + string19.length() + string20.length()).append(string).append(string2).append("'").append(", moduleId='").append(string3).append("'").append(", versionId='").append(string4).append("'").append(", requestId='").append(string5).append("'").append(", ip='").append(string6).append("'").append(", nickname='").append(string7).append("'").append(", startTimeUsec=").append(l).append(", endTimeUsec=").append(l2).append(", latency=").append(l3).append(", mcycles=").append(l4).append(", method='").append(string8).append("'").append(", resource='").append(string9).append("'").append(", httpVersion='").append(string10).append("'").append(", status=").append(n).append(", responseSize=").append(l5).append(", referrer='").append(string11).append("'").append(", userAgent='").append(string12).append("'").append(", urlMapEntry='").append(string13).append("'").append(", combined='").append(string14).append("'").append(", apiMcycles=").append(l6).append(", host='").append(string15).append("'").append(", cost=").append(d).append(", taskQueueName='").append(string16).append("'").append(", taskName='").append(string17).append("'").append(", wasLoadingRequest=").append(bl).append(", pendingTime=").append(l7).append(", replicaIndex=").append(n2).append(", finished=").append(bl2).append(", instanceKey='").append(string18).append("'").append(", appLogLines=").append(string19).append(", appEngineRelease='").append(string20).append("'").append("}").toString();
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.moduleId, this.versionId, this.requestId, this.offset, this.ip, this.nickname, this.startTimeUsec, this.endTimeUsec, this.latency, this.mcycles, this.method, this.resource, this.httpVersion, this.status, this.responseSize, this.referrer, this.userAgent, this.urlMapEntry, this.combined, this.apiMcycles, this.host, this.cost, this.taskQueueName, this.taskName, this.wasLoadingRequest, this.pendingTime, this.replicaIndex, this.finished, this.instanceKey, this.appLogLines, this.appEngineRelease);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RequestLogs other = (RequestLogs)obj;
        return Objects.equals(this.appId, other.appId) && Objects.equals(this.moduleId, other.moduleId) && Objects.equals(this.versionId, other.versionId) && Objects.equals(this.requestId, other.requestId) && Objects.equals(this.offset, other.offset) && Objects.equals(this.ip, other.ip) && Objects.equals(this.nickname, other.nickname) && this.startTimeUsec == other.startTimeUsec && this.endTimeUsec == other.endTimeUsec && this.latency == other.latency && this.mcycles == other.mcycles && Objects.equals(this.method, other.method) && Objects.equals(this.resource, other.resource) && Objects.equals(this.httpVersion, other.httpVersion) && this.status == other.status && this.responseSize == other.responseSize && Objects.equals(this.referrer, other.referrer) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.urlMapEntry, other.urlMapEntry) && Objects.equals(this.combined, other.combined) && this.apiMcycles == other.apiMcycles && Objects.equals(this.host, other.host) && Objects.equals(this.cost, other.cost) && Objects.equals(this.taskQueueName, other.taskQueueName) && Objects.equals(this.taskName, other.taskName) && this.wasLoadingRequest == other.wasLoadingRequest && this.pendingTime == other.pendingTime && this.replicaIndex == other.replicaIndex && this.finished == other.finished && Objects.equals(this.instanceKey, other.instanceKey) && Objects.equals(this.appLogLines, other.appLogLines) && Objects.equals(this.appEngineRelease, other.appEngineRelease);
    }
}

