/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.FacetChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.apphosting.api.AppEngineInternal;

@AppEngineInternal
public class FacetQueryChecker {
    private static void checkMaximum(int number, int max, String context) {
        Preconditions.checkArgument(number > 0, "%s should be positive", context);
        Preconditions.checkArgument(number <= max, "%s must be less than or equal to %s", context, max);
    }

    public static int checkDiscoveryLimit(int value) {
        FacetQueryChecker.checkMaximum(value, 100, "Facet discovery limit");
        return value;
    }

    public static String checkFacetValue(String value) {
        return FacetChecker.checkAtom(value);
    }

    public static Integer checkDepth(Integer value) {
        if (value != null) {
            FacetQueryChecker.checkMaximum(value, 10000, "Facet depth option");
        }
        return value;
    }

    public static Integer checkDiscoveryValueLimit(Integer value) {
        if (value != null) {
            FacetQueryChecker.checkMaximum(value, 20, "Facet discovery value limit");
        }
        return value;
    }

    public static Integer checkValueLimit(Integer value) {
        if (value != null) {
            FacetQueryChecker.checkMaximum(value, 20, "Facet value limit");
        }
        return value;
    }

    private FacetQueryChecker() {
    }
}

