/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.AppEngineDatagramSocketImpl;
import com.google.appengine.api.socket.AppEngineSocketImpl;
import com.google.appengine.api.socket.AppEngineSocketOptionsClient;
import com.google.appengine.api.socket.SocketServicePb;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

class AppEngineSocketOptions {
    private static final CheckFunction INTEGER_CHECK = new IntegerCheckFunction();
    private static final CheckFunction INTEGER_GT0_CHECK = new GreaterThanZeroCheckFunction();
    private static final CheckFunction BOOLEAN_CHECK = new BooleanCheckFunction();
    private static final CheckFunction UNIMPLIMENTED_CHECK = new UnimplimentedCheckFunction();
    private static final OptionValueConverter INTEGER_CONVERTER = new IntegerConverter();
    private static final OptionValueConverter BOOLEAN_CONVERTER = new BooleanConverter();
    private static final OptionValueConverter ADDRESS_CONVERTER = new AddressConverter();

    static Option getOptionById(int optionId) {
        for (Option option : Option.values()) {
            if (option.opt == null || option.opt != optionId) continue;
            return option;
        }
        return null;
    }

    AppEngineSocketOptions() {
    }

    static /* synthetic */ CheckFunction access$1100() {
        return INTEGER_CHECK;
    }

    static /* synthetic */ OptionValueConverter access$1300() {
        return ADDRESS_CONVERTER;
    }

    static /* synthetic */ CheckFunction access$1400() {
        return UNIMPLIMENTED_CHECK;
    }

    static /* synthetic */ OptionValueConverter access$1500() {
        return BOOLEAN_CONVERTER;
    }

    static /* synthetic */ CheckFunction access$1600() {
        return BOOLEAN_CHECK;
    }

    static /* synthetic */ CheckFunction access$1700() {
        return INTEGER_GT0_CHECK;
    }

    public static enum Option {
        SO_LINGER_OPT(128, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_LINGER, new LingerConverter(), AppEngineSocketOptions.access$1100(), new BooleanCheckFunction(){

            @Override
            void apply(Option option, AppEngineSocketOptionsClient socketImpl, Object val) throws SocketException {
                socketImpl.setSocketOptionAsBytes(option, option.converter.toBytes(false));
            }
        }, new OnlyAllowedForTCP()),
        SO_TIMEOUT_OPT(4102, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, null, AppEngineSocketOptions.access$100(), new IntegerCheckFunction(){

            @Override
            void check(Option opt, Object value, boolean isDatagramSocket) {
                if ((Integer)value < 0) {
                    String string = String.valueOf(String.valueOf(opt.optionName()));
                    String string2 = String.valueOf(String.valueOf(value));
                    throw new IllegalArgumentException(new StringBuilder(46 + string.length() + string2.length()).append(string).append(" requires timeout value >= 0: timeout given = ").append(string2).toString());
                }
            }

            @Override
            void apply(Option option, AppEngineSocketOptionsClient socketImpl, Object value) throws SocketException {
                socketImpl.setTimeout((Integer)value);
                socketImpl.setSocketOptionAsBytes(option, option.converter.toBytes(value));
            }
        }),
        IP_TOS_OPT(3, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_IP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_IP_TOS, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1100()),
        SO_BINDADDR_OPT(15, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, null, AppEngineSocketOptions.access$1300(), AppEngineSocketOptions.access$1400()),
        TCP_NODELAY_OPT(1, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_NODELAY, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP()),
        SO_SNDBUF_OPT(4097, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_SNDBUF, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1700()),
        SO_RCVBUF_OPT(4098, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_RCVBUF, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1700()),
        SO_KEEPALIVE_OPT(8, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_KEEPALIVE, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP()),
        SO_OOBINLINE_OPT(4099, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_OOBINLINE, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP()),
        SO_REUSEADDR_OPT(4, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_REUSEADDR, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600()),
        SO_DEBUG_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_DEBUG, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600()),
        SO_TYPE_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_TYPE, AppEngineSocketOptions.access$100(), new CheckFunction[0]),
        SO_ERROR_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_ERROR, AppEngineSocketOptions.access$100(), new CheckFunction[0]),
        SO_DONTROUTE_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_DONTROUTE, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600()),
        SO_BROADCAST_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_BROADCAST, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600()),
        IP_TTL_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_IP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_IP_TTL, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1100()),
        IP_HDRINCL_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_IP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_IP_HDRINCL, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600()),
        IP_OPTIONS_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_IP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_IP_OPTIONS, null, AppEngineSocketOptions.access$1400()),
        TCP_MAXSEG_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_MAXSEG, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1100(), new OnlyAllowedForTCP()),
        TCP_CORK_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_CORK, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP()),
        TCP_KEEPIDLE_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_KEEPIDLE, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1100(), new OnlyAllowedForTCP()),
        TCP_KEEPINTVL_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_KEEPINTVL, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1100(), new OnlyAllowedForTCP()),
        TCP_KEEPCNT_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_KEEPCNT, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1100(), new OnlyAllowedForTCP()),
        TCP_SYNCNT_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_SYNCNT, AppEngineSocketOptions.access$100(), AppEngineSocketOptions.access$1100(), new OnlyAllowedForTCP()),
        TCP_LINGER2_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_LINGER2, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP()),
        TCP_DEFER_ACCEPT_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_DEFER_ACCEPT, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP()),
        TCP_WINDOW_CLAMP_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_WINDOW_CLAMP, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP()),
        TCP_INFO_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_INFO, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP()),
        TCP_QUICKACK_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_QUICKACK, AppEngineSocketOptions.access$1500(), AppEngineSocketOptions.access$1600(), new OnlyAllowedForTCP());

        private SocketServicePb.SocketOption.SocketOptionLevel level;
        private SocketServicePb.SocketOption.SocketOptionName optName;
        private Integer opt;
        private OptionValueConverter converter;
        private CheckFunction[] checkFuncs;

        private Option(Integer opt, SocketServicePb.SocketOption.SocketOptionLevel level, SocketServicePb.SocketOption.SocketOptionName name, OptionValueConverter converter, CheckFunction ... checkFuncs) {
            this.optName = name;
            this.level = level;
            this.opt = opt;
            this.converter = converter;
            this.checkFuncs = checkFuncs;
        }

        String optionName() {
            return this.name().substring(0, this.name().length() - "_OPT".length());
        }

        private void validateAndApply(AppEngineSocketOptionsClient socketImpl, Object val, boolean isDatagramSocket) throws SocketException {
            if (val == null) {
                String string = String.valueOf(this.optionName());
                throw new SocketException(string.length() != 0 ? "Bad value 'null' for option ".concat(string) : new String("Bad value 'null' for option "));
            }
            if (this.checkFuncs.length == 0) {
                String string = String.valueOf(String.valueOf(this.optionName()));
                throw new SocketException(new StringBuilder(33 + string.length()).append("Option ").append(string).append(" is not allowed to be set.").toString());
            }
            for (CheckFunction checkFunc : this.checkFuncs) {
                if (!val.getClass().isInstance(checkFunc.equivalenceClassObject())) continue;
                checkFunc.check(this, val, isDatagramSocket);
            }
            for (CheckFunction checkFunc : this.checkFuncs) {
                if (!val.getClass().isInstance(checkFunc.equivalenceClassObject())) continue;
                checkFunc.apply(this, socketImpl, val);
                return;
            }
            String string = String.valueOf(String.valueOf(val.getClass().getName()));
            String string2 = String.valueOf(String.valueOf(this.optionName()));
            throw new SocketException(new StringBuilder(36 + string.length() + string2.length()).append("Bad parameter type of '").append(string).append("' for option ").append(string2).toString());
        }

        void validateAndApply(AppEngineDatagramSocketImpl socketImpl, Object val) throws SocketException {
            this.validateAndApply(socketImpl, val, true);
        }

        void validateAndApply(AppEngineSocketImpl socketImpl, Object val) throws SocketException {
            this.validateAndApply(socketImpl, val, false);
        }

        public SocketServicePb.SocketOption.SocketOptionLevel getLevel() {
            return this.level;
        }

        public SocketServicePb.SocketOption.SocketOptionName getOptName() {
            return this.optName;
        }

        public Integer getOpt() {
            return this.opt;
        }

        public byte[] getOptionValueAsBytes(Object optionValue) throws SocketException {
            if (this.converter == null) {
                String string = String.valueOf(String.valueOf(this.optionName()));
                throw new SocketException(new StringBuilder(27 + string.length()).append("Option ").append(string).append(" is not implimented.").toString());
            }
            return this.converter.toBytes(optionValue);
        }

        public Object getOption(AppEngineSocketOptionsClient client, boolean isDatagramSocket) throws SocketException {
            if (this.converter == null) {
                String string = String.valueOf(String.valueOf(this.optionName()));
                throw new SocketException(new StringBuilder(27 + string.length()).append("Option ").append(string).append(" is not implimented.").toString());
            }
            return this.converter.toObject(client.getSocketOptionAsBytes(this));
        }

        public Object getOption(AppEngineSocketImpl socketImpl) throws SocketException {
            return this.getOption(socketImpl, false);
        }

        public Object getOption(AppEngineDatagramSocketImpl socketImpl) throws SocketException {
            return this.getOption(socketImpl, true);
        }
    }

    private static class OnlyAllowedForTCP
    extends IntegerCheckFunction {
        private OnlyAllowedForTCP() {
        }

        @Override
        void check(Option opt, Object value, boolean isDatagramSocket) throws SocketException {
            if (isDatagramSocket) {
                String string = String.valueOf(String.valueOf(opt.optionName()));
                throw new SocketException(new StringBuilder(46 + string.length()).append("Option '").append(string).append("'").append(" is not allowed for datagram sockets.").toString());
            }
        }
    }

    private static class GreaterThanZeroCheckFunction
    extends IntegerCheckFunction {
        private GreaterThanZeroCheckFunction() {
        }

        @Override
        void check(Option opt, Object value, boolean isDatagramSocket) throws SocketException {
            if ((Integer)value <= 0) {
                String string = String.valueOf(String.valueOf(opt.optionName()));
                String string2 = String.valueOf(String.valueOf(value));
                throw new SocketException(new StringBuilder(56 + string.length() + string2.length()).append("bad parameter for '").append(string).append("'").append(" Must be greater than zero. value = ").append(string2).toString());
            }
        }
    }

    private static class UnimplimentedCheckFunction
    extends CheckFunction {
        private UnimplimentedCheckFunction() {
        }

        @Override
        Object equivalenceClassObject() {
            return new Object();
        }

        @Override
        void check(Option opt, Object value, boolean isDatagramSocket) throws SocketException {
            throw new SocketException(String.valueOf(opt.optionName()).concat(" is not implimented."));
        }
    }

    private static class BooleanCheckFunction
    extends CheckFunction {
        private BooleanCheckFunction() {
        }

        @Override
        Object equivalenceClassObject() {
            return false;
        }

        @Override
        void apply(Option option, AppEngineSocketOptionsClient socketImpl, Object value) throws SocketException {
            socketImpl.setSocketOptionAsBytes(option, option.converter.toBytes(value));
        }
    }

    private static class IntegerCheckFunction
    extends CheckFunction {
        private IntegerCheckFunction() {
        }

        @Override
        Object equivalenceClassObject() {
            return 0;
        }
    }

    private static abstract class CheckFunction {
        private CheckFunction() {
        }

        abstract Object equivalenceClassObject();

        void check(Option opt, Object value, boolean isDatagramSocket) throws SocketException {
        }

        void apply(Option option, AppEngineSocketOptionsClient socketImpl, Object value) throws SocketException {
            socketImpl.setSocketOptionAsBytes(option, option.converter.toBytes(value));
        }
    }

    static class LingerConverter
    extends OptionValueConverter {
        LingerConverter() {
        }

        @Override
        byte[] toBytes(Object objectValue) {
            ByteBuilder builder = new ByteBuilder();
            if (objectValue instanceof Boolean || (Integer)objectValue == -1) {
                builder.append(0);
                builder.append(0);
                return builder.getBytes();
            }
            builder.append(1);
            builder.append((Integer)objectValue);
            return builder.getBytes();
        }

        @Override
        Object toObject(byte[] data) {
            if (data.length != 8) {
                throw new IllegalStateException("Failed to convert linger data.");
            }
            if (IntegerConverter.convert(data, 0) == 0) {
                return -1;
            }
            return IntegerConverter.convert(data, 4);
        }
    }

    static class ByteBuilder {
        byte[] buffer = new byte[4];
        int usedCount = 0;

        ByteBuilder() {
        }

        void append(int value) {
            this.append(INTEGER_CONVERTER.toBytes(value));
        }

        void append(byte[] value) {
            this.ensureAppendCapacity(value.length);
            System.arraycopy(value, 0, this.buffer, this.usedCount, value.length);
            this.usedCount += value.length;
        }

        private void ensureAppendCapacity(int appendCapacity) {
            if (this.buffer.length - this.usedCount < appendCapacity) {
                this.buffer = Arrays.copyOf(this.buffer, this.usedCount + appendCapacity + 16);
            }
        }

        byte[] getBytes() {
            if (this.usedCount == this.buffer.length) {
                return this.buffer;
            }
            return Arrays.copyOf(this.buffer, this.usedCount);
        }
    }

    private static class AddressConverter
    extends OptionValueConverter {
        private AddressConverter() {
        }

        @Override
        byte[] toBytes(Object objectValue) {
            InetAddress value = (InetAddress)objectValue;
            return value.getAddress();
        }

        @Override
        Object toObject(byte[] data) {
            try {
                return InetAddress.getByAddress(data);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Failed to create InetAddress", e);
            }
        }
    }

    private static class BooleanConverter
    extends OptionValueConverter {
        private BooleanConverter() {
        }

        @Override
        byte[] toBytes(Object objectValue) {
            boolean value = (Boolean)objectValue;
            byte[] result = new byte[]{0, 0, 0, (byte)(value ? 1 : 0)};
            return result;
        }

        @Override
        Object toObject(byte[] data) {
            return IntegerConverter.convert(data, 0) != 0;
        }
    }

    private static class IntegerConverter
    extends OptionValueConverter {
        private IntegerConverter() {
        }

        static int convert(byte[] data, int offset) {
            return ((data[0 + offset] & 0xFF) << 24) + ((data[1 + offset] & 0xFF) << 16) + ((data[2 + offset] & 0xFF) << 8) + (data[3 + offset] & 0xFF);
        }

        @Override
        byte[] toBytes(Object objectValue) {
            int value = (Integer)objectValue;
            byte[] result = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
            return result;
        }

        @Override
        Object toObject(byte[] data) {
            return IntegerConverter.convert(data, 0);
        }
    }

    private static abstract class OptionValueConverter {
        private OptionValueConverter() {
        }

        abstract byte[] toBytes(Object var1);

        abstract Object toObject(byte[] var1);
    }
}

