/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp;

import com.google.appengine.api.xmpp.JID;
import com.google.appengine.api.xmpp.MessageType;
import java.util.Arrays;

public class Message {
    private final MessageType messageType;
    private final boolean asXml;
    private final String body;
    private final String stanza;
    private final JID fromJid;
    private final JID[] recipientJids;

    Message(MessageType messageType, boolean asXml, String body, String stanza, JID fromJid, JID ... recipientJids) {
        this.messageType = messageType;
        this.asXml = asXml;
        this.body = body;
        this.stanza = stanza;
        this.fromJid = fromJid;
        this.recipientJids = recipientJids;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean isXml() {
        return this.asXml;
    }

    public String getBody() {
        return this.body;
    }

    public JID getFromJid() {
        return this.fromJid;
    }

    public JID[] getRecipientJids() {
        return this.recipientJids;
    }

    public String getStanza() {
        return this.stanza;
    }

    public String toString() {
        String formattedBody;
        String formattedStanza;
        if (this.stanza == null) {
            formattedStanza = "null";
        } else {
            String string = String.valueOf(String.valueOf(this.stanza.replace("\"", "\\\"")));
            formattedStanza = new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
        }
        if (this.body == null) {
            formattedBody = "null";
        } else {
            String string = String.valueOf(String.valueOf(this.body.replace("\"", "\\\"")));
            formattedBody = new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
        }
        return String.format("Message(messageType=%s, asXml=%b, body=%s, stanza=%s, fromJid=%s, recipientJids=%s)", new Object[]{this.messageType, this.asXml, formattedBody, formattedStanza, this.fromJid, Arrays.toString(this.recipientJids)});
    }
}

