/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.base;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.MutablePeriod;
import com.google.appengine.repackaged.org.joda.time.Period;
import com.google.appengine.repackaged.org.joda.time.PeriodType;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import java.io.Serializable;

public abstract class BaseSingleFieldPeriod
implements ReadablePeriod,
Comparable<BaseSingleFieldPeriod>,
Serializable {
    private static final long serialVersionUID = 9386874258972L;
    private volatile int iPeriod;

    protected static int between(ReadableInstant start, ReadableInstant end, DurationFieldType field) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("ReadableInstant objects must not be null");
        }
        Chronology chrono = DateTimeUtils.getInstantChronology(start);
        int amount = field.getField(chrono).getDifference(end.getMillis(), start.getMillis());
        return amount;
    }

    protected static int between(ReadablePartial start, ReadablePartial end, ReadablePeriod zeroInstance) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (start.size() != end.size()) {
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        int isize = start.size();
        for (int i = 0; i < isize; ++i) {
            if (start.getFieldType(i) == end.getFieldType(i)) continue;
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        if (!DateTimeUtils.isContiguous(start)) {
            throw new IllegalArgumentException("ReadablePartial objects must be contiguous");
        }
        Chronology chrono = DateTimeUtils.getChronology(start.getChronology()).withUTC();
        int[] values = chrono.get(zeroInstance, chrono.set(start, 0L), chrono.set(end, 0L));
        return values[0];
    }

    protected static int standardPeriodIn(ReadablePeriod period, long millisPerUnit) {
        if (period == null) {
            return 0;
        }
        ISOChronology iso = ISOChronology.getInstanceUTC();
        long duration = 0L;
        for (int i = 0; i < period.size(); ++i) {
            int value = period.getValue(i);
            if (value == 0) continue;
            DurationField field = period.getFieldType(i).getField(iso);
            if (!field.isPrecise()) {
                String string = field.getName();
                String string2 = String.valueOf(period);
                throw new IllegalArgumentException(new StringBuilder(67 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Cannot convert period to duration as ").append(string).append(" is not precise in the period ").append(string2).toString());
            }
            duration = FieldUtils.safeAdd(duration, FieldUtils.safeMultiply(field.getUnitMillis(), value));
        }
        return FieldUtils.safeToInt(duration / millisPerUnit);
    }

    protected BaseSingleFieldPeriod(int period) {
        this.iPeriod = period;
    }

    protected int getValue() {
        return this.iPeriod;
    }

    protected void setValue(int value) {
        this.iPeriod = value;
    }

    public abstract DurationFieldType getFieldType();

    @Override
    public abstract PeriodType getPeriodType();

    @Override
    public int size() {
        return 1;
    }

    @Override
    public DurationFieldType getFieldType(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.getFieldType();
    }

    @Override
    public int getValue(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.getValue();
    }

    @Override
    public int get(DurationFieldType type) {
        if (type == this.getFieldType()) {
            return this.getValue();
        }
        return 0;
    }

    @Override
    public boolean isSupported(DurationFieldType type) {
        return type == this.getFieldType();
    }

    @Override
    public Period toPeriod() {
        return Period.ZERO.withFields(this);
    }

    @Override
    public MutablePeriod toMutablePeriod() {
        MutablePeriod period = new MutablePeriod();
        period.add(this);
        return period;
    }

    @Override
    public boolean equals(Object period) {
        if (this == period) {
            return true;
        }
        if (!(period instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod other = (ReadablePeriod)period;
        return other.getPeriodType() == this.getPeriodType() && other.getValue(0) == this.getValue();
    }

    @Override
    public int hashCode() {
        int total = 17;
        total = 27 * total + this.getValue();
        total = 27 * total + this.getFieldType().hashCode();
        return total;
    }

    @Override
    public int compareTo(BaseSingleFieldPeriod other) {
        if (other.getClass() != this.getClass()) {
            String string = String.valueOf(this.getClass());
            String string2 = String.valueOf(other.getClass());
            throw new ClassCastException(new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" cannot be compared to ").append(string2).toString());
        }
        int otherValue = other.getValue();
        int thisValue = this.getValue();
        if (thisValue > otherValue) {
            return 1;
        }
        if (thisValue < otherValue) {
            return -1;
        }
        return 0;
    }
}

