/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.search.StatusCode;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.rpc.Status;
import com.google.apphosting.client.serviceapp.RpcHandler;
import java.util.logging.Logger;

abstract class CloudSearchRpcHandler<RequestType extends MessageLite, ResponseType extends MessageLite>
implements RpcHandler<RequestType, ResponseType> {
    private static final Logger logger = Logger.getLogger(CloudSearchRpcHandler.class.getName());

    CloudSearchRpcHandler() {
    }

    protected static Codes.Code fromInternalCode(StatusCode errorCode) {
        switch (errorCode) {
            case OK: {
                return Codes.Code.OK;
            }
            case CONCURRENT_TRANSACTION_ERROR: {
                return Codes.Code.ABORTED;
            }
            case INTERNAL_ERROR: {
                return Codes.Code.INTERNAL;
            }
            case INVALID_REQUEST: {
                return Codes.Code.INVALID_ARGUMENT;
            }
            case PERMISSION_DENIED_ERROR: {
                return Codes.Code.PERMISSION_DENIED;
            }
            case TIMEOUT_ERROR: {
                return Codes.Code.DEADLINE_EXCEEDED;
            }
            case TRANSIENT_ERROR: {
                return Codes.Code.UNAVAILABLE;
            }
        }
        return Codes.Code.INTERNAL;
    }

    @Override
    public Status makeError(Codes.Code errorCode, String message) {
        logger.fine(String.format("CloudSearch rpc error code: %s, detail: %s", errorCode, message));
        return Status.newBuilder().setCode(errorCode.getNumber()).setMessage(message).build();
    }

    @Override
    public MessageLite getRequestHeader(RequestType request) {
        return null;
    }
}

