/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.backends;

import com.google.appengine.api.backends.BackendService;
import com.google.appengine.api.utils.SystemProperty;
import com.google.apphosting.api.ApiProxy;
import java.util.Map;

class BackendServiceImpl
implements BackendService {
    static final String DATACENTER_ATTR_KEY = "com.google.apphosting.api.ApiProxy.datacenter";
    static final String DEFAULT_VERSION_HOSTNAME = "com.google.appengine.runtime.default_version_hostname";

    BackendServiceImpl() {
    }

    @Override
    public String getCurrentBackend() {
        return (String)BackendServiceImpl.getThreadLocalAttributes().get("com.google.appengine.backend.id");
    }

    @Override
    public int getCurrentInstance() {
        try {
            return Integer.parseInt((String)BackendServiceImpl.getThreadLocalAttributes().get("com.google.appengine.instance.id"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public String getBackendAddress(String backendName) {
        if (BackendServiceImpl.isProduction()) {
            String string = String.valueOf(String.valueOf(backendName));
            String string2 = String.valueOf(String.valueOf(BackendServiceImpl.getDefaultVersionHostname()));
            return new StringBuilder(1 + string.length() + string2.length()).append(string).append(".").append(string2).toString();
        }
        return this.getDevAppServerLocalAddress(backendName);
    }

    @Override
    public String getBackendAddress(String backendName, int instance) {
        int n = instance;
        String string = String.valueOf(String.valueOf(backendName));
        String backendInstance = new StringBuilder(12 + string.length()).append(n).append(".").append(string).toString();
        if (BackendServiceImpl.isProduction()) {
            String string2 = String.valueOf(String.valueOf(backendInstance));
            String string3 = String.valueOf(String.valueOf(BackendServiceImpl.getDefaultVersionHostname()));
            return new StringBuilder(1 + string2.length() + string3.length()).append(string2).append(".").append(string3).toString();
        }
        return this.getDevAppServerLocalAddress(backendInstance);
    }

    private String getDevAppServerLocalAddress(String string) {
        Map portMap = (Map)BackendServiceImpl.getThreadLocalAttributes().get("com.google.appengine.devappserver.portmapping");
        Object addr = portMap.get(string);
        if (addr == null) {
            throw new IllegalStateException("Tried to get local address of unknown backend");
        }
        return (String)addr;
    }

    static String getDefaultVersionHostname() {
        return (String)BackendServiceImpl.getThreadLocalAttributes().get(DEFAULT_VERSION_HOSTNAME);
    }

    private static Map<String, Object> getThreadLocalAttributes() {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        Map<String, Object> attr = env.getAttributes();
        if (attr == null) {
            throw new RuntimeException("Local environment is corrupt (thread local attributes map is null)");
        }
        return attr;
    }

    private static boolean isProduction() {
        return SystemProperty.environment.value() == SystemProperty.Environment.Value.Production;
    }
}

