/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.datastore.EntityStorage;
import com.google.storage.onestore.v3.OnestoreEntity;

final class CacheValueUtil {
    public static EntityStorage.CacheValue createCacheValue(EntityStorage.CacheValue.State state, OnestoreEntity.EntityProto entity) {
        if (state == EntityStorage.CacheValue.State.ENTITY) {
            EntityStorage.CacheValue cacheValue = new EntityStorage.CacheValue();
            if (entity != null) {
                EntityStorage.VersionedEntity versionedEntity = new EntityStorage.VersionedEntity();
                versionedEntity.setV3Entity(entity);
                cacheValue.setEntity(versionedEntity);
            }
            return cacheValue;
        }
        String string = String.valueOf(String.valueOf(EntityStorage.CacheValue.State.ENTITY));
        Preconditions.checkArgument(entity == null, new StringBuilder(43 + string.length()).append("An entity can only be specified with state ").append(string).toString());
        EntityStorage.CacheValue cacheValue = new EntityStorage.CacheValue();
        cacheValue.setState(state);
        return cacheValue;
    }

    public static boolean isDatastoreOpState(EntityStorage.CacheValue.State state) {
        return state == EntityStorage.CacheValue.State.READ_IN_PROGRESS || state == EntityStorage.CacheValue.State.MUTATION_IN_PROGRESS;
    }

    private CacheValueUtil() {
    }
}

