/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Facet;
import com.google.appengine.api.search.FacetRange;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FacetQueryChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class FacetRefinement {
    private static final int MAX_TOKEN_LENGTH_IN_EXCEPTIONS = 100;
    private final String name;
    private final String value;
    private final FacetRange range;

    public static FacetRefinement withValue(String name, String value) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "Name should not be empty");
        FacetQueryChecker.checkFacetValue(value);
        return new FacetRefinement(name, value, null);
    }

    public static FacetRefinement withRange(String name, FacetRange range) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "Name should not be empty");
        return new FacetRefinement(name, null, range);
    }

    private FacetRefinement(String name, String value, FacetRange range) {
        this.name = name;
        this.value = value;
        this.range = range;
        this.checkValid();
    }

    static FacetRefinement withProtoMessage(SearchServicePb.FacetRefinement refinementPb) {
        if (refinementPb.hasValue()) {
            return new FacetRefinement(refinementPb.getName(), refinementPb.getValue(), null);
        }
        if (refinementPb.hasRange()) {
            FacetRange range;
            if (refinementPb.getRange().hasStart()) {
                range = refinementPb.getRange().hasEnd() ? FacetRange.withStartEnd(Facet.stringToNumber(refinementPb.getRange().getStart()), Facet.stringToNumber(refinementPb.getRange().getEnd())) : FacetRange.withStart(Facet.stringToNumber(refinementPb.getRange().getStart()));
            } else if (refinementPb.getRange().hasEnd()) {
                range = FacetRange.withEnd(Facet.stringToNumber(refinementPb.getRange().getEnd()));
            } else {
                throw new IllegalStateException(String.format("Refinement %s has invalid range.", refinementPb.getName()));
            }
            return new FacetRefinement(refinementPb.getName(), null, range);
        }
        throw new IllegalStateException(String.format("Refinement %s should have value or range.", refinementPb.getName()));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public FacetRange getRange() {
        return this.range;
    }

    private void checkValid() {
        Preconditions.checkArgument(this.getName() != null && !this.getName().isEmpty(), "name should not be null or empty.");
        Preconditions.checkArgument(this.getValue() != null || this.getRange() != null, String.format("Neither value nor range is set for FacetRefinement %s", this.getName()));
        Preconditions.checkArgument(this.getValue() == null || this.getRange() == null, String.format("Both value and range are set for FacetRefinement %s", this.getName()));
    }

    SearchServicePb.FacetRefinement toProtocolBuffer() {
        SearchServicePb.FacetRefinement.Builder builder = SearchServicePb.FacetRefinement.newBuilder();
        builder.setName(this.getName());
        if (this.getValue() != null) {
            builder.setValue(this.getValue());
        }
        if (this.getRange() != null) {
            SearchServicePb.FacetRefinement.Range.Builder rangePb = builder.getRangeBuilder();
            if (this.getRange().getStart() != null) {
                rangePb.setStart(this.getRange().getStart());
            }
            if (this.getRange().getEnd() != null) {
                rangePb.setEnd(this.getRange().getEnd());
            }
        }
        return builder.build();
    }

    public String toTokenString() {
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            this.toProtocolBuffer().writeTo(data);
            return BaseEncoding.base64Url().omitPadding().encode(data.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("should never happen", e);
        }
    }

    private static String truncateAtMaxLength(String source, int maxLength) {
        if (source.length() <= maxLength) {
            return source;
        }
        return String.valueOf(source.substring(0, maxLength)).concat(" ...");
    }

    public static FacetRefinement fromTokenString(String token) {
        try {
            return FacetRefinement.withProtoMessage(SearchServicePb.FacetRefinement.parseFrom(BaseEncoding.base64Url().decode(token)));
        }
        catch (InvalidProtocolBufferException | IllegalArgumentException e) {
            String string = String.valueOf(FacetRefinement.truncateAtMaxLength(token, 100));
            throw new IllegalArgumentException(string.length() != 0 ? "Cannot process refinement token: ".concat(string) : new String("Cannot process refinement token: "), e);
        }
    }

    public String toString() {
        return new Util.ToStringHelper("FacetRefinement").addField("name", this.name).addField("value", this.value).addField("range", this.range).finish();
    }
}

