/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.users;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFailureException;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.UserServicePb;
import java.util.Set;

final class UserServiceImpl
implements UserService {
    static final String USER_ID_KEY = "com.google.appengine.api.users.UserService.user_id_key";
    static final String FEDERATED_IDENTITY_KEY = "com.google.appengine.api.users.UserService.federated_identity";
    static final String FEDERATED_AUTHORITY_KEY = "com.google.appengine.api.users.UserService.federated_authority";
    static final String IS_FEDERATED_USER_KEY = "com.google.appengine.api.users.UserService.is_federated_user";
    private static final String PACKAGE = "user";
    private static final String LOGIN_URL_METHOD = "CreateLoginURL";
    private static final String LOGOUT_URL_METHOD = "CreateLogoutURL";

    UserServiceImpl() {
    }

    @Override
    public String createLoginURL(String destinationURL) {
        return this.createLoginURL(destinationURL, null, null, null);
    }

    @Override
    public String createLoginURL(String destinationURL, String authDomain) {
        return this.createLoginURL(destinationURL, authDomain, null, null);
    }

    @Override
    public String createLoginURL(String destinationURL, String authDomain, String federatedIdentity, Set<String> attributesRequest) {
        byte[] responseBytes;
        UserServicePb.CreateLoginURLResponse response;
        boolean parsed;
        UserServicePb.CreateLoginURLRequest request = new UserServicePb.CreateLoginURLRequest();
        request.setDestinationUrl(destinationURL);
        if (authDomain != null) {
            request.setAuthDomain(authDomain);
        }
        if (federatedIdentity != null) {
            request.setFederatedIdentity(federatedIdentity);
        }
        if (!(parsed = (response = new UserServicePb.CreateLoginURLResponse()).mergeFrom(responseBytes = this.makeSyncCall(LOGIN_URL_METHOD, request, destinationURL))) || !response.isInitialized()) {
            throw new UserServiceFailureException("Could not parse CreateLoginURLResponse");
        }
        return response.getLoginUrl();
    }

    @Override
    public String createLogoutURL(String destinationURL) {
        return this.createLogoutURL(destinationURL, null);
    }

    @Override
    public String createLogoutURL(String destinationURL, String authDomain) {
        byte[] responseBytes;
        UserServicePb.CreateLogoutURLResponse response;
        boolean parsed;
        UserServicePb.CreateLogoutURLRequest request = new UserServicePb.CreateLogoutURLRequest();
        request.setDestinationUrl(destinationURL);
        if (authDomain != null) {
            request.setAuthDomain(authDomain);
        }
        if (!(parsed = (response = new UserServicePb.CreateLogoutURLResponse()).mergeFrom(responseBytes = this.makeSyncCall(LOGOUT_URL_METHOD, request, destinationURL))) || !response.isInitialized()) {
            throw new UserServiceFailureException("Could not parse CreateLogoutURLResponse");
        }
        return response.getLogoutUrl();
    }

    @Override
    public boolean isUserLoggedIn() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        return environment.isLoggedIn();
    }

    @Override
    public boolean isUserAdmin() {
        if (this.isUserLoggedIn()) {
            return ApiProxy.getCurrentEnvironment().isAdmin();
        }
        throw new IllegalStateException("The current user is not logged in.");
    }

    @Override
    public User getCurrentUser() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (!environment.isLoggedIn()) {
            return null;
        }
        String userId = (String)environment.getAttributes().get(USER_ID_KEY);
        Boolean isFederated = (Boolean)environment.getAttributes().get(IS_FEDERATED_USER_KEY);
        if (isFederated == null || !isFederated.booleanValue()) {
            return new User(environment.getEmail(), environment.getAuthDomain(), userId);
        }
        return new User(environment.getEmail(), (String)environment.getAttributes().get(FEDERATED_AUTHORITY_KEY), userId, (String)environment.getAttributes().get(FEDERATED_IDENTITY_KEY));
    }

    private byte[] makeSyncCall(String methodName, ProtocolMessage request, String destinationURL) {
        byte[] responseBytes;
        try {
            byte[] requestBytes = request.toByteArray();
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, methodName, requestBytes);
        }
        catch (ApiProxy.ApplicationException ex) {
            UserServicePb.UserServiceError.ErrorCode errorCode = UserServicePb.UserServiceError.ErrorCode.valueOf(ex.getApplicationError());
            switch (errorCode) {
                case REDIRECT_URL_TOO_LONG: {
                    String string = String.valueOf(destinationURL);
                    throw new IllegalArgumentException(string.length() != 0 ? "URL too long: ".concat(string) : new String("URL too long: "));
                }
                case NOT_ALLOWED: {
                    String string = String.valueOf(destinationURL);
                    throw new IllegalArgumentException(string.length() != 0 ? "The requested URL was not allowed: ".concat(string) : new String("The requested URL was not allowed: "));
                }
            }
            throw new UserServiceFailureException(ex.getErrorDetail());
        }
        return responseBytes;
    }
}

