/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import javax.annotation.Nullable;

class FlagDescription
implements Comparable<FlagDescription> {
    @Nullable
    private final String simpleFieldName;
    @Nullable
    private final String shortFlagName;
    private final String containerClassName;
    private final String type;
    private final String doc;
    private final DocLevel docLevel;
    @Nullable
    private final String altName;

    private FlagDescription(@Nullable String shortFlagName, String containerClassName, @Nullable String simpleFieldName, String type, String doc, DocLevel docLevel, @Nullable String altName) {
        this.shortFlagName = FlagDescription.emptyStringToNull(shortFlagName);
        this.containerClassName = containerClassName;
        this.simpleFieldName = simpleFieldName;
        this.type = type;
        this.doc = doc;
        this.docLevel = docLevel;
        this.altName = FlagDescription.emptyStringToNull(altName);
        if (!this.isField() && !this.isShortFlagNameSpecified()) {
            throw new NullPointerException();
        }
        FlagDescription.checkNotReserved(this.getShortFlagName());
        FlagDescription.checkNotReserved(this.getAltName());
    }

    private static void checkNotReserved(@Nullable String s) {
        if (s != null && (s.equals("help") || s.equals("helpxml") || s.equals("flagfile") || s.equals("flagresource"))) {
            throw new IllegalArgumentException(new StringBuilder(47 + String.valueOf(s).length()).append("The ").append(s).append(" flag is built-in and may not be registered").toString());
        }
    }

    static Builder createFlagFromField(String fullyQualifiedFieldName) {
        return new Builder(FlagDescription.parseContainerClassName(fullyQualifiedFieldName), FlagDescription.parseSimpleFieldName(fullyQualifiedFieldName));
    }

    static Builder createManuallyRegisteredFlag(String shortFlagName, String containerClassName) {
        return new Builder(containerClassName, null).shortFlagName(FlagDescription.stripFlagPrefix(shortFlagName));
    }

    String getLongFlagName() {
        String string = this.getContainerClassName();
        String string2 = this.getShortFlagName();
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
    }

    String getFullyQualifiedFieldName() {
        String string = this.getContainerClassName();
        String string2 = this.getSimpleFieldName();
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
    }

    String getSimpleFieldName() {
        String simpleFieldName = this.simpleFieldName;
        if (simpleFieldName == null) {
            String string = this.getLongFlagName();
            throw new UnsupportedOperationException(new StringBuilder(36 + String.valueOf(string).length()).append("Flag ").append(string).append(" is not associated with a field").toString());
        }
        return simpleFieldName;
    }

    boolean isField() {
        return this.simpleFieldName != null;
    }

    String getShortFlagName() {
        String shortFlagName = this.shortFlagName;
        return shortFlagName != null ? shortFlagName : FlagDescription.stripFlagPrefix(this.getSimpleFieldName());
    }

    boolean isShortFlagNameSpecified() {
        return this.shortFlagName != null;
    }

    String getContainerClassName() {
        return this.containerClassName;
    }

    String getType() {
        return this.type;
    }

    String getDoc() {
        return this.doc;
    }

    DocLevel getDocLevel() {
        return this.docLevel;
    }

    @Nullable
    String getAltName() {
        return this.altName;
    }

    boolean isPositiveFormOfName(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return name.equals(this.getShortFlagName()) || name.equals(this.getAltName()) || name.equals(this.getLongFlagName()) || this.isField() && name.equals(this.getFullyQualifiedFieldName());
    }

    public String toString() {
        return this.getLongFlagName();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof FlagDescription)) {
            return false;
        }
        FlagDescription o = (FlagDescription)other;
        return o.getShortFlagName().equals(this.getShortFlagName()) && o.containerClassName.equals(this.containerClassName) && FlagDescription.nullSafeEquals(o.simpleFieldName, this.simpleFieldName) && o.type.equals(this.type) && o.doc.equals(this.doc) && o.docLevel.equals((Object)this.docLevel) && FlagDescription.nullSafeEquals(o.altName, this.altName);
    }

    public int hashCode() {
        return this.getLongFlagName().hashCode();
    }

    @Override
    public int compareTo(FlagDescription o) {
        return this.getLongFlagName().compareTo(o.getLongFlagName());
    }

    private static String stripFlagPrefix(String flagName) {
        return flagName.startsWith("FLAG_") ? flagName.substring(5) : flagName;
    }

    private static String parseSimpleFieldName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(FlagDescription.findLastDotIndex(fullyQualifiedName) + 1);
    }

    private static String parseContainerClassName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(0, FlagDescription.findLastDotIndex(fullyQualifiedName));
    }

    private static int findLastDotIndex(String name) {
        int idx = name.lastIndexOf(".");
        if (idx <= 0) {
            String string = String.valueOf(name);
            throw new IllegalArgumentException(string.length() != 0 ? "Package name required in name: ".concat(string) : new String("Package name required in name: "));
        }
        return idx;
    }

    private static boolean nullSafeEquals(@Nullable Object left, @Nullable Object right) {
        return left == null ? left == right : left.equals(right);
    }

    @Nullable
    private static String emptyStringToNull(@Nullable String string) {
        return string == null || string.isEmpty() ? null : string;
    }

    static <T> T checkNotNull(@Nullable T o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o;
    }

    static <T> void checkNotNull(T ... os) {
        for (T o : os) {
            if (o != null) continue;
            throw new NullPointerException();
        }
    }

    static <T> T checkNotNull(@Nullable T o, String message) {
        if (o == null) {
            throw new NullPointerException(message);
        }
        return o;
    }

    static <T> T checkStateNotNull(@Nullable T o) {
        if (o == null) {
            throw new IllegalStateException();
        }
        return o;
    }

    static class Builder {
        private final String containerClassName;
        @Nullable
        private final String simpleFieldName;
        @Nullable
        private String shortFlagName;
        @Nullable
        private String type;
        @Nullable
        private String doc;
        @Nullable
        private DocLevel docLevel;
        @Nullable
        private String altName;

        private Builder(String containerClassName, @Nullable String simpleFieldName) {
            this.containerClassName = containerClassName;
            this.simpleFieldName = simpleFieldName;
        }

        Builder shortFlagName(@Nullable String shortFlagName) {
            this.shortFlagName = shortFlagName;
            return this;
        }

        Builder type(String type) {
            this.type = FlagDescription.checkNotNull(type);
            return this;
        }

        Builder doc(String doc) {
            this.doc = FlagDescription.checkNotNull(doc);
            return this;
        }

        Builder altName(@Nullable String altName) {
            this.altName = altName;
            return this;
        }

        Builder docLevel(DocLevel docLevel) {
            this.docLevel = FlagDescription.checkNotNull(docLevel);
            return this;
        }

        FlagDescription build() {
            return new FlagDescription(this.shortFlagName, this.containerClassName, this.simpleFieldName, FlagDescription.checkStateNotNull(this.type), FlagDescription.checkStateNotNull(this.doc), FlagDescription.checkStateNotNull(this.docLevel), this.altName);
        }
    }
}

