/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.FlagDescription;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class FlagValues {
    private final Map<String, String> values;

    public FlagValues() {
        this.values = new LinkedHashMap<String, String>();
    }

    public FlagValues(FlagValues other) {
        this.values = new LinkedHashMap<String, String>(other.values);
    }

    public void addFlag(String flag, String value) {
        FlagDescription.checkNotNull(flag);
        FlagDescription.checkNotNull(value);
        this.values.put(flag, value);
    }

    @Nullable
    public String getFlagValue(String flag) {
        FlagDescription.checkNotNull(flag);
        return this.values.get(flag);
    }

    public String[] getAllFlagsAsStringArray() {
        String[] flags = new String[this.values.size()];
        int i = 0;
        for (String flagName : this.values.keySet()) {
            String string;
            String flagValue = this.values.get(flagName);
            if ("".equals(flagValue)) {
                string = "";
            } else {
                String string2 = String.valueOf(flagValue);
                string = string2.length() != 0 ? "=".concat(string2) : new String("=");
            }
            String string3 = string;
            flags[i] = new StringBuilder(2 + String.valueOf(flagName).length() + String.valueOf(string3).length()).append("--").append(flagName).append(string3).toString();
            ++i;
        }
        return flags;
    }
}

