/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1beta3.client;

import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.BaseDatastoreFactory;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreOptions;
import java.net.URI;
import java.net.URISyntaxException;

public class DatastoreFactory
extends BaseDatastoreFactory<Datastore> {
    private static final DatastoreFactory INSTANCE = new DatastoreFactory();
    public static final String VERSION = "v1beta3";

    public static DatastoreFactory get() {
        return INSTANCE;
    }

    @Override
    public Datastore create(DatastoreOptions options) throws IllegalArgumentException {
        return new Datastore(this.newRemoteRpc(options));
    }

    @Override
    protected String buildUrl(DatastoreOptions options, String overrideUrl) {
        try {
            if (options.getProjectId() == null) {
                throw new IllegalArgumentException("project id not set in options");
            }
            String url = overrideUrl != null ? String.format("%s/projects/%s", overrideUrl, options.getProjectId()) : String.format("%s/%s/projects/%s", options.getHost(), VERSION, options.getProjectId());
            return new URI(url).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

