/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.StringUtil;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.html.HtmlEscapers;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.parameterset.ParameterSet;
import com.google.appengine.repackaged.com.google.common.util.Base64;
import com.google.appengine.repackaged.com.google.common.xml.XmlEscapers;
import com.google.appengine.repackaged.com.google.io.base.IORuntimeException;
import com.google.appengine.repackaged.com.google.io.protocol.CategoryInformation;
import com.google.appengine.repackaged.com.google.io.protocol.GrowableProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolTextParser;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.RawMessage;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.httputil.LegacyHttpHeaders;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class HtmlFormGenerator {
    private final ParameterSet parameterSet;
    private final Map<String, String> errors = Maps.newHashMap();
    private final FormInfo formInfo;
    private final PrintWriter out;
    private final EnumSet<Options> options;

    public HtmlFormGenerator(ParameterSet parameterSet, FormInfo formInfo, PrintWriter out, EnumSet<Options> options) {
        this.parameterSet = parameterSet;
        this.formInfo = formInfo;
        this.out = out;
        this.options = options;
    }

    public HtmlFormGenerator(ParameterSet parameterSet, FormInfo formInfo, PrintWriter out) {
        this.parameterSet = parameterSet;
        this.formInfo = formInfo;
        this.out = out;
        this.options = EnumSet.noneOf(Options.class);
    }

    public HtmlFormGenerator(ParameterSet parameterSet, String formName, PrintWriter out) {
        this.parameterSet = parameterSet;
        this.formInfo = new BasicFormInfo(formName);
        this.out = out;
        this.options = EnumSet.noneOf(Options.class);
    }

    public void renderHttpHeader(String contentType) {
        LegacyHttpHeaders headers = new LegacyHttpHeaders();
        headers.setHttpVersion(LegacyHttpHeaders.Version.HTTP_10);
        headers.setResponseCode(LegacyHttpHeaders.ResponseCode.REQUEST_OK);
        headers.setHeader("Pragma", "no-cache", true);
        headers.setHeader("Content-Type", contentType, true);
        try {
            headers.outputToWriterWithNewLine((Writer)this.out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void renderHeader(String title) {
        PrintWriter out = this.out;
        if (this.options.contains((Object)Options.INCLUDE_HTTP_HEADER)) {
            String contentType = this.options.contains((Object)Options.XHTML) ? "text/xhtml" : "text/html";
            this.renderHttpHeader(contentType);
        }
        if (this.options.contains((Object)Options.XHTML)) {
            out.println("<?xml version='1.0' encoding='utf-8'?>");
            out.println("<!DOCTYPE html");
            out.println("   PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
            out.println("    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            out.println("<html xmlns='http://www.w3.org/1999/xhtml'");
            out.println("      xml:lang='en' lang='en'>");
        } else {
            out.println("<!DOCTYPE html");
            out.println("    PUBLIC \"-//W3C//DTD HTML 4.01 //EN\"");
            out.println("    \"http://www.w3.org/TR/html4/strict.dtd\">");
            out.println("<html>");
        }
        out.println("<head>");
        out.format("   <title>%s</title>\n", title);
        out.println("  <meta http-equiv=\"Content-Type\"");
        out.println("        content=\"text/html; charset=utf-8\" />");
        out.println("  <style type='text/css' id='internalStyle'>");
        out.println("     h1 { text-align : center }");
        out.println("    .smallgray { color : #666666; font-size: 80%}");
        out.println("    .smalldebug { color : blue; font-size: 75%}");
        out.println("    .result    { color : blue  }");
        out.println("    .red       { color: red }");
        out.format("    .nostripe  { width: %s }\n", "8px");
        for (int i = 0; i < Constants.STRIPE_COLORS.length; ++i) {
            out.format("    .stripe%d   { background-color: #%s; width : %s }\n", i, Constants.STRIPE_COLORS[i], "12px");
        }
        out.println("  </style>");
        out.println("</head>");
        out.println("<body>");
    }

    public void renderFooter() {
        this.out.println("</body>");
        this.out.println("</html>");
        this.out.flush();
    }

    public <T extends ProtocolMessage<T>> T handleFormSubmit(String title, Class<? extends T> clazz, T protoMessage) {
        T request = this.parseRequest(clazz, protoMessage);
        if (!this.hasErrors() && this.hasParameter("submit")) {
            return request;
        }
        this.renderMessage(title, (ProtocolMessage)request);
        return null;
    }

    @Deprecated
    public <T extends ProtocolMessage<T>> T handleFormSubmit(String title, Class<T> clazz) {
        return this.handleFormSubmit(title, (Class<? extends T>)clazz, ProtocolSupport.newInstance(clazz));
    }

    public void renderMessage(String title, ProtocolMessage message) {
        boolean debugging;
        PrintWriter out = this.out;
        if (!this.options.contains((Object)Options.EXCLUDE_HTML_HEADER_FOOTER)) {
            this.renderHeader(title);
        }
        out.print("<a name='top'></a>");
        if (title != null) {
            out.format("<h1>%s</h1>", title);
        }
        if ((debugging = this.options.contains((Object)Options.DEBUG)) && this.hasErrors()) {
            out.println("<h2>Errors</h2>");
            this.showErrors();
            out.println("<hr />");
        }
        if (message != null) {
            this.renderTopLevelStructure(message);
        } else {
            this.renderHeader("Internal Error");
            out.format("<p><b>Unexpected error</b></p>\n", new Object[0]);
            out.format("<p>Internal message was '%s'</p>\n", this.errors.get("main"));
        }
        if (debugging && message != null) {
            out.println("<hr />");
            out.println("<h2>Message as string</h2>");
            out.println("<pre>");
            out.print(this.escapeContent(message));
            out.println("</pre>");
        }
        if (debugging) {
            out.println("<hr />");
            out.println("<h2>Parameter Map</h2>");
            this.showParameterMap();
        }
        out.println("<p><a href='#top'>Back to the top</a></p>\n");
        if (!this.options.contains((Object)Options.EXCLUDE_HTML_HEADER_FOOTER)) {
            this.renderFooter();
        }
    }

    private void renderTopLevelStructure(ProtocolMessage message) {
        PrintWriter out = this.out;
        boolean readOnly = this.options.contains((Object)Options.READONLY);
        CategoryInformation<ProtocolMessage> categoryInformation = message.messageCategoryInformation();
        String className = categoryInformation == null ? message.getClass().getSimpleName() : categoryInformation.getSimpleClassName(message);
        out.format("<h2>%s</h2>", className);
        if (this.hasErrors()) {
            out.println("<p class='red'><b>Input has errors!</b></p>");
        }
        if (!readOnly) {
            out.format("<form method='%s' action='%s' name='%s' id='%s'>\n", this.formInfo.getProtocolType(), this.escapeAttribute(this.formInfo.getURI()), "Editor", "Editor");
            Map<String, String> hiddenInputs = this.formInfo.getHiddenInputs();
            for (String key : hiddenInputs.keySet()) {
                out.format("<input type='hidden' name='%s' value='%s' />\n", this.escapeAttribute(key), this.escapeAttribute(hiddenInputs.get(key)));
            }
            String buttonFormat = "<input type='submit' name='%s' value='%s' />\n";
            out.format(buttonFormat, "reload", "Reload");
            if (categoryInformation == null) {
                if (this.singleTextArea()) {
                    out.format(buttonFormat, "formType", "Individual Fields");
                } else {
                    out.format(buttonFormat, "expand", "Expand");
                    out.format(buttonFormat, "formType", "Single Text Area");
                }
            }
            out.format(buttonFormat, "clear", "Clear");
            out.format(buttonFormat, "submit", this.escapeAttribute(this.formInfo.getSubmitButtonName()));
            out.println("<br /><br />");
        }
        out.format("<table cellspacing='0' cellpadding='0' border='0'>\n", new Object[0]);
        this.renderProtocolMessage(message, "", 0);
        out.println("</table>");
        if (!readOnly) {
            this.formInfo.generatePostMessageHtml(message);
            out.println("</form>");
        }
    }

    private void renderProtocolMessage(ProtocolMessage message, String structureID, int indent) {
        String uninterpretedTags = this.encodeUninterpretedTagsFrom(message);
        if (uninterpretedTags != null) {
            this.out.format("<input type='hidden' name='%s%s' value='%s' />", "utags-", structureID, uninterpretedTags);
        }
        if (this.singleTextArea() || message.messageCategoryInformation() != null) {
            boolean readOnly = this.options.contains((Object)Options.READONLY);
            this.out.append("<b>Text representation of protocol buffer:</b><br />");
            this.out.format("<textarea name='%s' %s rows='20' cols='75'>%s</textarea>", "primaryTextArea", readOnly ? "readonly " : "", message);
        } else {
            List<ProtocolType.FieldType> tags = ProtocolType.getTags(message);
            for (ProtocolType.FieldType tag : tags) {
                int n = tag.getTag();
                this.renderOneField(message, new StringBuilder(11 + String.valueOf(structureID).length()).append(structureID).append(n).toString(), tag, indent);
            }
        }
    }

    private boolean singleTextArea() {
        return "Single Text Area".equals(this.getParameter("formType"));
    }

    private void renderOneField(ProtocolMessage message, String fieldID, ProtocolType.FieldType fieldType, int indent) {
        boolean readOnly = this.options.contains((Object)Options.READONLY);
        ProtocolType.Presence presence = fieldType.getPresence();
        ProtocolType.FieldBaseType baseType = fieldType.getBaseType();
        boolean isStructure = baseType == ProtocolType.FieldBaseType.GROUP || baseType == ProtocolType.FieldBaseType.FOREIGN;
        String extra = "";
        int count = fieldType.size(message);
        if (presence != ProtocolType.Presence.REPEATED) {
            Object value = fieldType.getSingleValue(message);
            if (presence == ProtocolType.Presence.OPTIONAL) {
                if (readOnly) {
                    extra = String.format("<span>Optional %s</span>", count == 0 ? "missing" : "present");
                } else if (isStructure) {
                    extra = HtmlFormGenerator.getSubmitButtonsMarkup(String.valueOf(fieldID).concat("."), count == 0 ? "Create" : "Delete");
                } else {
                    String checked = count > 0 ? " checked='checked'" : "";
                    extra = String.format("<label><input type='checkbox' name='%s.' id='id%s' value='y'%s />include this field</label>", fieldID, fieldID, checked);
                }
            } else {
                count = 1;
            }
            this.renderOneValue(value, indent, fieldType, fieldID, extra, count);
        } else if (count == 0) {
            char checked = '-';
            String elementID = new StringBuilder(2 + String.valueOf(fieldID).length()).append(fieldID).append(checked).append("0").toString();
            Object value = null;
            extra = readOnly ? "<span>Empty array</span>" : HtmlFormGenerator.getSubmitButtonsMarkup(String.valueOf(elementID).concat("."), "Create");
            this.renderOneValue(value, indent, fieldType, elementID, extra, 0);
        } else {
            for (int i = 0; i < count; ++i) {
                Object value = fieldType.getNthValue(message, i);
                char c = '-';
                int n = i;
                String elementID = new StringBuilder(12 + String.valueOf(fieldID).length()).append(fieldID).append(c).append(n).toString();
                if (!readOnly) {
                    extra = HtmlFormGenerator.getSubmitButtonsMarkup(String.valueOf(elementID).concat("."), "Add", "Delete");
                }
                this.renderOneValue(value, indent, fieldType, elementID, extra, i + 1);
            }
        }
    }

    private void renderOneValue(Object value, int indent, ProtocolType.FieldType fieldType, String valueID, String extra, int count) {
        String checkbox;
        PrintWriter out = this.out;
        boolean readOnly = this.options.contains((Object)Options.READONLY);
        String fieldName = fieldType.getName();
        ProtocolType.Presence presence = fieldType.getPresence();
        ProtocolType.FieldBaseType baseType = fieldType.getBaseType();
        boolean isStructure = baseType == ProtocolType.FieldBaseType.GROUP || baseType == ProtocolType.FieldBaseType.FOREIGN;
        boolean isRepeated = presence == ProtocolType.Presence.REPEATED;
        boolean isRawMessage = RawMessage.class.equals(fieldType.getSubclass());
        Class<? extends Enum> enumType = fieldType.getEnumType();
        String javaScript = "";
        if (presence == ProtocolType.Presence.OPTIONAL && !isStructure && !readOnly) {
            checkbox = this.options.contains((Object)Options.XHTML) ? String.format("getElementById('id%s')", valueID) : String.format("%s.elements['%s.']", "Editor", valueID);
            javaScript = String.format(" onfocus=\"document.%s.checked=true;\"", checkbox);
        }
        if (extra.length() > 0) {
            checkbox = extra;
            extra = new StringBuilder(44 + String.valueOf(checkbox).length()).append("<td>&nbsp;</td><td class='smallgray'>\n").append(checkbox).append("\n</td>").toString();
        }
        out.format("<tr>", new Object[0]);
        for (int i = 0; i < indent; ++i) {
            out.format("<td class='stripe%s' />\n", i % Constants.STRIPE_COLORS.length);
            out.format("<td class='nostripe' />\n", new Object[0]);
        }
        out.format("<td colspan='%s'>%s", 2 * (25 - indent), fieldName);
        if (isRepeated && count >= 1) {
            out.format(" #%d", count);
        }
        if (this.options.contains((Object)Options.DEBUG)) {
            out.format("<span class='smalldebug'> %s </span>", valueID);
        }
        String errorValue = this.errors.get(valueID);
        out.format(":\n", new Object[0]);
        if (errorValue != null) {
            out.format("<span class='red'> Illegal %s value </span>\n", new Object[]{baseType});
        }
        if (count == 0 && (isRepeated || isStructure)) {
            out.format("</td>%s</tr>\n", extra);
        } else if (isRawMessage) {
            this.generateTextField(BaseEncoding.base64Url().encode(((ProtocolMessage)value).toByteArray()), valueID, baseType, errorValue, javaScript, extra);
        } else if (isStructure) {
            ProtocolMessage message = (ProtocolMessage)value;
            if (message == null) {
                message = ProtocolSupport.newInstance(fieldType.getSubclass());
            }
            out.format("<input type='hidden' name='%s' value='t' />", valueID);
            out.format("</td>%s</tr>\n", extra);
            char c = '.';
            this.renderProtocolMessage(message, new StringBuilder(1 + String.valueOf(valueID).length()).append(valueID).append(c).toString(), indent + 1);
        } else if (enumType != null) {
            this.generateEnumerationField(value, valueID, enumType, javaScript, extra);
        } else if (baseType == ProtocolType.FieldBaseType.BOOL) {
            this.generateBooleanField(value, valueID, javaScript, extra);
        } else {
            this.generateTextField(value, valueID, baseType, errorValue, javaScript, extra);
        }
    }

    public static String getSubmitButtonsMarkup(String name, String ... values) {
        StringBuilder sb = new StringBuilder(String.format("<a name='%s'>", name));
        for (String value : values) {
            sb.append(String.format("<input type='submit' name='%s' value='%s' onclick='document.getElementById(\"%s\").action += \"#%s\"' />", name, value, "Editor", name));
        }
        return sb.append("</a>").toString();
    }

    private void generateEnumerationField(Object value, String valueID, Class<? extends Enum> enumClass, String javaScript, String extra) {
        boolean readOnly = this.options.contains((Object)Options.READONLY);
        boolean skipSelect = readOnly || this.options.contains((Object)Options.XHTML) || this.options.contains((Object)Options.DEBUG) || this.options.contains((Object)Options.USE_INPUT_FOR_ENUM);
        Enum enumm = null;
        this.out.format("<label>", new Object[0]);
        if (!skipSelect) {
            try {
                Method method = enumClass.getMethod("valueOf", Integer.TYPE);
                enumm = (Enum)method.invoke(null, value);
            }
            catch (NoSuchMethodException nsmEx) {
                nsmEx.printStackTrace();
            }
            catch (IllegalAccessException illEx) {
                illEx.printStackTrace();
            }
            catch (InvocationTargetException itEx) {
                itEx.printStackTrace();
            }
        }
        if (enumm != null) {
            if (javaScript.length() > 0) {
                javaScript = javaScript.replaceFirst("onfocus=", "onchange=");
            }
            this.out.format("<select name='%s' %s %s>\n", valueID, readOnly ? "disabled" : "", javaScript);
            for (Enum enumName : enumClass.getEnumConstants()) {
                int evalue = ((ProtocolMessageEnum)((Object)enumName)).getValue();
                this.out.format("<option value='%s' %s>%s (%s)</option>\n", evalue, enumm == enumName ? "selected" : "", enumName, evalue);
            }
            this.out.print("</select>");
        } else {
            this.out.format("<input type='text' name='%s' value='%s' %s %s/>", valueID, value, readOnly ? "disabled" : "", javaScript);
        }
        this.out.format("</label></td>%s</tr>\n", extra);
    }

    private void generateBooleanField(Object value, String valueID, String javaScript, String extra) {
        boolean readOnly = this.options.contains((Object)Options.READONLY);
        if (javaScript.length() > 0) {
            javaScript = javaScript.replaceFirst("onfocus=", "onclick=");
        }
        boolean isTrue = (Boolean)value;
        this.out.format("<label><input type='radio' name='%s' value='t'%s%s %s/>true</label>\n", valueID, isTrue ? " checked='checked' " : " ", readOnly ? " disabled" : " ", javaScript);
        this.out.format("<label><input type='radio' name='%s' value='f'%s%s %s/>false</label>\n", valueID, isTrue ? " " : " checked='checked' ", readOnly ? " disabled" : " ", javaScript);
        this.out.format("</td>%s</tr>\n", extra);
    }

    private void generateTextField(Object value, String valueID, ProtocolType.FieldBaseType baseType, String errorValue, String javaScript, String extra) {
        boolean readOnly = this.options.contains((Object)Options.READONLY);
        if (errorValue != null) {
            this.out.format("<input class='red' type='text' name='%s' value='%s'%s /></td>%s</tr>\n", valueID, errorValue, javaScript, extra);
        } else {
            if (value == null) {
                value = "";
            }
            int rows = 10;
            boolean useTextArea = false;
            if (baseType == ProtocolType.FieldBaseType.STRING) {
                if (value instanceof byte[]) {
                    value = Protocol.toStringUtf8((byte[])value);
                }
                if (this.options.contains((Object)Options.USE_TEXT_AREA) && value.toString().contains("\r\n")) {
                    useTextArea = true;
                }
            }
            boolean containsHtml = false;
            if (StringUtil.containsCharRef(value.toString())) {
                containsHtml = true;
                rows = 25;
            }
            if (this.options.contains((Object)Options.HTML_ESCAPE_FIELDS)) {
                value = this.escapeContent(value);
            }
            if (readOnly) {
                if (containsHtml || useTextArea) {
                    this.out.format("<textarea rows='%s' cols='75' readonly>%s</textarea>", rows, value);
                } else {
                    this.out.format("<span class='result'>%s</span>", value);
                }
            } else if (containsHtml || useTextArea) {
                this.out.format("<textarea name='%s' rows='%s' cols='75'%s>%s</textarea>", valueID, rows, javaScript, value);
            } else {
                this.out.format("<input type='text' name='%s' value='%s'%s />", valueID, value, javaScript);
            }
            this.out.format("</td>%s</tr>\n", extra);
        }
    }

    private <T extends ProtocolMessage<T>> T parseRequest(Class<? extends T> clazz, T protoMessage) {
        ProtocolMessage newInstance = (ProtocolMessage)clazz.cast(protoMessage.newInstance());
        if (this.hasParameter("clear")) {
            return (T)newInstance;
        }
        if (this.hasParameter("primaryTextArea")) {
            try {
                return (T)ProtocolTextParser.parse((CharSequence)this.getParameter("primaryTextArea"), newInstance);
            }
            catch (RuntimeException e) {
                this.errors.put("main", e.getMessage());
                return null;
            }
        }
        GrowableProtocolSink ps = new GrowableProtocolSink();
        this.structureToSink("", "", clazz, ps);
        if (newInstance.mergeFrom(new ProtocolSource(ps.array(), 0, ps.position()))) {
            return (T)newInstance;
        }
        this.errors.put("main", "Internal error parsing Data Sink");
        return null;
    }

    private void structureToSink(String inStructureID, String outStructureID, Class<? extends ProtocolMessage> clazz, GrowableProtocolSink sink) {
        List<ProtocolType.FieldType> tags = ProtocolType.getTags(clazz);
        for (int i = 0; i < tags.size(); ++i) {
            ProtocolType.FieldType tag = tags.get(i);
            int n = tag.getTag();
            this.fieldToSink(new StringBuilder(11 + String.valueOf(inStructureID).length()).append(inStructureID).append(n).toString(), tag, sink, clazz);
        }
        String string = String.valueOf("utags-");
        String string2 = String.valueOf(inStructureID);
        String uninterpretedTags = this.getParameter(string2.length() != 0 ? string.concat(string2) : new String(string));
        if (uninterpretedTags != null) {
            this.mergeUninterpretedTagsInto(sink, uninterpretedTags);
        }
    }

    private void fieldToSink(String fieldId, ProtocolType.FieldType fieldType, GrowableProtocolSink sink, Class<? extends ProtocolMessage> clazz) {
        boolean isStructure;
        ProtocolType.Presence presence = fieldType.getPresence();
        ProtocolType.FieldBaseType baseType = fieldType.getBaseType();
        boolean bl = isStructure = baseType == ProtocolType.FieldBaseType.GROUP || baseType == ProtocolType.FieldBaseType.FOREIGN;
        if (presence != ProtocolType.Presence.REPEATED) {
            String value = this.getParameter(fieldId);
            if (presence == ProtocolType.Presence.OPTIONAL) {
                String secondParameterKey = String.valueOf(fieldId).concat(".");
                String secondParameterValue = this.getParameter(secondParameterKey);
                if (!isStructure) {
                    if (secondParameterValue == null) {
                        return;
                    }
                } else if ("Create".equals(secondParameterValue)) {
                    value = null;
                } else {
                    if ("Delete".equals(secondParameterValue)) {
                        return;
                    }
                    if (value == null && !this.hasParameter("expand")) {
                        return;
                    }
                }
            }
            this.valueToSink(clazz, fieldType, fieldId, fieldId, value, sink);
        } else {
            int count = 0;
            int i = 0;
            while (true) {
                char c = '-';
                int n = i;
                String inkey = new StringBuilder(12 + String.valueOf(fieldId).length()).append(fieldId).append(c).append(n).toString();
                n = 45;
                int n2 = count++;
                String outkey = new StringBuilder(12 + String.valueOf(fieldId).length()).append(fieldId).append((char)n).append(n2).toString();
                String actionKey = String.valueOf(inkey).concat(".");
                String value = this.getParameter(inkey);
                String actionValue = this.getParameter(actionKey);
                if (i == 0 && "Create".equals(actionValue)) {
                    this.valueToSink(clazz, fieldType, inkey, outkey, null, sink);
                }
                if (value == null) break;
                if (!"Delete".equals(actionValue)) {
                    ++count;
                    this.valueToSink(clazz, fieldType, inkey, outkey, value, sink);
                }
                if ("Add".equals(actionValue)) {
                    ++count;
                    this.valueToSink(clazz, fieldType, inkey, outkey, null, sink);
                }
                ++i;
            }
            if (count == 0 && this.hasParameter("expand")) {
                char c = '-';
                String key = new StringBuilder(2 + String.valueOf(fieldId).length()).append(fieldId).append(c).append("0").toString();
                this.valueToSink(clazz, fieldType, key, key, null, sink);
            }
        }
    }

    private void valueToSink(Class<? extends ProtocolMessage> clazz, ProtocolType.FieldType fieldType, String inValueID, String outValueID, String value, GrowableProtocolSink sink) {
        if (value == null) {
            value = "";
        }
        sink.putVarInt(fieldType.getWireTag());
        switch (fieldType.getBaseType()) {
            case BOOL: {
                boolean result = value.length() > 0 && value.charAt(0) == 't';
                sink.putBoolean(result);
                break;
            }
            case FIXED32: 
            case INT32: {
                int result;
                try {
                    result = value.length() == 0 ? this.defaultFieldValue(clazz, fieldType).intValue() : Integer.decode(value).intValue();
                }
                catch (NumberFormatException e) {
                    this.errors.put(outValueID, value);
                    result = 0;
                }
                if (fieldType.getBaseType().isFixed()) {
                    sink.putInt(result);
                    break;
                }
                sink.putVarInt(result);
                break;
            }
            case FIXED64: 
            case UINT64: 
            case INT64: {
                long result;
                try {
                    result = value.length() == 0 ? this.defaultFieldValue(clazz, fieldType).longValue() : Long.decode(value).longValue();
                }
                catch (NumberFormatException e) {
                    this.errors.put(outValueID, value);
                    result = 0L;
                }
                if (fieldType.getBaseType().isFixed()) {
                    sink.putLong(result);
                    break;
                }
                sink.putVarLong(result);
                break;
            }
            case DOUBLE: {
                double result;
                try {
                    result = value.length() == 0 ? this.defaultFieldValue(clazz, fieldType).doubleValue() : Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    this.errors.put(outValueID, value);
                    result = 0.0;
                }
                sink.putDouble(result);
                break;
            }
            case FLOAT: {
                float result;
                try {
                    result = value.length() == 0 ? this.defaultFieldValue(clazz, fieldType).floatValue() : Float.parseFloat(value);
                }
                catch (NumberFormatException e) {
                    this.errors.put(outValueID, value);
                    result = 0.0f;
                }
                sink.putFloat(result);
                break;
            }
            case FOREIGN: {
                if (value.length() == 0) {
                    ProtocolMessage message = ProtocolSupport.newInstance(fieldType.getSubclass());
                    ProtocolSink pSink = message.toProtocolSink();
                    sink.putVarInt(pSink.position());
                    sink.putBytes(pSink.array(), 0, pSink.position());
                    break;
                }
                if (fieldType.getSubclass() == RawMessage.class) {
                    ProtocolSink pSink = this.getRawMessageProtocolSink(outValueID, value);
                    sink.putVarInt(pSink.position());
                    sink.putBytes(pSink.array(), 0, pSink.position());
                    break;
                }
                GrowableProtocolSink newSink = new GrowableProtocolSink();
                char pSink = '.';
                String string = new StringBuilder(1 + String.valueOf(inValueID).length()).append(inValueID).append(pSink).toString();
                pSink = '.';
                this.structureToSink(string, new StringBuilder(1 + String.valueOf(outValueID).length()).append(outValueID).append(pSink).toString(), fieldType.getSubclass(), newSink);
                sink.putPrefixedData(newSink.toArray());
                break;
            }
            case GROUP: {
                if (value.length() == 0) {
                    ProtocolMessage message = ProtocolSupport.newInstance(fieldType.getSubclass());
                    ProtocolSink pSink = message.toProtocolSink();
                    sink.putBytes(pSink.array(), 0, pSink.position());
                    break;
                }
                char message = '.';
                String string = new StringBuilder(1 + String.valueOf(inValueID).length()).append(inValueID).append(message).toString();
                message = '.';
                this.structureToSink(string, new StringBuilder(1 + String.valueOf(outValueID).length()).append(outValueID).append(message).toString(), fieldType.getSubclass(), sink);
                sink.putVarInt(fieldType.getWireTag() + 1);
                break;
            }
            case STRING: {
                if (this.options.contains((Object)Options.HTML_ESCAPE_FIELDS)) {
                    value = this.unescape(value);
                }
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                sink.putVarInt(bytes.length);
                sink.putBytes(bytes);
            }
        }
    }

    private ProtocolSink getRawMessageProtocolSink(String outValueID, String value) {
        byte[] result = new byte[]{};
        try {
            result = Base64.decodeWebSafe(value.getBytes());
        }
        catch (IllegalArgumentException e) {
            this.errors.put(outValueID, value);
        }
        RawMessage rawMessage = new RawMessage();
        rawMessage.mergeFrom(result);
        ProtocolSink pSink = rawMessage.toProtocolSink();
        return pSink;
    }

    private Number defaultFieldValue(Class<? extends ProtocolMessage> clazz, ProtocolType.FieldType fieldType) {
        if (fieldType.getPresence() == ProtocolType.Presence.REPEATED) {
            return 0;
        }
        return (Number)fieldType.getSingleValue(ProtocolSupport.newInstance(clazz));
    }

    protected void mergeUninterpretedTagsInto(GrowableProtocolSink sink, String uninterpretedTags) {
        if (uninterpretedTags == null) {
            return;
        }
        try {
            sink.putBytes(Base64.decodeWebSafe(uninterpretedTags));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    protected String encodeUninterpretedTagsFrom(ProtocolMessage pb) {
        UninterpretedTags utags = ProtocolSupport.getUninterpreted(pb);
        if (utags == null) {
            return null;
        }
        ProtocolSink sink = new ProtocolSink(utags.encodingSize());
        utags.put(sink);
        return BaseEncoding.base64Url().encode(sink.array());
    }

    private void showParameterMap() {
        ArrayList list = new ArrayList();
        Iterator iterator = this.parameterSet.getParameterNames();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        Collections.sort(list);
        this.out.println("<table border='1' cellpadding='2' summary='Arguments'>");
        this.out.println("<tr><th>Parameter</th> <th>Value</th></tr>");
        for (String key : list) {
            String value = this.getParameter(key);
            String ekey = this.escapeContent(key);
            String evalue = value.length() == 0 ? "<span class='red'>&lt;empty&gt;</span>" : this.escapeContent(value);
            this.out.format("<tr><td><code>%s</code></td><td><code>%s</code></td></tr>\n", ekey, evalue);
        }
        this.out.println("</table>");
    }

    private void showErrors() {
        this.out.println("<table border='1' cellpadding='2' summary='Errors'>");
        for (String key : this.errors.keySet()) {
            String value = this.errors.get(key);
            this.out.format("<tr><td><code>%s</code></td><td><code>%s</code></td></tr>\n", this.escapeContent(key), this.escapeContent(value));
        }
        this.out.println("</table>");
    }

    private boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    private String getParameter(String key) {
        return this.parameterSet.getParameter(key);
    }

    private boolean hasParameter(String key) {
        return this.parameterSet.getParameter(key) != null;
    }

    private String escapeAttribute(Object obj) {
        return this.options.contains((Object)Options.XHTML) ? XmlEscapers.xmlAttributeEscaper().escape(obj.toString()) : HtmlEscapers.htmlEscaper().escape(obj.toString());
    }

    private String escapeContent(Object obj) {
        return this.options.contains((Object)Options.XHTML) ? XmlEscapers.xmlContentEscaper().escape(obj.toString()) : HtmlEscapers.htmlEscaper().escape(obj.toString());
    }

    private String unescape(String escapedString) {
        return StringUtil.unescapeHTML(escapedString);
    }

    public static enum Options {
        XHTML,
        DEBUG,
        READONLY,
        INCLUDE_HTTP_HEADER,
        EXCLUDE_HTML_HEADER_FOOTER,
        HTML_ESCAPE_FIELDS,
        USE_TEXT_AREA,
        USE_INPUT_FOR_ENUM;

    }

    public static class BasicFormInfo
    implements FormInfo {
        private final String uri;

        public BasicFormInfo(String uri) {
            this.uri = uri;
        }

        @Override
        public Map<String, String> getHiddenInputs() {
            return Maps.newHashMap();
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        @Override
        public LegacyHttpHeaders.Protocol getProtocolType() {
            return LegacyHttpHeaders.Protocol.GET;
        }

        @Override
        public String getSubmitButtonName() {
            return "Submit";
        }

        @Override
        public void generatePostMessageHtml(ProtocolMessage message) {
        }
    }

    public static interface FormInfo {
        public Map<String, String> getHiddenInputs();

        public String getURI();

        public LegacyHttpHeaders.Protocol getProtocolType();

        public String getSubmitButtonName();

        public void generatePostMessageHtml(ProtocolMessage var1);
    }

    public static final class Constants {
        public static final int MAXIMUM_INDENT = 25;
        public static final int COLUMNS_PER_INDENT = 2;
        public static final String EXPAND_VARIABLE = "expand";
        public static final String INDIVIDUAL_FIELDS_VALUE = "Individual Fields";
        public static final String SINGLE_TEXT_AREA_VALUE = "Single Text Area";
        public static final String FORM_TYPE_VARIABLE = "formType";
        public static final String PRIMARY_TEXT_AREA_VARIABLE = "primaryTextArea";
        public static final String SUBMIT_VARIABLE = "submit";
        public static final String RELOAD_VARIABLE = "reload";
        public static final String CLEAR_VARIABLE = "clear";
        public static final String CREATE_ACTION = "Create";
        public static final String DELETE_ACTION = "Delete";
        public static final String ADD_ACTION = "Add";
        public static final String ENCLOSING_FORM_NAME = "Editor";
        public static final String[] STRIPE_COLORS = new String[]{"00ee00", "00cc00", "00aa00", "008800", "006600"};
        public static final String STRIPES_WIDTH = "12px";
        public static final String BETWEEN_STRIPES_WIDTH = "8px";
        public static final char STRUCT_SEPARATOR = '.';
        public static final char ARRAY_SEPARATOR = '-';
        public static final String LINE_BREAK_CHARACTER_STRING = "\r\n";
        public static final String UNINTERPRETED_PREFIX = "utags-";
    }
}

