/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MutableGeneratedMetadataProto;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class InternalProtobufMeta {
    private static final String PROTOBUF_META_FILE = "protobuf.meta";
    private static final InternalProtobufMeta INSTANCE = new InternalProtobufMeta(InternalProtobufMeta.loadMetadata());
    private final List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> extensions = new ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry>();
    private final List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> messages = new ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry>();

    private InternalProtobufMeta(List<MutableGeneratedMetadataProto.GeneratedMetadata> metadatas) {
        HashSet<EntryKey> foundExtensionKeys = new HashSet<EntryKey>();
        HashSet<EntryKey> foundMessageKeys = new HashSet<EntryKey>();
        for (MutableGeneratedMetadataProto.GeneratedMetadata metadata : metadatas) {
            EntryKey key;
            for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry generatedExtensionEntry : metadata.getExtensionList()) {
                key = new EntryKey(generatedExtensionEntry);
                if (foundExtensionKeys.contains(key)) continue;
                foundExtensionKeys.add(key);
                this.extensions.add(generatedExtensionEntry);
            }
            for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry generatedMessageEntry : metadata.getGeneratedMessageList()) {
                key = new EntryKey(generatedMessageEntry);
                if (foundMessageKeys.contains(key)) continue;
                foundMessageKeys.add(key);
                this.messages.add(generatedMessageEntry);
            }
        }
    }

    public static InternalProtobufMeta getInstance() {
        return INSTANCE;
    }

    public List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> getExtensions() {
        return this.extensions;
    }

    public List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> getMessages() {
        return this.messages;
    }

    private static List<MutableGeneratedMetadataProto.GeneratedMetadata> loadMetadata() {
        ClassLoader loader = InternalProtobufMeta.class.getClassLoader();
        ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata> metadatas = new ArrayList<MutableGeneratedMetadataProto.GeneratedMetadata>();
        try {
            Enumeration<URL> urls = loader.getResources(PROTOBUF_META_FILE);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                metadatas.add(InternalProtobufMeta.load(url));
            }
            return metadatas;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load generated message meta data.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MutableGeneratedMetadataProto.GeneratedMetadata load(URL url) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(url.openStream());){
            MutableGeneratedMetadataProto.GeneratedMetadata metadata = MutableGeneratedMetadataProto.GeneratedMetadata.newMessage();
            if (!metadata.parseFrom(is)) {
                throw new InvalidProtocolBufferException("Failed to parse metadata proto.");
            }
            MutableGeneratedMetadataProto.GeneratedMetadata generatedMetadata = metadata;
            return generatedMetadata;
        }
    }

    private static class EntryKey {
        private final String name;
        private final boolean immutable;

        EntryKey(MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry messageEntry) {
            this.name = messageEntry.getName();
            this.immutable = messageEntry.getImmutable();
        }

        EntryKey(MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry extensionEntry) {
            this.name = extensionEntry.getName();
            this.immutable = extensionEntry.getImmutable();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntryKey)) {
                return false;
            }
            EntryKey that = (EntryKey)other;
            return Objects.equals(this.name, that.name) && Objects.equals(this.immutable, that.immutable);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.immutable);
        }
    }
}

