/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileApiServlet;
import com.google.apphosting.client.datastoreservice.app.mobile.IdTokenAuthenticator;
import com.google.apphosting.client.serviceapp.AuthService;
import com.google.apphosting.datastore.EntityV4;

public class MobileEntityV4Normalizer
extends EntityV4Normalizer {
    @VisibleForTesting
    static final String GOOGLE_ACCOUNT_PREFIX = "accounts.google.com|";
    private final AuthService authService;
    private final IdTokenAuthenticator idTokenAuth;

    public MobileEntityV4Normalizer(EntityTranslator translator, EntityTranslator.Format internalFormat, String defaultDatasetId, AuthService authService, IdTokenAuthenticator idTokenAuth) {
        super(translator, internalFormat, defaultDatasetId);
        this.authService = authService;
        this.idTokenAuth = idTokenAuth;
    }

    @Override
    protected EntityV4.Key.Builder normalizeKey(EntityV4.Key.Builder key) {
        String fullUserId;
        if ((key = super.normalizeKey(key)).getPathElementCount() == 0) {
            return key;
        }
        EntityV4.Key.PathElementOrBuilder root = key.getPathElementOrBuilder(0);
        if (root.getKind().equals("__gcd_user") && !root.hasName() && !root.hasId() && (fullUserId = this.getFullUserId()) != null) {
            key.getPathElementBuilder(0).setName(fullUserId);
        }
        return key;
    }

    @Override
    public boolean isNormalKey(EntityV4.KeyOrBuilder key) {
        return super.isNormalKey(key) && (key.getPathElementCount() == 0 || key.getPathElement(0).hasName() || key.getPathElement(0).hasId());
    }

    public String getFullUserId() {
        if (this.idTokenAuth.getFullUserId() != null) {
            return this.idTokenAuth.getFullUserId();
        }
        try {
            User user = this.authService.getUserPermissions(DatastoreMobileApiServlet.OAUTH2_SCOPE_CODES, false).getUser();
            String string = String.valueOf(user.getUserId());
            return string.length() != 0 ? "google:".concat(string) : new String("google:");
        }
        catch (OAuthRequestException oAuthRequestException) {
            return null;
        }
    }

    public AuthService getAuthService() {
        return this.authService;
    }
}

