/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.search.DeleteException;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Empty;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.searchservice.app.CloudSearchRpcHandler;
import com.google.apphosting.client.searchservice.app.InternalSearchApiUtils;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.cloudsearch.v1.DeleteDocumentRequest;

class DeleteDocumentRpcHandler
extends CloudSearchRpcHandler<DeleteDocumentRequest, Empty> {
    DeleteDocumentRpcHandler() {
    }

    @Override
    public Empty call(RpcHandler.CallOptions options, DeleteDocumentRequest req) throws RpcException {
        Index index = InternalSearchApiUtils.getIndex(req.getIndexId());
        Preconditions.checkArgument(!Strings.isNullOrEmpty(req.getDocId()), "docId is required.");
        try {
            index.delete(req.getDocId());
        }
        catch (IllegalArgumentException e) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, e.getMessage());
        }
        catch (DeleteException e) {
            OperationResult opResult = e.getOperationResult();
            throw new RpcException(DeleteDocumentRpcHandler.fromInternalCode(opResult.getCode()), MoreObjects.firstNonNull(opResult.getMessage(), ""));
        }
        return Empty.newBuilder().build();
    }

    @Override
    public Parser<DeleteDocumentRequest> getParser() {
        return DeleteDocumentRequest.PARSER;
    }

    @Override
    public Class<DeleteDocumentRequest> getRequestClass() {
        return DeleteDocumentRequest.class;
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(DeleteDocumentRequest request) {
        return RpcHandler.RequestPermissions.READ_WRITE;
    }
}

