/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;

public final class ThreadManager {
    private static final String REQUEST_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY";
    private static final String BACKGROUND_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.BACKGROUND_THREAD_FACTORY";

    public static ThreadFactory currentRequestThreadFactory() {
        ApiProxy.Environment environment = ThreadManager.getCurrentEnvironmentOrThrow();
        return (ThreadFactory)environment.getAttributes().get(REQUEST_THREAD_FACTORY_ATTR);
    }

    public static Optional<ThreadFactory> currentRequestThreadFactoryOptional() {
        return Optional.ofNullable(ApiProxy.getCurrentEnvironment()).flatMap(environment -> Optional.ofNullable((ThreadFactory)environment.getAttributes().get(REQUEST_THREAD_FACTORY_ATTR)));
    }

    public static Thread createThreadForCurrentRequest(Runnable runnable) {
        return ThreadManager.currentRequestThreadFactory().newThread(runnable);
    }

    public static ThreadFactory backgroundThreadFactory() {
        ApiProxy.Environment environment = ThreadManager.getCurrentEnvironmentOrThrow();
        return (ThreadFactory)environment.getAttributes().get(BACKGROUND_THREAD_FACTORY_ATTR);
    }

    public static Thread createBackgroundThread(Runnable runnable) {
        return ThreadManager.backgroundThreadFactory().newThread(runnable);
    }

    private static ApiProxy.Environment getCurrentEnvironmentOrThrow() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new NullPointerException("Current thread is not associated with any request and is not a background thread");
        }
        return environment;
    }
}

