/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Rating
implements Serializable,
Comparable<Rating> {
    public static final long serialVersionUID = 362898405551261187L;
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 100;
    private int rating;

    public Rating(int rating) {
        if (rating < 0 || rating > 100) {
            throw new IllegalArgumentException(String.format("rating must be no smaller than %d and no greater than %d (received %d)", 0, 100, rating));
        }
        this.rating = rating;
    }

    private Rating() {
        this(0);
    }

    public int getRating() {
        return this.rating;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rating rating1 = (Rating)o;
        return this.rating == rating1.rating;
    }

    public int hashCode() {
        return this.rating;
    }

    @Override
    public int compareTo(Rating o) {
        return Integer.compare(this.rating, o.rating);
    }
}

