/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FacetQueryChecker;
import com.google.appengine.repackaged.com.google.appengine.api.search.proto.SearchServicePb;

public final class FacetOptions {
    private final Integer discoveryValueLimit;
    private final Integer discoveryLimit;
    private final Integer depth;

    private FacetOptions(Builder builder) {
        this.discoveryValueLimit = builder.discoveryValueLimit;
        this.discoveryLimit = builder.discoveryLimit;
        this.depth = builder.depth;
    }

    public Integer getDiscoveryLimit() {
        return this.discoveryLimit;
    }

    public Integer getDiscoveryValueLimit() {
        return this.discoveryValueLimit;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(FacetOptions options) {
        return new Builder(options);
    }

    void copyToProtocolBuffer(SearchServicePb.SearchParams.Builder builder, boolean enableFacetDiscovery) {
        if (enableFacetDiscovery) {
            if (this.discoveryLimit == null) {
                builder.setAutoDiscoverFacetCount(10);
            } else {
                builder.setAutoDiscoverFacetCount(this.discoveryLimit);
            }
        } else {
            builder.clearAutoDiscoverFacetCount();
        }
        if (this.depth != null) {
            builder.setFacetDepth(this.depth);
        }
        if (this.discoveryValueLimit != null) {
            builder.setFacetAutoDetectParam(SearchServicePb.FacetAutoDetectParam.newBuilder().setValueLimit(this.discoveryValueLimit));
        }
    }

    public String toString() {
        return new Util.ToStringHelper("FacetOptions").addField("discoveryValueLimit", this.getDiscoveryValueLimit()).addField("discoveryLimit", this.getDiscoveryLimit()).addField("depth", this.getDepth()).finish();
    }

    public static final class Builder {
        private Integer discoveryValueLimit;
        private Integer discoveryLimit;
        private Integer depth;

        private Builder() {
        }

        private Builder(FacetOptions options) {
            this.discoveryValueLimit = options.getDiscoveryValueLimit();
            this.discoveryLimit = options.getDiscoveryLimit();
            this.depth = options.getDepth();
        }

        public Builder setDiscoveryValueLimit(int value) {
            this.discoveryValueLimit = FacetQueryChecker.checkDiscoveryValueLimit(value);
            return this;
        }

        public Builder setDiscoveryLimit(int value) {
            this.discoveryLimit = FacetQueryChecker.checkDiscoveryLimit(value);
            return this;
        }

        public Builder setDepth(int value) {
            this.depth = FacetQueryChecker.checkDepth(value);
            return this;
        }

        public FacetOptions build() {
            return new FacetOptions(this);
        }
    }
}

