/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.FacetRefinement;
import com.google.appengine.api.search.Util;
import com.google.appengine.repackaged.com.google.appengine.api.search.proto.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;

public final class FacetResultValue
implements Serializable {
    private static final long serialVersionUID = 1171761338331659834L;
    private final String label;
    private final int count;
    private final String refinementToken;

    public static FacetResultValue create(String label, int count, String refinementToken) {
        return new FacetResultValue(label, count, refinementToken);
    }

    private FacetResultValue(String label, int count, String refinementToken) {
        Preconditions.checkNotNull(label, "label cannot be null");
        Preconditions.checkNotNull(refinementToken, "refinementToken cannot be null");
        Preconditions.checkArgument(!label.isEmpty(), "label cannot be empty");
        Preconditions.checkArgument(!refinementToken.isEmpty(), "refinementToken cannot be empty");
        this.label = label;
        this.count = count;
        this.refinementToken = refinementToken;
        this.checkValid();
    }

    public String getLabel() {
        return this.label;
    }

    public String getRefinementToken() {
        return this.refinementToken;
    }

    public int getCount() {
        return this.count;
    }

    private void checkValid() {
        Preconditions.checkState(this.label != null && !this.label.isEmpty(), "Label cannot be empty.");
        Preconditions.checkState(this.refinementToken != null && !this.refinementToken.isEmpty(), "Refinement token cannot be empty.");
    }

    static FacetResultValue withProtoMessage(SearchServicePb.FacetResultValue facetResultValue) {
        return FacetResultValue.create(facetResultValue.getName(), facetResultValue.getCount(), FacetRefinement.withProtoMessage(facetResultValue.getRefinement()).toTokenString());
    }

    public String toString() {
        return new Util.ToStringHelper("FacetResultValue").addField("label", this.getLabel()).addField("count", this.getCount()).addField("refinementToken", this.getRefinementToken()).finish();
    }
}

