/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.googleapis.json;

import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.json.GenericJson;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.appengine.repackaged.com.google.api.client.util.Data;
import com.google.appengine.repackaged.com.google.api.client.util.Key;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class GoogleJsonError
extends GenericJson {
    @Key
    private List<ErrorInfo> errors;
    @Key
    private int code;
    @Key
    private String message;
    @Key
    private List<Details> details;

    public static GoogleJsonError parse(JsonFactory jsonFactory, HttpResponse response) throws IOException {
        JsonObjectParser jsonObjectParser = new JsonObjectParser.Builder(jsonFactory).setWrapperKeys(Collections.singleton("error")).build();
        return jsonObjectParser.parseAndClose(response.getContent(), response.getContentCharset(), GoogleJsonError.class);
    }

    public final List<ErrorInfo> getErrors() {
        return this.errors;
    }

    public final void setErrors(List<ErrorInfo> errors) {
        this.errors = ImmutableList.copyOf(errors);
    }

    public final int getCode() {
        return this.code;
    }

    public final void setCode(int code) {
        this.code = code;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    public List<Details> getDetails() {
        return this.details;
    }

    public void setDetails(List<Details> details) {
        this.details = ImmutableList.copyOf(details);
    }

    @Override
    public GoogleJsonError set(String fieldName, Object value) {
        return (GoogleJsonError)super.set(fieldName, value);
    }

    @Override
    public GoogleJsonError clone() {
        return (GoogleJsonError)super.clone();
    }

    static {
        Data.nullOf(ErrorInfo.class);
    }

    public static class ParameterViolations {
        @Key
        private String parameter;
        @Key
        private String description;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getParameter() {
            return this.parameter;
        }

        public void setParameter(String parameter) {
            this.parameter = parameter;
        }
    }

    public static class Details {
        @Key(value="@type")
        private String type;
        @Key
        private String detail;
        @Key
        private String reason;
        @Key
        private List<ParameterViolations> parameterViolations;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public List<ParameterViolations> getParameterViolations() {
            return this.parameterViolations;
        }

        public void setParameterViolations(List<ParameterViolations> parameterViolations) {
            this.parameterViolations = ImmutableList.copyOf(parameterViolations);
        }
    }

    public static class ErrorInfo
    extends GenericJson {
        @Key
        private String domain;
        @Key
        private String reason;
        @Key
        private String message;
        @Key
        private String location;
        @Key
        private String locationType;

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getLocationType() {
            return this.locationType;
        }

        public final void setLocationType(String locationType) {
            this.locationType = locationType;
        }

        @Override
        public ErrorInfo set(String fieldName, Object value) {
            return (ErrorInfo)super.set(fieldName, value);
        }

        @Override
        public ErrorInfo clone() {
            return (ErrorInfo)super.clone();
        }
    }
}

