/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.dev.FileMetadata;
import com.google.appengine.api.files.dev.LocalFileService;
import com.google.appengine.api.files.dev.ParsedFileName;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.api.ApiProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlobstoreFile
extends FileMetadata {
    Logger logger = Logger.getLogger(BlobstoreFile.class.getName());
    private static final int BUF_SIZE = 4096;
    public static final String FILE_SYSTEM = AppEngineFile.FileSystem.BLOBSTORE.getName();
    private static final String PREFIX = "/" + FILE_SYSTEM + "/";
    public static final String CREATION_HANDLE_PREFIX = "writable:";
    static final String PARAMETER_MIME_TYPE = "content_type";
    static final String PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME = "file_name";
    static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private final String namePart;
    private BlobKey blobKey;
    private final String mimeType;
    private final String blobInfoUploadedFileName;
    private String currentSequenceKey;
    private ByteArrayOutputStream tempBytes = new ByteArrayOutputStream();
    private final LocalFileService localFileService;
    private final Clock clock;

    public static String buildFullPath(String namePart) {
        return PREFIX + namePart;
    }

    private BlobstoreFile(FileServicePb.FileContentType.ContentType contentType, String namePart, BlobKey blobKey, boolean finalized, Map<String, String> parameters, LocalFileService localFileService, Clock clock) {
        super(contentType);
        this.namePart = namePart;
        this.localFileService = localFileService;
        this.clock = clock;
        this.finalized = finalized;
        this.blobKey = blobKey;
        if (parameters != null) {
            this.mimeType = parameters.containsKey(PARAMETER_MIME_TYPE) ? parameters.get(PARAMETER_MIME_TYPE) : DEFAULT_MIME_TYPE;
            this.blobInfoUploadedFileName = parameters.containsKey(PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME) ? parameters.get(PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME) : "";
        } else {
            this.mimeType = DEFAULT_MIME_TYPE;
            this.blobInfoUploadedFileName = "";
        }
    }

    public static boolean isSpecialReadOnlyName(ParsedFileName parsedName) {
        String namePart = parsedName.getNamePart();
        return !namePart.startsWith(CREATION_HANDLE_PREFIX);
    }

    public static FileMetadata newInstance(LocalFileService localFileService, Clock clock, ParsedFileName parsedName, FileServicePb.OpenRequest.OpenMode openMode, FileServicePb.FileContentType.ContentType contentType, Map<String, String> parameters) {
        String namePart = parsedName.getNamePart();
        if (FileServicePb.OpenRequest.OpenMode.READ == openMode && !namePart.startsWith(CREATION_HANDLE_PREFIX)) {
            BlobKey blobKey = new BlobKey(namePart);
            return new BlobstoreFile(contentType, namePart, blobKey, true, null, localFileService, clock);
        }
        return new BlobstoreFile(contentType, namePart, null, false, parameters, localFileService, clock);
    }

    @Override
    public void append(FileServicePb.AppendRequest request) {
        String sequenceKey = request.getSequenceKey();
        if (null != sequenceKey && sequenceKey.isEmpty()) {
            sequenceKey = null;
        }
        if (null != this.currentSequenceKey && (null == sequenceKey || sequenceKey.compareTo(this.currentSequenceKey) <= 0)) {
            throw new ApiProxy.ApplicationException(300, this.currentSequenceKey);
        }
        this.currentSequenceKey = sequenceKey;
        try {
            ByteString data = request.getData();
            this.tempBytes.write(data.toByteArray());
        }
        catch (IOException e) {
            throw new ApiProxy.ApplicationException(7, e.getMessage());
        }
    }

    @Override
    public void setFinalized() {
        this.finalized = true;
        BlobStorage blobStorage = this.localFileService.getBlobStorage();
        String blobKeyString = this.localFileService.nextRandomString();
        this.blobKey = new BlobKey(blobKeyString);
        try {
            OutputStream outStream = blobStorage.storeBlob(this.blobKey);
            this.tempBytes.writeTo(outStream);
            outStream.close();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Caught IOException while attempting to write to the blobstore", e);
            throw new ApiProxy.ApplicationException(7, e.getMessage());
        }
        BlobInfo blobInfo = new BlobInfo(this.blobKey, this.mimeType, new Date(this.clock.getCurrentTime()), this.blobInfoUploadedFileName, (long)this.tempBytes.size());
        this.localFileService.saveBlobInfo(blobInfo, this.namePart);
    }

    @Override
    public ByteString read(FileServicePb.ReadRequest request) {
        try {
            InputStream input = this.localFileService.getBlobStorage().fetchBlob(this.blobKey);
            if (null == input) {
                throw new ApiProxy.ApplicationException(7, "blob not found: " + this.blobKey.getKeyString());
            }
            long pos = request.getPos();
            input.skip(pos);
            ByteString.Output output = ByteString.newOutput();
            long maxBytes = request.getMaxBytes();
            BlobstoreFile.copy(input, (OutputStream)output, maxBytes);
            input.close();
            return output.toByteString();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Caught IOException while attempting to read from the blobstore", e);
            throw new ApiProxy.ApplicationException(7, e.getMessage());
        }
    }

    private static long copy(InputStream from, OutputStream to, long maxBytes) throws IOException {
        int r;
        int batchSize;
        byte[] buf = new byte[4096];
        long totalCopied = 0L;
        while ((batchSize = Math.min((int)(maxBytes - totalCopied), 4096)) >= 1 && (r = from.read(buf, 0, batchSize)) != -1) {
            to.write(buf, 0, r);
            totalCopied += (long)r;
        }
        return totalCopied;
    }

    String getNamePart() {
        return this.namePart;
    }

    BlobKey getBlobKey() {
        return this.blobKey;
    }
}

