/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.ResultState;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.internal.DataTypeConverter;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.protos.cloud.sql.Client;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ResultSets {
    private static final Logger logger = Logger.getLogger(ResultSets.class.getCanonicalName());

    private ResultSets() {
    }

    static ResultState populateResultFromResultSet(Client.ResultProto.Builder resultBuilder, Statement statement, ResultSet rs, int maxRows) throws SQLException {
        Client.RowSetProto.Builder rowSetBuilder = Client.RowSetProto.newBuilder();
        ResultSetMetaData rsmd = rs.getMetaData();
        ResultSets.populateRowSetFromResultSetMetaData(rowSetBuilder, rsmd);
        int row = 1;
        boolean moreRows = false;
        while (rs.next()) {
            ResultSets.populateRowSetFromResultSet(rowSetBuilder, rsmd, rs);
            if (maxRows == -1 || row++ != maxRows) continue;
            moreRows = true;
            break;
        }
        resultBuilder.setRows(rowSetBuilder);
        if (statement == null) {
            return ResultState.noMoreResults();
        }
        return moreRows ? new ResultState(true, true, -1) : ResultSets.checkForMoreResultsAndAdvanceResultSet(statement);
    }

    static ResultState checkForMoreResultsAndAdvanceResultSet(Statement statement) throws SQLException {
        int updateCount;
        block3: {
            try {
                if (statement.getMoreResults(2)) {
                    return new ResultState(true, false, -1);
                }
            }
            catch (SQLException e) {
                if (!statement.getMoreResults()) break block3;
                return new ResultState(true, false, -1);
            }
        }
        return new ResultState((updateCount = statement.getUpdateCount()) != -1, false, updateCount);
    }

    static void populateRowSetFromResultSet(Client.RowSetProto.Builder rowSetBuilder, ResultSetMetaData rsmd, ResultSet rs) throws SQLException {
        Client.TupleProto.Builder tupleBuilder = Client.TupleProto.newBuilder();
        for (int colNum = 1; colNum <= rsmd.getColumnCount(); ++colNum) {
            JdbcType jdbcType = JdbcType.fromCode((int)rsmd.getColumnType(colNum));
            DataTypeConverter converter = jdbcType.getConverter();
            Object o = rs.getObject(colNum);
            if (rs.wasNull()) {
                tupleBuilder.addNulls(colNum - 1);
                continue;
            }
            ByteString value = converter.toByteString(o);
            tupleBuilder.addValues(value);
        }
        rowSetBuilder.addTuples(tupleBuilder);
    }

    private static void populateRowSetFromResultSetMetaData(Client.RowSetProto.Builder rowSetBuilder, ResultSetMetaData rsmd) {
        int columnCount;
        try {
            columnCount = rsmd.getColumnCount();
        }
        catch (SQLException e) {
            return;
        }
        for (int col = 1; col <= columnCount; ++col) {
            Client.ColumnProto.Builder columnBuilder = Client.ColumnProto.newBuilder();
            try {
                String name = rsmd.getColumnName(col);
                if (name == null) {
                    name = "Column #" + col;
                }
                columnBuilder.setName(name);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getColumnName", e);
            }
            try {
                String label = rsmd.getColumnLabel(col);
                if (label != null) {
                    columnBuilder.setLabel(label);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getColumnLabel", e);
            }
            try {
                JdbcType jdbcType = JdbcType.fromCode((int)rsmd.getColumnType(col));
                columnBuilder.setType(jdbcType.getCode());
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getColumnType", e);
            }
            try {
                String tableName = rsmd.getTableName(col);
                if (tableName != null) {
                    columnBuilder.setTableName(tableName);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getTableName", e);
            }
            try {
                String schemaName = rsmd.getSchemaName(col);
                if (schemaName != null) {
                    columnBuilder.setSchemaName(schemaName);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getSchemaName", e);
            }
            try {
                String catalogName = rsmd.getCatalogName(col);
                if (catalogName != null) {
                    columnBuilder.setCatalogName(catalogName);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getCatalogName", e);
            }
            try {
                columnBuilder.setPrecision(rsmd.getPrecision(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getPrecision", e);
            }
            try {
                columnBuilder.setScale(rsmd.getScale(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getScale", e);
            }
            try {
                columnBuilder.setNullable(1 == rsmd.isNullable(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isNullable", e);
            }
            try {
                columnBuilder.setSearchable(rsmd.isSearchable(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isSearchable", e);
            }
            try {
                columnBuilder.setDisplaySize(rsmd.getColumnDisplaySize(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getColumnDisplaySize", e);
                try {
                    columnBuilder.setDisplaySize(String.valueOf(rsmd.getColumnLabel(col)).length() + 2);
                }
                catch (SQLException e2) {
                    logger.log(Level.WARNING, "getColumnDisplaySize && getColumnLabel", e2);
                }
            }
            try {
                columnBuilder.setAutoIncrement(rsmd.isAutoIncrement(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isAutoIncrement", e);
            }
            try {
                columnBuilder.setCaseSensitive(rsmd.isCaseSensitive(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isCaseSensitive", e);
            }
            try {
                columnBuilder.setCurrency(rsmd.isCurrency(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isCurrency", e);
            }
            try {
                columnBuilder.setDefinitelyWritable(rsmd.isDefinitelyWritable(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isDefinitelyWritable", e);
            }
            try {
                columnBuilder.setReadOnly(rsmd.isReadOnly(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isReadOnly", e);
            }
            try {
                columnBuilder.setSigned(rsmd.isSigned(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isSigned", e);
            }
            try {
                columnBuilder.setWritable(rsmd.isWritable(col));
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "isWritable", e);
            }
            try {
                String columnTypeName = rsmd.getColumnTypeName(col);
                if (columnTypeName != null) {
                    columnBuilder.setColumnTypeName(columnTypeName);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "getColumnTypeName", e);
            }
            rowSetBuilder.addColumns(columnBuilder);
        }
    }
}

