/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.GeometricTokenStream;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.document.AbstractField;
import com.google.appengine.repackaged.org.apache.lucene.document.Field;
import com.google.apphosting.api.search.DocumentPb;
import java.io.Reader;

class GeometricField
extends AbstractField {
    static final double EARTH_RADIUS_METERS = 6371010.0;
    static final int MIN_LEVEL = 0;
    static final int MAX_LEVEL = 30;

    GeometricField(String name, DocumentPb.FieldValue.Geo value) {
        super(name, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.NO);
        this.fieldsData = value;
    }

    private DocumentPb.FieldValue.Geo data() {
        if (this.fieldsData instanceof DocumentPb.FieldValue.Geo) {
            return (DocumentPb.FieldValue.Geo)this.fieldsData;
        }
        return null;
    }

    @Override
    public String stringValue() {
        DocumentPb.FieldValue.Geo data = this.data();
        return data != null ? data.getLat() + "," + data.getLng() : null;
    }

    @Override
    public Reader readerValue() {
        return null;
    }

    @Override
    public byte[] binaryValue() {
        return null;
    }

    @Override
    public TokenStream tokenStreamValue() {
        DocumentPb.FieldValue.Geo value = this.data();
        S2LatLng point = S2LatLng.fromDegrees(value.getLat(), value.getLng());
        return new GeometricTokenStream(point.normalized());
    }
}

