/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.geometry.R2Rect;
import com.google.appengine.repackaged.com.google.common.geometry.R2Vector;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2PaddedCell;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import com.google.appengine.repackaged.com.google.common.geometry.S2ShapeIndex;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

@GwtCompatible
public class S2EdgeQuery {
    private final S2ShapeIndex index;
    private final List<S2ShapeIndex.Cell> cells;
    private final S2ShapeIndex.CellIterator iter;
    private static final Edges EMPTY_EDGE_LIST = new Edges(){

        @Override
        public int nextEdge() {
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    public S2EdgeQuery(S2ShapeIndex index) {
        this.index = index;
        this.iter = index.iterator();
        this.cells = Lists.newArrayList();
    }

    public Edges getCandidates(S2Point a, S2Point b, S2Shape shape) {
        int maxBruteForceEdges = 27;
        int maxEdges = shape.numEdges();
        if (maxEdges <= maxBruteForceEdges) {
            return new ShapeEdges(shape.numEdges());
        }
        this.getCells(a, b);
        if (this.cells.isEmpty()) {
            return EMPTY_EDGE_LIST;
        }
        if (this.cells.size() == 1) {
            S2ShapeIndex.S2ClippedShape clippedShape = this.cells.get(0).findClipped(shape);
            if (clippedShape == null || clippedShape.numEdges() == 0) {
                return EMPTY_EDGE_LIST;
            }
            return new SimpleEdges(clippedShape);
        }
        MergedEdges edges = new MergedEdges();
        for (int i = 0; i < this.cells.size(); ++i) {
            S2ShapeIndex.S2ClippedShape clippedShape = this.cells.get(i).findClipped(shape);
            if (clippedShape == null || clippedShape.numEdges() == 0) continue;
            edges.add(clippedShape);
        }
        return edges;
    }

    public Map<S2Shape, Edges> getCandidates(S2Point a, S2Point b) {
        if (this.index.shapes.size() == 1) {
            S2Shape shape = this.index.shapes.get(0);
            Edges edges = this.getCandidates(a, b, shape);
            if (edges.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(shape, edges);
        }
        this.getCells(a, b);
        if (this.cells.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.cells.size() == 1) {
            S2ShapeIndex.Cell cell = this.cells.get(0);
            if (cell.numShapes() == 1) {
                S2ShapeIndex.S2ClippedShape clippedShape = cell.clipped(0);
                if (clippedShape.numEdges() == 0) {
                    return Collections.emptyMap();
                }
                S2Shape shape = cell.clipped(0).shape();
                return Collections.singletonMap(shape, new SimpleEdges(clippedShape));
            }
            IdentityHashMap edgeMap = Maps.newIdentityHashMap();
            for (int j = 0; j < cell.numShapes(); ++j) {
                S2ShapeIndex.S2ClippedShape clippedShape = cell.clipped(j);
                if (clippedShape.numEdges() <= 0) continue;
                S2Shape shape = clippedShape.shape();
                edgeMap.put(shape, new SimpleEdges(clippedShape));
            }
            return edgeMap;
        }
        IdentityHashMap edgeMap = Maps.newIdentityHashMap();
        for (int i = 0; i < this.cells.size(); ++i) {
            S2ShapeIndex.Cell cell = this.cells.get(i);
            for (int j = 0; j < cell.numShapes(); ++j) {
                S2ShapeIndex.S2ClippedShape clippedShape = cell.clipped(j);
                if (clippedShape.numEdges() == 0) continue;
                S2Shape shape = clippedShape.shape();
                MergedEdges edges = (MergedEdges)edgeMap.get(shape);
                if (edges == null) {
                    edges = new MergedEdges();
                    edgeMap.put(shape, edges);
                }
                edges.add(clippedShape);
            }
        }
        return edgeMap;
    }

    private void getCells(S2Point a, S2Point b) {
        this.cells.clear();
        S2EdgeUtil.FaceSegment[] segments = new S2EdgeUtil.FaceSegment[6];
        int numSegments = S2EdgeUtil.getFaceSegments(a, b, segments);
        for (int i = 0; i < numSegments; ++i) {
            R2Rect edgeBound = R2Rect.fromPointPair(segments[i].a, segments[i].b);
            S2PaddedCell pCell = new S2PaddedCell(S2CellId.fromFace(segments[i].face), 0.0);
            S2CellId edgeRoot = pCell.shrinkToFit(edgeBound);
            S2ShapeIndex.CellRelation relation = this.iter.locate(edgeRoot);
            if (relation == S2ShapeIndex.CellRelation.INDEXED) {
                this.cells.add(this.iter.cell());
                continue;
            }
            if (relation != S2ShapeIndex.CellRelation.SUBDIVIDED) continue;
            if (!edgeRoot.isFace()) {
                pCell = new S2PaddedCell(edgeRoot, 0.0);
            }
            this.getCells(pCell, edgeBound, segments[i].a, segments[i].b);
        }
    }

    public boolean getCells(S2Point a, S2Point b, S2PaddedCell root, List<S2ShapeIndex.Cell> cells) {
        R2Vector aVector = new R2Vector();
        R2Vector bVector = new R2Vector();
        return this.getCells(a, aVector, b, bVector, root, cells);
    }

    @VisibleForTesting
    boolean getCells(S2Point a, R2Vector aVector, S2Point b, R2Vector bVector, S2PaddedCell root, List<S2ShapeIndex.Cell> cells) {
        this.cells.clear();
        if (S2EdgeUtil.clipToFace(a, b, root.id().face(), aVector, bVector)) {
            R2Rect edgeBound = R2Rect.fromPointPair(aVector, bVector);
            if (root.bound().intersects(edgeBound)) {
                this.getCells(root, edgeBound, aVector, bVector);
            }
        }
        if (this.cells.isEmpty()) {
            return false;
        }
        cells.addAll(this.cells);
        return true;
    }

    private void getCells(S2PaddedCell pCell, R2Rect edgeBound, R2Vector aVector, R2Vector bVector) {
        this.iter.seek(pCell.id().rangeMin());
        if (this.iter.done() || this.iter.id().greaterThan(pCell.id().rangeMax())) {
            return;
        }
        if (this.iter.id().equals(pCell.id())) {
            this.cells.add(this.iter.cell());
            return;
        }
        R2Vector center = pCell.middle().lo();
        if (edgeBound.x().hi() < center.x()) {
            this.clipVAxis(edgeBound, center.y(), 0, pCell, aVector, bVector);
        } else if (edgeBound.x().lo() >= center.x()) {
            this.clipVAxis(edgeBound, center.y(), 1, pCell, aVector, bVector);
        } else {
            R2Rect[] childBounds = new R2Rect[2];
            this.splitUBound(edgeBound, center.x(), childBounds, aVector, bVector);
            if (edgeBound.y().hi() < center.y()) {
                this.getCells(pCell.childAtIJ(0, 0), childBounds[0], aVector, bVector);
                this.getCells(pCell.childAtIJ(1, 0), childBounds[1], aVector, bVector);
            } else if (edgeBound.y().lo() >= center.y()) {
                this.getCells(pCell.childAtIJ(0, 1), childBounds[0], aVector, bVector);
                this.getCells(pCell.childAtIJ(1, 1), childBounds[1], aVector, bVector);
            } else {
                this.clipVAxis(childBounds[0], center.y(), 0, pCell, aVector, bVector);
                this.clipVAxis(childBounds[1], center.y(), 1, pCell, aVector, bVector);
            }
        }
    }

    private void clipVAxis(R2Rect edgeBound, double center, int i, S2PaddedCell pCell, R2Vector aVector, R2Vector bVector) {
        if (edgeBound.y().hi() < center) {
            this.getCells(pCell.childAtIJ(i, 0), edgeBound, aVector, bVector);
        } else if (edgeBound.y().lo() >= center) {
            this.getCells(pCell.childAtIJ(i, 1), edgeBound, aVector, bVector);
        } else {
            R2Rect[] childBounds = new R2Rect[2];
            this.splitVBound(edgeBound, center, childBounds, aVector, bVector);
            this.getCells(pCell.childAtIJ(i, 0), childBounds[0], aVector, bVector);
            this.getCells(pCell.childAtIJ(i, 1), childBounds[1], aVector, bVector);
        }
    }

    private void splitUBound(R2Rect edgeBound, double u, R2Rect[] childBounds, R2Vector aVector, R2Vector bVector) {
        double v = edgeBound.y().clampPoint(S2EdgeUtil.interpolateDouble(u, aVector.x, bVector.x, aVector.y, bVector.y));
        int diag = aVector.x > bVector.x != aVector.y > bVector.y ? 1 : 0;
        this.splitBound(edgeBound, 0, u, diag, v, childBounds);
    }

    private void splitVBound(R2Rect edgeBound, double v, R2Rect[] childBounds, R2Vector aVector, R2Vector bVector) {
        double u = edgeBound.x().clampPoint(S2EdgeUtil.interpolateDouble(v, aVector.y, bVector.y, aVector.x, bVector.x));
        int diag = aVector.x > bVector.x != aVector.y > bVector.y ? 1 : 0;
        this.splitBound(edgeBound, diag, u, 0, v, childBounds);
    }

    private void splitBound(R2Rect edgeBound, int uEnd, double u, int vEnd, double v, R2Rect[] childBounds) {
        childBounds[0] = new R2Rect(edgeBound);
        childBounds[1] = new R2Rect(edgeBound);
        if (uEnd == 0) {
            childBounds[0].x().setHi(u);
            childBounds[1].x().setLo(u);
        } else {
            childBounds[0].x().setLo(u);
            childBounds[1].x().setHi(u);
        }
        if (vEnd == 0) {
            childBounds[0].y().setHi(v);
            childBounds[1].y().setLo(v);
        } else {
            childBounds[0].y().setLo(v);
            childBounds[1].y().setHi(v);
        }
    }

    private static final class Stepper
    implements Comparable<Stepper> {
        int index = 0;
        final S2ShapeIndex.S2ClippedShape clipped;

        Stepper(S2ShapeIndex.S2ClippedShape shape) {
            this.clipped = shape;
        }

        int currentEdge() {
            return this.clipped.edge(this.index);
        }

        @Override
        public int compareTo(Stepper that) {
            return Integer.compare(this.currentEdge(), that.currentEdge());
        }
    }

    public static final class ShapeEdges
    implements Edges {
        private int edgeIndex = 0;
        private final int numEdges;

        ShapeEdges(int numEdges) {
            this.numEdges = numEdges;
        }

        @Override
        public int nextEdge() {
            int n;
            Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"Cannot call nextEdge() on empty Edges.");
            if (this.edgeIndex < this.numEdges) {
                int n2 = this.edgeIndex;
                n = n2;
                this.edgeIndex = n2 + 1;
            } else {
                n = -1;
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            return this.edgeIndex == this.numEdges;
        }
    }

    private static final class MergedEdges
    implements Edges {
        final PriorityQueue<Stepper> steppers = new PriorityQueue();
        Stepper top;

        private MergedEdges() {
        }

        public void add(S2ShapeIndex.S2ClippedShape shape) {
            Stepper stepper = new Stepper(shape);
            if (this.top == null) {
                this.top = stepper;
            } else if (this.top.currentEdge() <= stepper.currentEdge()) {
                this.steppers.add(stepper);
            } else {
                this.steppers.add(this.top);
                this.top = stepper;
            }
        }

        @Override
        public int nextEdge() {
            Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"Cannot call nextEdge() on empty Edges.");
            int nextEdge = this.top.currentEdge();
            this.removeFromPriorityQueue(nextEdge);
            ++this.top.index;
            if (this.top.index == this.top.clipped.numEdges()) {
                this.top = this.steppers.isEmpty() ? null : this.steppers.poll();
            } else if (!this.steppers.isEmpty() && this.top.currentEdge() > this.steppers.peek().currentEdge()) {
                this.steppers.add(this.top);
                this.top = this.steppers.poll();
            }
            return nextEdge;
        }

        private void removeFromPriorityQueue(int n) {
            while (!this.steppers.isEmpty() && this.steppers.peek().currentEdge() == n) {
                Stepper stepper = this.steppers.poll();
                ++stepper.index;
                if (stepper.index == stepper.clipped.numEdges()) continue;
                this.steppers.add(stepper);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.top == null;
        }
    }

    private static final class SimpleEdges
    implements Edges {
        int index = 0;
        final S2ShapeIndex.S2ClippedShape shape;

        SimpleEdges(S2ShapeIndex.S2ClippedShape shape) {
            this.shape = shape;
        }

        @Override
        public int nextEdge() {
            Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"Cannot call nextEdge() on empty Edges.");
            if (this.index == this.shape.numEdges()) {
                return -1;
            }
            return this.shape.edge(this.index++);
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.shape.numEdges();
        }
    }

    public static interface Edges {
        public int nextEdge();

        public boolean isEmpty();
    }
}

