/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.Scorer;
import com.google.appengine.repackaged.com.google.appengine.api.search.proto.SearchServicePb;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.search.IndexSearcher;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.appengine.repackaged.org.apache.lucene.search.ScoreDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.TopDocs;
import com.google.apphosting.api.search.DocumentPb;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class MatchScorer
extends Scorer {
    public static Scorer newInstance(SearchServicePb.SearchParams searchParams, Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        return new MatchScorer();
    }

    @Override
    public Scorer.SearchResults search(IndexSearcher indexSearcher, Query q, int offset, int limit) throws IOException {
        TopDocs topDocs = indexSearcher.search(q, null, offset + limit);
        int numResults = Math.max(0, topDocs.scoreDocs.length - offset);
        Scorer.Result[] results = new Result[numResults];
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        for (int i = 0; i < numResults; ++i) {
            ScoreDoc scoreDoc = scoreDocs[i + offset];
            results[i] = new Result(indexSearcher.doc(scoreDoc.doc), scoreDoc.score);
        }
        return new Scorer.SearchResults(results, topDocs.totalHits);
    }

    public static class Result
    extends Scorer.Result {
        public float score;

        Result(Document doc, float score) {
            super(doc);
            this.score = score;
        }

        @Override
        public void addScores(SearchServicePb.SearchResult.Builder resultBuilder) {
            resultBuilder.addScore((double)this.score);
        }
    }
}

