/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Predicates;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@GwtCompatible
public class S2ContainsVertexQuery {
    private final S2Point target;
    private final List<S2Point> outgoing = new ArrayList<S2Point>();
    private final List<S2Point> incoming = new ArrayList<S2Point>();

    public S2ContainsVertexQuery(S2Point target) {
        this.target = target;
    }

    public void addOutgoing(S2Point v) {
        this.outgoing.add(v);
    }

    public void addIncoming(S2Point v) {
        this.incoming.add(v);
    }

    public int containsSign() {
        S2Point referenceDir;
        S2Point bestPoint = referenceDir = S2.ortho(this.target);
        int bestSum = 0;
        Collections.sort(this.outgoing);
        Collections.sort(this.incoming);
        int out = 0;
        int in = 0;
        while (out < this.outgoing.size() || in < this.incoming.size()) {
            int direction;
            S2Point v;
            if (out == this.outgoing.size()) {
                v = this.incoming.get(in++);
                direction = -1;
            } else if (in == this.incoming.size()) {
                v = this.outgoing.get(out++);
                direction = 1;
            } else {
                S2Point inPoint;
                S2Point outPoint = this.outgoing.get(out);
                int diff = outPoint.compareTo(inPoint = this.incoming.get(in));
                if (diff < 0) {
                    v = outPoint;
                    direction = S2ContainsVertexQuery.count(this.outgoing, out);
                    out += direction;
                } else if (diff > 0) {
                    v = inPoint;
                    direction = -S2ContainsVertexQuery.count(this.incoming, in);
                    in -= direction;
                } else {
                    v = outPoint;
                    int outSum = S2ContainsVertexQuery.count(this.outgoing, out);
                    int inSum = S2ContainsVertexQuery.count(this.incoming, in);
                    direction = outSum - inSum;
                    out += outSum;
                    in += inSum;
                }
                assert (Math.abs(direction) <= 1);
            }
            if (direction == 0 || !S2Predicates.orderedCCW(referenceDir, bestPoint, v, this.target)) continue;
            bestPoint = v;
            bestSum = direction;
        }
        return bestSum;
    }

    private static int count(List<S2Point> vertices, int start) {
        S2Point v = vertices.get(start);
        int sum = 1;
        for (int i = start + 1; i < vertices.size() && vertices.get(i).equalsPoint(v); ++i) {
            ++sum;
        }
        return sum;
    }
}

