/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

@GwtCompatible(serializable=true)
public strictfp final class S2PointRegion
implements S2Region,
Comparable<S2PointRegion>,
Serializable {
    private static final byte POINT_REGION_LOSSLESS_ENCODING_VERSION = 1;
    private final S2Point point;

    public S2PointRegion() {
        this.point = S2Point.ORIGIN;
    }

    public S2PointRegion(double x, double y, double z) {
        this.point = new S2Point(x, y, z);
    }

    public S2PointRegion(S2Point point) {
        this.point = point;
    }

    public S2Point getPoint() {
        return this.point;
    }

    public double getX() {
        return this.point.getX();
    }

    public double getY() {
        return this.point.getY();
    }

    public double getZ() {
        return this.point.getZ();
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2PointRegion)) {
            return false;
        }
        S2PointRegion thatPointRegion = (S2PointRegion)that;
        return this.getPoint().equalsPoint(thatPointRegion.getPoint());
    }

    public boolean lessThan(S2PointRegion vb) {
        return this.getPoint().lessThan(vb.getPoint());
    }

    @Override
    public int compareTo(S2PointRegion other) {
        return this.lessThan(other) ? -1 : (this.equals(other) ? 0 : 1);
    }

    public String toString() {
        return this.point.toString();
    }

    public String toDegreesString() {
        return this.point.toDegreesString();
    }

    public int hashCode() {
        return this.point.hashCode();
    }

    @Override
    public boolean contains(S2Cell cell) {
        return false;
    }

    @Override
    public boolean contains(S2Point p) {
        return this.getPoint().contains(p);
    }

    @Override
    public S2Cap getCapBound() {
        return S2Cap.fromAxisHeight(this.getPoint(), 0.0);
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2LatLng latLng = new S2LatLng(this.getPoint());
        return S2LatLngRect.fromPoint(latLng);
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        return cell.contains(this.getPoint());
    }

    public void encode(OutputStream os) throws IOException {
        this.encode(new LittleEndianOutput(os));
    }

    void encode(LittleEndianOutput os) throws IOException {
        os.writeByte((byte)1);
        this.point.encode(os);
    }

    public static S2PointRegion decode(InputStream is) throws IOException {
        return S2PointRegion.decode(new LittleEndianInput(is));
    }

    static S2PointRegion decode(LittleEndianInput is) throws IOException {
        byte version = is.readByte();
        if (version != 1) {
            throw new IOException("Unsupported S2PointRegion encoding version " + version);
        }
        return new S2PointRegion(S2Point.decode(is));
    }
}

